<?php
// OTA PULL - CHECK
// GET: ?panel_key=PAINEL-001
// Retorna JSON: {pending:bool, version:string, size:int, sha256:string}

header('Content-Type: application/json; charset=utf-8');

$panel_key = isset($_GET['panel_key']) ? preg_replace('/[^A-Z0-9\-\_]/i','', $_GET['panel_key']) : '';
if ($panel_key === '') {
  http_response_code(400);
  echo json_encode(['error'=>'missing panel_key']);
  exit;
}

$stateFile = __DIR__ . '/storage/state_' . $panel_key . '.json';
if (!file_exists($stateFile)) {
  // sem update
  echo json_encode(['pending'=>false]);
  exit;
}

$state = json_decode(@file_get_contents($stateFile), true);
if (!is_array($state)) $state = [];

$pending = !empty($state['pending']);
$binFile = isset($state['bin_file']) ? basename($state['bin_file']) : '';
$binPath = __DIR__ . '/storage/' . $binFile;

$out = [
  'pending' => $pending,
  'version' => isset($state['version']) ? (string)$state['version'] : '',
  'sha256'  => isset($state['sha256']) ? (string)$state['sha256'] : '',
  'size'    => 0,
];

if ($pending && $binFile && file_exists($binPath)) {
  $out['size'] = filesize($binPath);
} else {
  $out['pending'] = false;
}

echo json_encode($out);