<?php
require_once __DIR__ . '/db.php';
$panel_key = $_GET['panel_key'] ?? '';
if (!$panel_key) { http_response_code(400); header('Content-Type: application/json'); echo json_encode(['error'=>'missing panel_key']); exit; }

$st = $mysqli->prepare("SELECT p.id,p.name,s.client_id FROM panels p JOIN stores s ON s.id=p.store_id WHERE p.panel_key=?");
$st->bind_param('s',$panel_key); $st->execute();
$panel = $st->get_result()->fetch_assoc();
$st->close();
if (!$panel) { http_response_code(404); header('Content-Type: application/json'); echo json_encode(['error'=>'panel not found']); exit; }

$global = $mysqli->query("SELECT * FROM global_settings WHERE id=1")->fetch_assoc();
$mysqli->query("INSERT INTO panel_settings (panel_id) VALUES (".(int)$panel['id'].") ON DUPLICATE KEY UPDATE panel_id=panel_id");
$st = $mysqli->prepare("SELECT * FROM panel_settings WHERE panel_id=?");
$st->bind_param('i',$panel['id']); $st->execute();
$panel_cfg = $st->get_result()->fetch_assoc();
$st->close();

function cfg_pick($g,$p){
  if (isset($p['use_global_anim']) && (int)$p['use_global_anim']===1) {
    return [
      'transition_effect'=>$g['transition_effect'],
      'duration_sec'=>(int)$g['duration_sec'],
      'transition_sec'=>(int)$g['transition_sec'],
      'border_animated'=>(int)$g['border_animated'],
      'border_speed'=>(int)$g['border_speed'],
      'price_blink'=>(int)$g['price_blink']
    ];
  }
  return [
    'transition_effect'=>$p['transition_effect'],
    'duration_sec'=>(int)$p['duration_sec'],
    'transition_sec'=>(int)$p['transition_sec'],
    'border_animated'=>(int)$p['border_animated'],
    'border_speed'=>(int)$p['border_speed'],
    'price_blink'=>(int)$p['price_blink']
  ];
}
$cfg = cfg_pick($global,$panel_cfg);

$items=[];
$st = $mysqli->prepare("SELECT pl.item_type, pl.item_id, pl.position,
                               o.name AS offer_name, o.subtitle, o.subtitle_position, o.title, o.price_cents, o.unit, o.description,
                               m.name AS message_name, m.lines_json
                        FROM panel_playlist pl
                        LEFT JOIN offers o ON (pl.item_type='offer' AND o.id=pl.item_id)
                        LEFT JOIN messages m ON (pl.item_type='message' AND m.id=pl.item_id)
                        WHERE pl.panel_id=? AND pl.enabled=1
                        ORDER BY pl.position ASC, pl.id ASC");
$st->bind_param('i',$panel['id']); $st->execute();
$r=$st->get_result();
while($row=$r->fetch_assoc()){
  if($row['item_type']==='offer'){
    $items[]=[
      'type'=>'offer',
      'id'=>(int)$row['item_id'],
      'name'=>$row['offer_name'],
      'subtitle'=>$row['subtitle'],
      'subtitle_position'=>$row['subtitle_position'] ?: 'above',
      'title'=>$row['title'],
      'price_cents'=>(int)$row['price_cents'],
      'unit'=>$row['unit'],
      'description'=>$row['description']
    ];
  } else {
    $items[]=[
      'type'=>'message',
      'id'=>(int)$row['item_id'],
      'name'=>$row['message_name'],
      'lines_json'=>$row['lines_json']
    ];
  }
}
$st->close();

header('Content-Type: application/json; charset=utf-8');
echo json_encode(['panel'=>['id'=>(int)$panel['id'],'name'=>$panel['name']], 'config'=>$cfg, 'items'=>$items], JSON_UNESCAPED_UNICODE);
