<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$panel_id = intval($_GET['id'] ?? 0);
if ($panel_id <= 0) { echo "Painel inválido."; require 'footer.php'; exit; }

$st = $mysqli->prepare("SELECT p.id,p.name,p.panel_key,s.name AS store_name,c.name AS client_name
                        FROM panels p
                        JOIN stores s ON s.id=p.store_id
                        JOIN clients c ON c.id=s.client_id
                        WHERE p.id=?");
$st->bind_param('i', $panel_id);
$st->execute();
$panel = $st->get_result()->fetch_assoc();
$st->close();
if (!$panel) { echo "Painel não encontrado."; require 'footer.php'; exit; }

$panelKey = $panel['panel_key'];
?>
<h3>Preview do Painel: <?= htmlspecialchars($panel['name']) ?></h3>
<p class="text-muted"><?= htmlspecialchars($panel['client_name']) ?> / <?= htmlspecialchars($panel['store_name']) ?></p>

<div class="row g-3">
  <div class="col-lg-8">
    <div class="card">
      <div class="card-body">
        <canvas id="previewCanvas" width="600" height="600" style="width:600px;height:600px;max-width:100%;background:#000;display:block;"></canvas>
      </div>
    </div>
  </div>
  <div class="col-lg-4">
    <div class="card">
      <div class="card-header"><strong>Teste rápido (só no preview)</strong></div>
      <div class="card-body">
        <label class="form-label">Efeito</label>
        <select id="ctlEffect" class="form-select">
          <option value="fade">Fade</option>
          <option value="slide_left">Entrada Esquerda</option>
          <option value="slide_right">Entrada Direita</option>
          <option value="slide_up">Entrada Cima</option>
          <option value="slide_down">Entrada Baixo</option>
        </select>

        <label class="form-label mt-2">Tempo da oferta (5–15s)</label>
        <input id="ctlDur" type="number" class="form-control" min="5" max="15" value="8">

        <label class="form-label mt-2">Tempo de transição (1–5s)</label>
        <input id="ctlTrans" type="number" class="form-control" min="1" max="5" value="2">

        <div class="form-check mt-3">
          <input class="form-check-input" type="checkbox" id="ctlBorder" checked>
          <label class="form-check-label" for="ctlBorder">Borda animada (3 sim / 2 não)</label>
        </div>
        <label class="form-label mt-2">Velocidade da borda</label>
        <input id="ctlBorderSpeed" type="number" class="form-control" min="1" max="15" value="5">

        <div class="form-check mt-3">
          <input class="form-check-input" type="checkbox" id="ctlBlink" checked>
          <label class="form-check-label" for="ctlBlink">Piscar preço</label>
        </div>

        <label class="form-label mt-3">Fonte (familia CSS)</label>
        <input id="ctlFont" type="text" class="form-control" value="Arial">

        <label class="form-label mt-2">Afinar (0–2)</label>
        <input id="ctlThin" type="number" class="form-control" min="0" max="2" value="1">

        <label class="form-label mt-2">Threshold (150–230)</label>
        <input id="ctlThr" type="number" class="form-control" min="150" max="230" value="205">
      </div>
    </div>
  </div>
</div>

<script src="assets/led_sim.js"></script>
<script>
const PANEL_KEY = <?= json_encode($panelKey) ?>;
const canvas = document.getElementById('previewCanvas');
const m = LED_SIM.makeMatrix();

let payload = null;
let idx = 0;
let lastSwitch = performance.now();
let phase = 'show'; // show | trans
let t0 = performance.now();

function readOverrides(){
  return {
    transition_effect: document.getElementById('ctlEffect').value,
    duration_sec: parseInt(document.getElementById('ctlDur').value||'8',10),
    transition_sec: parseInt(document.getElementById('ctlTrans').value||'2',10),
    border_animated: document.getElementById('ctlBorder').checked ? 1 : 0,
    border_speed: parseInt(document.getElementById('ctlBorderSpeed').value||'5',10),
    price_blink: document.getElementById('ctlBlink').checked ? 1 : 0,
    fontFamily: document.getElementById('ctlFont').value || 'Arial',
    thinPasses: parseInt(document.getElementById('ctlThin').value||'1',10),
    threshold: parseInt(document.getElementById('ctlThr').value||'205',10),
  };
}

async function loadPayload(){
  const res = await fetch('../api/panel_payload.php?panel_key='+encodeURIComponent(PANEL_KEY));
  payload = await res.json();
  idx = 0;
  lastSwitch = performance.now();
}
loadPayload();

function getCurrentItem(){
  if(!payload || !payload.items || !payload.items.length) return null;
  return payload.items[idx % payload.items.length];
}

function tick(){
  requestAnimationFrame(tick);
  if(!payload || !payload.items || !payload.items.length) return;

  const now = performance.now();
  const cfg = Object.assign({}, payload.config || {}, readOverrides());
  const item = getCurrentItem();
  const elapsed = (now - lastSwitch)/1000;

  LED_SIM.clear(m);

  // Draw content
  const tsec = (now - t0)/1000;
  if(item.type==='offer'){
    LED_SIM.renderOffer(m, item, cfg, tsec);
  } else {
    LED_SIM.renderMessage(m, item, cfg, tsec);
  }

  // Border follows content/transitions
  if(cfg.border_animated){
    LED_SIM.drawBorder(m, tsec, cfg.border_speed||5);
  }

  // Transition timing: basic switch; visual effect is best-effort (matrix fade/slide could be added)
  const dur = clamp(cfg.duration_sec||8,5,15);
  if(elapsed >= dur){
    idx = (idx+1) % payload.items.length;
    lastSwitch = now;
  }

  LED_SIM.drawToCanvas(m, canvas);
}
tick();
</script>
<?php require 'footer.php'; ?>
