<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) { echo "Painel inválido."; require 'footer.php'; exit; }

// busca painel
$stmt = $mysqli->prepare("SELECT p.id,p.name,s.name AS store_name,c.id AS client_id,c.name AS client_name
                          FROM panels p
                          JOIN stores s ON s.id=p.store_id
                          JOIN clients c ON c.id=s.client_id
                          WHERE p.id=?");
$stmt->bind_param('i',$id);
$stmt->execute();
$panel = $stmt->get_result()->fetch_assoc();
if (!$panel) { echo "Painel não encontrado."; require 'footer.php'; exit; }

// processa envio
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $ids = $_POST['message_id'] ?? [];
    // limpa associações anteriores
    $stmtDel = $mysqli->prepare("DELETE FROM panel_messages WHERE panel_id=?");
    $stmtDel->bind_param('i',$id);
    $stmtDel->execute();

    // recria playlist na ordem marcada
    $pos = 1;
    if (!empty($ids)) {
        $stmtIns = $mysqli->prepare("INSERT INTO panel_messages (panel_id,message_id,position,enabled) VALUES (?,?,?,1)");
        foreach ($ids as $mid) {
            $mid = intval($mid);
            if ($mid <= 0) continue;
            $stmtIns->bind_param('iii',$id,$mid,$pos);
            $stmtIns->execute();
            $pos++;
        }
    }
    echo '<div class="alert alert-success">Playlist de mensagens atualizada.</div>';
}

// mensagens disponíveis para o cliente
$resMessages = $mysqli->query("SELECT * FROM messages WHERE client_id=".(int)$panel['client_id']." AND enabled=1 ORDER BY name");

// mensagens já associadas
$assoc = [];
$resAssoc = $mysqli->query("SELECT message_id,position FROM panel_messages WHERE panel_id=".(int)$id." ORDER BY position");
while($a=$resAssoc->fetch_assoc()) $assoc[$a['message_id']] = $a['position'];
?>
<h3>Mensagens do Painel</h3>
<p><strong>Cliente:</strong> <?= htmlspecialchars($panel['client_name']) ?><br>
   <strong>Loja:</strong> <?= htmlspecialchars($panel['store_name']) ?><br>
   <strong>Painel:</strong> <?= htmlspecialchars($panel['name']) ?></p>

<form method="post">
  <p>Selecione as mensagens que irão aparecer neste painel (a ordem é a ordem de marcação):</p>
  <div class="mb-3" style="max-height:400px; overflow:auto;">
    <?php while($m=$resMessages->fetch_assoc()): ?>
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="message_id[]" value="<?= $m['id'] ?>"
          id="msg_<?= $m['id'] ?>" <?= isset($assoc[$m['id']])?'checked':'' ?>>
        <label class="form-check-label" for="msg_<?= $m['id'] ?>">
          <?= htmlspecialchars($m['name']) ?>
        </label>
      </div>
    <?php endwhile; ?>
  </div>
  <button class="btn btn-primary" type="submit">Salvar Playlist de Mensagens</button>
  <a href="panels_list.php" class="btn btn-secondary">Voltar</a>
</form>
<?php require 'footer.php'; ?>
