<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master','admin_cliente']);

$id = intval($_GET['id'] ?? 0);
$panel = ['id'=>0,'store_id'=>0,'name'=>'','panel_key'=>'','width'=>96,'height'=>96,'brightness'=>10,'is_active'=>1];

if ($id > 0) {
    $stmt = $mysqli->prepare("SELECT * FROM panels WHERE id=?");
    $stmt->bind_param('i',$id);
    $stmt->execute();
    $panel = $stmt->get_result()->fetch_assoc();
    if (!$panel) { echo "Painel não encontrado."; require 'footer.php'; exit; }
}

// lojas disponíveis
if (is_admin_master()) {
    $res = $mysqli->query("SELECT s.id,s.name,c.name AS client_name FROM stores s JOIN clients c ON c.id=s.client_id ORDER BY c.name,s.name");
} else {
    $res = $mysqli->query("SELECT s.id,s.name,c.name AS client_name FROM stores s JOIN clients c ON c.id=s.client_id WHERE c.id=".(int)$user['client_id']." ORDER BY s.name");
}
$stores = [];
while($s=$res->fetch_assoc()) $stores[]=$s;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $store_id   = intval($_POST['store_id'] ?? 0);
    $name       = $_POST['name'] ?? '';
    $panel_key  = $_POST['panel_key'] ?? '';
    $width      = intval($_POST['width'] ?? 96);
    $height     = intval($_POST['height'] ?? 96);
    $brightness = intval($_POST['brightness'] ?? 10);
    $is_active  = isset($_POST['is_active']) ? 1 : 0;

    if ($id > 0) {
        $stmt = $mysqli->prepare("UPDATE panels SET store_id=?, name=?, panel_key=?, width=?, height=?, brightness=?, is_active=? WHERE id=?");
        $stmt->bind_param('issiiiii',$store_id,$name,$panel_key,$width,$height,$brightness,$is_active,$id);
    } else {
        $stmt = $mysqli->prepare("INSERT INTO panels (store_id,name,panel_key,width,height,brightness,is_active) VALUES (?,?,?,?,?,?,?)");
        $stmt->bind_param('issiiii',$store_id,$name,$panel_key,$width,$height,$brightness,$is_active);
    }
    if ($stmt->execute()) {
        header('Location: panels_list.php');
        exit;
    } else {
        echo '<div class="alert alert-danger">Erro ao salvar.</div>';
    }
}
?>
<h3><?= $id>0 ? 'Editar' : 'Novo' ?> Painel</h3>
<form method="post" style="max-width:500px;">
  <div class="mb-3">
    <label class="form-label">Loja</label>
    <select name="store_id" class="form-select" required>
      <?php foreach($stores as $s): ?>
        <option value="<?= $s['id'] ?>" <?= $s['id']==$panel['store_id']?'selected':'' ?>>
          <?= htmlspecialchars($s['client_name'].' - '.$s['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Nome do Painel</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($panel['name']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Panel Key (usar no ESP32)</label>
    <input type="text" name="panel_key" class="form-control" value="<?= htmlspecialchars($panel['panel_key']) ?>" required>
  </div>
  <div class="row mb-3">
    <div class="col">
      <label class="form-label">Largura</label>
      <input type="number" name="width" class="form-control" value="<?= htmlspecialchars($panel['width']) ?>">
    </div>
    <div class="col">
      <label class="form-label">Altura</label>
      <input type="number" name="height" class="form-control" value="<?= htmlspecialchars($panel['height']) ?>">
    </div>
    <div class="col">
      <label class="form-label">Brilho</label>
      <input type="number" name="brightness" class="form-control" value="<?= htmlspecialchars($panel['brightness']) ?>">
    </div>
  </div>
  <div class="form-check mb-3">
    <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= $panel['is_active']?'checked':'' ?>>
    <label class="form-check-label" for="is_active">Ativo</label>
  </div>
  <button class="btn btn-primary" type="submit">Salvar</button>
  <a href="panels_list.php" class="btn btn-secondary">Voltar</a>
</form>
<?php require 'footer.php'; ?>
