<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master','admin_cliente']);

$client_id = is_admin_master() ? intval($_GET['client_id'] ?? 0) : intval($user['client_id']);

if (is_admin_master() && $client_id<=0) {
  $clients = $mysqli->query("SELECT id,name FROM clients ORDER BY name")->fetch_all(MYSQLI_ASSOC);
} else { $clients = []; }

$rows = [];
if ($client_id>0) {
  $st = $mysqli->prepare("SELECT id, name, title, updated_at FROM offers WHERE client_id=? ORDER BY updated_at DESC, id DESC");
  $st->bind_param('i',$client_id); $st->execute();
  $r = $st->get_result();
  while($row=$r->fetch_assoc()) $rows[]=$row;
  $st->close();
}
?>
<h3>Conteúdos</h3>
<ul class="nav nav-tabs mb-3">
  <li class="nav-item"><a class="nav-link active" href="offers_list.php<?= is_admin_master() ? '?client_id='.(int)$client_id : '' ?>">Ofertas</a></li>
  <li class="nav-item"><a class="nav-link" href="messages_list.php<?= is_admin_master() ? '?client_id='.(int)$client_id : '' ?>">Mensagens</a></li>
</ul>

<div class="d-flex justify-content-between align-items-center mb-3">
  <div class="d-flex gap-2 align-items-center">
    <?php if (is_admin_master()): ?>
      <form method="get" class="d-flex gap-2">
        <select name="client_id" class="form-select" style="max-width:280px">
          <option value="0">Selecione um cliente</option>
          <?php foreach($clients as $c): ?>
            <option value="<?= (int)$c['id'] ?>" <?= ((int)$c['id']===$client_id?'selected':'') ?>><?= htmlspecialchars($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
        <button class="btn btn-outline-secondary">Filtrar</button>
      </form>
    <?php else: ?>
      <span class="text-muted">Cliente: #<?= (int)$client_id ?></span>
    <?php endif; ?>
  </div>
  <?php if ($client_id>0): ?><a class="btn btn-primary" href="offer_edit.php?id=0">+ Nova Oferta</a><?php endif; ?>
</div>

<?php if ($client_id<=0): ?>
  <div class="alert alert-info">Selecione um cliente.</div>
<?php elseif (!$rows): ?>
  <div class="alert alert-warning">Nenhuma oferta cadastrada.</div>
<?php else: ?>
  <div class="row g-3">
    <?php foreach($rows as $o): ?>
      <div class="col-md-4">
        <div class="card">
          <div class="card-header d-flex justify-content-between align-items-center">
            <strong><?= htmlspecialchars($o['name']) ?></strong>
            <a class="btn btn-sm btn-outline-primary" href="offer_edit.php?id=<?= (int)$o['id'] ?>">Editar</a>
          </div>
          <div class="card-body">
            <div class="ratio" style="--bs-aspect-ratio:100%;">
              <iframe src="panel_preview.php?mode=thumb&offer_id=<?= (int)$o['id'] ?>" style="border:0;width:100%;height:100%;"></iframe>
            </div>
            <div class="text-muted small mt-2"><?= htmlspecialchars($o['title']) ?></div>
          </div>
          <div class="card-footer d-flex justify-content-between">
            <span class="text-muted small"><?= htmlspecialchars($o['updated_at']) ?></span>
            <a class="btn btn-sm btn-outline-secondary" href="mass_assign.php?pick=offer&item_id=<?= (int)$o['id'] ?>">Enviar</a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
<?php require 'footer.php'; ?>
