<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$id = intval($_GET['id'] ?? 0);
$offer = [
  'id'=>0,
  'client_id'=>$user['client_id'],
  'name'=>'',
  'header'=>'HORTIFRUTI',
  'title'=>'',
  'subtitle'=>'',
  'price_cents'=>0,
  'unit'=>'KG',
  'aux'=>'',
  'footer'=>'',
  'duration_sec'=>5,
  'enabled'=>1,
  'opt_half_screen'=>0,
  'opt_enable_subtitle'=>0,
  'opt_disable_cents'=>0,
  'opt_3_digits_cents'=>0,
  'opt_small_cents'=>1
];

if ($id > 0) {
    $stmt = $mysqli->prepare("SELECT * FROM offers WHERE id=?");
    $stmt->bind_param('i',$id);
    $stmt->execute();
    $offer = $stmt->get_result()->fetch_assoc();
    if (!$offer) { echo "Oferta não encontrada."; require 'footer.php'; exit; }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $client_id = is_admin_master() ? intval($_POST['client_id'] ?? $user['client_id']) : $user['client_id'];
    $name = $_POST['name'] ?? '';
    $header = $_POST['header'] ?? '';
    $title = $_POST['title'] ?? '';
    $subtitle = $_POST['subtitle'] ?? '';
    $price = floatval(str_replace(',', '.', $_POST['price'] ?? '0'));
    $price_cents = intval(round($price * 100));
    $unit = $_POST['unit'] ?? '';
    $aux = $_POST['aux'] ?? '';
    $footer = $_POST['footer'] ?? '';
    $duration_sec = intval($_POST['duration_sec'] ?? 5);
    $enabled = isset($_POST['enabled']) ? 1 : 0;
    $opt_half_screen = isset($_POST['opt_half_screen']) ? 1 : 0;
    $opt_enable_subtitle = isset($_POST['opt_enable_subtitle']) ? 1 : 0;
    $opt_disable_cents = isset($_POST['opt_disable_cents']) ? 1 : 0;
    $opt_3_digits_cents = isset($_POST['opt_3_digits_cents']) ? 1 : 0;
    $opt_small_cents = isset($_POST['opt_small_cents']) ? 1 : 0;

    if ($id > 0) {
        $stmt = $mysqli->prepare("UPDATE offers SET client_id=?, name=?, header=?, title=?, subtitle=?, price_cents=?, unit=?, aux=?, footer=?, duration_sec=?, enabled=?, opt_half_screen=?, opt_enable_subtitle=?, opt_disable_cents=?, opt_3_digits_cents=?, opt_small_cents=? WHERE id=?");
        $stmt->bind_param('issssisssiiiiiiii', $client_id,$name,$header,$title,$subtitle,$price_cents,$unit,$aux,$footer,$duration_sec,$enabled,$opt_half_screen,$opt_enable_subtitle,$opt_disable_cents,$opt_3_digits_cents,$opt_small_cents,$id);
    } else {
        $stmt = $mysqli->prepare("INSERT INTO offers (client_id,name,header,title,subtitle,price_cents,unit,aux,footer,duration_sec,enabled,opt_half_screen,opt_enable_subtitle,opt_disable_cents,opt_3_digits_cents,opt_small_cents) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('issssisssiiiiiii', $client_id,$name,$header,$title,$subtitle,$price_cents,$unit,$aux,$footer,$duration_sec,$enabled,$opt_half_screen,$opt_enable_subtitle,$opt_disable_cents,$opt_3_digits_cents,$opt_small_cents);
    }
    if ($stmt->execute()) {
        header('Location: offers_list.php');
        exit;
    } else {
        echo '<div class="alert alert-danger">Erro ao salvar.</div>';
    }
}

// lista clientes para admin master
$clients = [];
if (is_admin_master()) {
    $res = $mysqli->query("SELECT id,name FROM clients ORDER BY name");
    while($c=$res->fetch_assoc()) $clients[] = $c;
}
?>
<h3><?= $id>0 ? 'Editar' : 'Nova' ?> Oferta</h3>
<form method="post" style="max-width:600px;">
  <?php if (is_admin_master()): ?>
  <div class="mb-3">
    <label class="form-label">Cliente</label>
    <select name="client_id" class="form-select">
      <?php foreach($clients as $c): ?>
        <option value="<?= $c['id'] ?>" <?= $c['id']==$offer['client_id']?'selected':'' ?>>
          <?= htmlspecialchars($c['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <?php endif; ?>
  <div class="mb-3">
    <label class="form-label">Nome da Oferta (interno)</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($offer['name']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Cabeçalho</label>
    <input type="text" name="header" class="form-control" value="<?= htmlspecialchars($offer['header']) ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Título</label>
    <input type="text" name="title" class="form-control" value="<?= htmlspecialchars($offer['title']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Sub-título</label>
    <input type="text" name="subtitle" class="form-control" value="<?= htmlspecialchars($offer['subtitle']) ?>">
  </div>
  <div class="row mb-3">
    <div class="col">
      <label class="form-label">Valor (ex: 3,39)</label>
      <input type="text" name="price" class="form-control" value="<?= number_format($offer['price_cents']/100, 2, ',', '') ?>">
    </div>
    <div class="col">
      <label class="form-label">Unidade (KG, UN, etc.)</label>
      <input type="text" name="unit" class="form-control" value="<?= htmlspecialchars($offer['unit']) ?>">
    </div>
  </div>
  <div class="mb-3">
    <label class="form-label">Auxiliar (ex: NACIONAL)</label>
    <input type="text" name="aux" class="form-control" value="<?= htmlspecialchars($offer['aux']) ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Rodapé (ex: Oferta 26 e 27/11)</label>
    <input type="text" name="footer" class="form-control" value="<?= htmlspecialchars($offer['footer']) ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Tempo em tela (segundos)</label>
    <input type="number" name="duration_sec" class="form-control" value="<?= (int)$offer['duration_sec'] ?>">
  </div>
  <div class="form-check">
    <input class="form-check-input" type="checkbox" name="enabled" id="enabled" <?= $offer['enabled']?'checked':'' ?>>
    <label class="form-check-label" for="enabled">Oferta ativa</label>
  </div>
  <div class="form-check">
    <input class="form-check-input" type="checkbox" name="opt_half_screen" id="opt_half_screen" <?= $offer['opt_half_screen']?'checked':'' ?>>
    <label class="form-check-label" for="opt_half_screen">Oferta meia tela</label>
  </div>
  <div class="form-check">
    <input class="form-check-input" type="checkbox" name="opt_enable_subtitle" id="opt_enable_subtitle" <?= $offer['opt_enable_subtitle']?'checked':'' ?>>
    <label class="form-check-label" for="opt_enable_subtitle">Ativar subtítulo e desligar cabeçalho</label>
  </div>
  <div class="form-check">
    <input class="form-check-input" type="checkbox" name="opt_disable_cents" id="opt_disable_cents" <?= $offer['opt_disable_cents']?'checked':'' ?>>
    <label class="form-check-label" for="opt_disable_cents">Centavos desligados</label>
  </div>
  <div class="form-check">
    <input class="form-check-input" type="checkbox" name="opt_3_digits_cents" id="opt_3_digits_cents" <?= $offer['opt_3_digits_cents']?'checked':'' ?>>
    <label class="form-check-label" for="opt_3_digits_cents">Centavos com 3 casas</label>
  </div>
  <div class="form-check mb-3">
    <input class="form-check-input" type="checkbox" name="opt_small_cents" id="opt_small_cents" <?= $offer['opt_small_cents']?'checked':'' ?>>
    <label class="form-check-label" for="opt_small_cents">Centavos com tamanho reduzido</label>
  </div>
  <button class="btn btn-primary" type="submit">Salvar</button>
  <a href="offers_list.php" class="btn btn-secondary">Voltar</a>
</form>

<hr>
<div class="row g-3">
  <div class="col-lg-6">
    <div class="card">
      <div class="card-header"><strong>Preview ao vivo</strong></div>
      <div class="card-body">
        <canvas id="previewCanvas" width="600" height="600" style="width:600px;height:600px;max-width:100%;background:#000;display:block;"></canvas>
        <div class="small text-muted mt-2">Ajuste fino (B/C/A): o sistema tenta encaixar automaticamente nos blocos do painel 96x96.</div>
      </div>
    </div>
  </div>
</div>
<script src="assets/led_sim.js"></script>
<script>
(function(){
  const canvas = document.getElementById('previewCanvas');
  if(!canvas) return;
  const m = LED_SIM.makeMatrix();
  const cfg = {fontFamily:'Arial', thinPasses:1, threshold:205, price_blink:1, border_animated:1, border_speed:5};

  function getVal(name){
    const el = document.querySelector('[name="'+name+'"]');
    if(!el) return '';
    return el.value || '';
  }
  function parsePriceToCents(v){
    v = String(v||'').replace(/[^\d,\.]/g,'').replace('.','').replace(',','.');
    const n = parseFloat(v||'0');
    return Math.round(n*100);
  }

  function buildOffer(){
    return {
      subtitle: getVal('subtitle'),
      subtitle_position: (document.querySelector('[name="subtitle_position"]')?.value) || 'above',
      title: getVal('title'),
      price_cents: parseInt(getVal('price_cents')||'0',10) || parsePriceToCents(getVal('price')),
      unit: getVal('unit'),
      description: getVal('footer') || getVal('description') || getVal('aux') || ''
    };
  }

  let t0 = performance.now();
  function loop(){
    requestAnimationFrame(loop);
    LED_SIM.clear(m);
    const of = buildOffer();
    const t = (performance.now()-t0)/1000;
    LED_SIM.renderOffer(m, of, cfg, t);
    LED_SIM.drawBorder(m, t, cfg.border_speed);
    LED_SIM.drawToCanvas(m, canvas);
  }
  loop();

  // Bind inputs
  document.querySelectorAll('input,textarea,select').forEach(el=>{
    el.addEventListener('input', ()=>{});
    el.addEventListener('change', ()=>{});
  });
})();
</script>

<?php require 'footer.php'; ?>
