<?php
require_once __DIR__ . '/auth.php';
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Painéis LED - Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="dashboard.php">Painéis LED</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        <?php if (is_admin_master()): ?>
          <li class="nav-item"><a class="nav-link" href="clients_list.php">Clientes</a></li>
          <li class="nav-item"><a class="nav-link" href="users_list.php">Usuários</a></li>
        <?php endif; ?>
        <?php if (!is_cliente_user()): ?>
          <li class="nav-item"><a class="nav-link" href="stores_list.php">Lojas</a></li>
        <?php endif; ?>
        <li class="nav-item"><a class="nav-link" href="panels_list.php">Painéis</a></li>
        <li class="nav-item"><a class="nav-link" href="offers_list.php">Ofertas</a></li>
        <li class="nav-item"><a class="nav-link" href="messages_list.php">Mensagens</a></li>
        <li class="nav-item"><a class="nav-link" href="config_global.php">Config Global</a></li>
        <li class="nav-item"><a class="nav-link" href="mass_send.php">Envio em Massa</a></li>
        <li class="nav-item"><a class="nav-link" href="mass_assign.php">Envio em Massa</a></li>
</ul>
      <span class="navbar-text me-3">
        <?= htmlspecialchars($user['name']) ?> (<?= $user['role'] ?>)
      </span>
      <a class="btn btn-outline-light btn-sm" href="logout.php">Sair</a>
    </div>
  </div>
</nav>
<div class="container">
