<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master']);

$row = $mysqli->query("SELECT * FROM global_settings WHERE id=1")->fetch_assoc();
if (!$row) {
  $mysqli->query("INSERT INTO global_settings (id) VALUES (1)");
  $row = $mysqli->query("SELECT * FROM global_settings WHERE id=1")->fetch_assoc();
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $transition_effect = $_POST['transition_effect'] ?? 'fade';
  $duration_sec = max(5, min(15, intval($_POST['duration_sec'] ?? 8)));
  $transition_sec = max(1, min(5, intval($_POST['transition_sec'] ?? 2)));
  $border_animated = isset($_POST['border_animated']) ? 1 : 0;
  $border_speed = max(1, min(15, intval($_POST['border_speed'] ?? 5)));
  $price_blink = isset($_POST['price_blink']) ? 1 : 0;

  $stmt = $mysqli->prepare("UPDATE global_settings
                            SET transition_effect=?, duration_sec=?, transition_sec=?, border_animated=?, border_speed=?, price_blink=?
                            WHERE id=1");
  $stmt->bind_param('siiiii', $transition_effect, $duration_sec, $transition_sec, $border_animated, $border_speed, $price_blink);
  $stmt->execute();
  $stmt->close();

  header("Location: config_global.php?ok=1");
  exit;
}

$effects = [
  'fade'=>'Fade',
  'slide_right'=>'Entrada da Direita',
  'slide_left'=>'Entrada da Esquerda',
  'slide_up'=>'Entrada de Baixo p/ Cima',
  'slide_down'=>'Entrada de Cima p/ Baixo'
];
?>
<h3>Configurações Globais</h3>
<p class="text-muted">Padrão do sistema. Painéis herdam isso, mas podem sobrescrever. Itens podem sobrescrever o painel.</p>

<?php if (!empty($_GET['ok'])): ?>
  <div class="alert alert-success">Configurações globais salvas.</div>
<?php endif; ?>

<form method="post" class="card" style="max-width:720px;">
  <div class="card-body">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label"><strong>Efeito padrão</strong></label>
        <select name="transition_effect" class="form-select">
          <?php foreach ($effects as $k=>$label): ?>
            <option value="<?= $k ?>" <?= ($row['transition_effect']===$k?'selected':'') ?>><?= $label ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label"><strong>Tempo oferta</strong></label>
        <select name="duration_sec" class="form-select">
          <?php for($i=5;$i<=15;$i++): ?>
            <option value="<?= $i ?>" <?= ((int)$row['duration_sec']===$i?'selected':'') ?>><?= $i ?>s</option>
          <?php endfor; ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label"><strong>Transição</strong></label>
        <select name="transition_sec" class="form-select">
          <?php for($i=1;$i<=5;$i++): ?>
            <option value="<?= $i ?>" <?= ((int)$row['transition_sec']===$i?'selected':'') ?>><?= $i ?>s</option>
          <?php endfor; ?>
        </select>
      </div>

      <div class="col-md-6">
        <div class="form-check mt-2">
          <input class="form-check-input" type="checkbox" name="border_animated" id="border_animated" <?= ((int)$row['border_animated']===1?'checked':'') ?>>
          <label class="form-check-label" for="border_animated"><strong>Borda animada (tracejada correndo)</strong></label>
        </div>
        <label class="form-label mt-2">Velocidade da borda</label>
        <input type="number" class="form-control" name="border_speed" value="<?= (int)$row['border_speed'] ?>" min="1" max="15">
      </div>

      <div class="col-md-6">
        <div class="form-check mt-2">
          <input class="form-check-input" type="checkbox" name="price_blink" id="price_blink" <?= ((int)$row['price_blink']===1?'checked':'') ?>>
          <label class="form-check-label" for="price_blink"><strong>Piscar preço ao entrar</strong></label>
        </div>
      </div>
    </div>
  </div>
  <div class="card-footer d-flex gap-2">
    <button class="btn btn-primary">Salvar</button>
    <a href="panels_list.php" class="btn btn-outline-secondary">Voltar</a>
  </div>
</form>

<?php require 'footer.php'; ?>
