<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/db.php';

$key = $_GET['key'] ?? '';
if ($key === '') {
    http_response_code(400);
    echo json_encode(['error' => 'panel_key ausente']);
    exit;
}

$sql = "SELECT p.id, p.name, p.width, p.height, p.brightness, p.is_active,
               s.name AS store_name, c.name AS client_name
        FROM panels p
        JOIN stores s ON s.id=p.store_id
        JOIN clients c ON c.id=s.client_id
        WHERE p.panel_key = ? LIMIT 1";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param('s', $key);
$stmt->execute();
$panel = $stmt->get_result()->fetch_assoc();

if (!$panel || !$panel['is_active']) {
    http_response_code(404);
    echo json_encode(['error' => 'Painel não encontrado ou inativo']);
    exit;
}

$mysqli->query("UPDATE panels SET last_seen = NOW() WHERE id = " . intval($panel['id']));

$cfgRes = $mysqli->query("SELECT power, use_schedule, on_time, off_time FROM panel_settings WHERE panel_id=".(int)$panel['id']);
$cfg = $cfgRes->fetch_assoc();
if (!$cfg) {
  $cfg = ['power'=>1,'use_schedule'=>0,'on_time'=>'08:00','off_time'=>'22:00'];
}

$sqlOff = "
  SELECT o.*
  FROM panel_offers po
  JOIN offers o ON o.id = po.offer_id
  WHERE po.panel_id = ? AND po.enabled = 1 AND o.enabled = 1
  ORDER BY po.position ASC, o.id ASC
";
$stmt2 = $mysqli->prepare($sqlOff);
$stmt2->bind_param('i', $panel['id']);
$stmt2->execute();
$resOff = $stmt2->get_result();

$offers = [];
while ($row = $resOff->fetch_assoc()) {
    $offers[] = [
        'id'           => (int)$row['id'],
        'name'         => $row['name'],
        'header'       => $row['header'],
        'title'        => $row['title'],
        'subtitle'     => $row['subtitle'],
        'price_cents'  => (int)$row['price_cents'],
        'unit'         => $row['unit'],
        'aux'          => $row['aux'],
        'footer'       => $row['footer'],
        'duration_sec' => (int)$row['duration_sec'],
        'opt' => [
            'half_screen'     => (bool)$row['opt_half_screen'],
            'enable_subtitle' => (bool)$row['opt_enable_subtitle'],
            'disable_cents'   => (bool)$row['opt_disable_cents'],
            'digits_3_cents'  => (bool)$row['opt_3_digits_cents'],
            'small_cents'     => (bool)$row['opt_small_cents'],
        ]
    ];
}

echo json_encode([
    'panel' => [
        'name'         => $panel['name'],
        'client'       => $panel['client_name'],
        'store'        => $panel['store_name'],
        'width'        => (int)$panel['width'],
        'height'       => (int)$panel['height'],
        'brightness'   => (int)$panel['brightness'],
        'power'        => (int)$cfg['power'],
        'use_schedule' => (int)$cfg['use_schedule'],
        'on_time'      => $cfg['on_time'],
        'off_time'     => $cfg['off_time'],
    ],
    'offers' => $offers
], JSON_UNESCAPED_UNICODE);
