<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$sql = "SELECT s.id, s.name, s.code, c.name AS client_name
        FROM stores s
        JOIN clients c ON c.id=s.client_id";

if (is_admin_master()) {
    $sql .= " ORDER BY c.name, s.name";
} else {
    $sql .= " WHERE c.id=" . intval($user['client_id']) . " ORDER BY s.name";
}
$res = $mysqli->query($sql);
?>
<h3>Lojas</h3>
<?php if (is_admin_master() || is_admin_cliente()): ?>
  <a href="store_edit.php" class="btn btn-primary mb-3">Nova Loja</a>
<?php endif; ?>
<table class="table table-striped">
  <thead>
    <tr><th>Cliente</th><th>Loja</th><th>Código</th><th>Ações</th></tr>
  </thead>
  <tbody>
  <?php while($s = $res->fetch_assoc()): ?>
    <tr>
      <td><?= htmlspecialchars($s['client_name']) ?></td>
      <td><?= htmlspecialchars($s['name']) ?></td>
      <td><?= htmlspecialchars($s['code']) ?></td>
      <td>
        <?php if (is_admin_master() || is_admin_cliente()): ?>
          <a class="btn btn-sm btn-secondary" href="store_edit.php?id=<?= $s['id'] ?>">Editar</a>
        <?php endif; ?>
      </td>
    </tr>
  <?php endwhile; ?>
  </tbody>
</table>
<?php require 'footer.php'; ?>
