<?php
// Tela para criar o primeiro Admin Master e o primeiro Cliente
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../api/db.php';

// Verifica se já existe algum admin_master
$exists = $mysqli->query("SELECT COUNT(*) AS total FROM users WHERE role = 'admin_master'");
$hasAdmin = $exists && ($exists->fetch_assoc()['total'] > 0);

if ($hasAdmin) {
    echo "<h3>Já existe um Admin Master cadastrado.</h3>";
    echo "<p>Por segurança, esta tela só funciona quando não há nenhum admin_master. Apague manualmente se precisar recriar.</p>";
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $client_name = trim($_POST['client_name'] ?? '');
    $client_doc  = trim($_POST['client_doc'] ?? '');
    $admin_name  = trim($_POST['admin_name'] ?? '');
    $admin_email = trim($_POST['admin_email'] ?? '');
    $admin_pass  = $_POST['admin_pass'] ?? '';

    if ($client_name === '' || $admin_name === '' || $admin_email === '' || $admin_pass === '') {
        $error = 'Preencha todos os campos obrigatórios.';
    } else {
        // cria cliente
        $stmt = $mysqli->prepare("INSERT INTO clients (name, document) VALUES (?, ?)");
        $stmt->bind_param('ss', $client_name, $client_doc);
        if ($stmt->execute()) {
            $client_id = $stmt->insert_id;
            $hash = password_hash($admin_pass, PASSWORD_DEFAULT);
            $role = 'admin_master';
            $is_active = 1;
            $stmt2 = $mysqli->prepare("INSERT INTO users (client_id,name,email,password_hash,role,is_active) VALUES (?,?,?,?,?,?)");
            $stmt2->bind_param('issssi', $client_id, $admin_name, $admin_email, $hash, $role, $is_active);
            if ($stmt2->execute()) {
                $success = 'Admin Master criado com sucesso! Agora você já pode acessar o painel em /admin/login.php';
            } else {
                $error = 'Erro ao criar usuário: ' . htmlspecialchars($mysqli->error);
            }
        } else {
            $error = 'Erro ao criar cliente: ' . htmlspecialchars($mysqli->error);
        }
    }
}
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Setup Admin Master</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container" style="max-width:600px; margin-top:40px;">
  <div class="card shadow-sm">
    <div class="card-body">
      <h3 class="mb-3">Setup Inicial - Admin Master</h3>
      <p>Preencha os dados abaixo apenas na primeira instalação do sistema.</p>
      <?php if ($error): ?>
        <div class="alert alert-danger"><?= $error ?></div>
      <?php endif; ?>
      <?php if ($success): ?>
        <div class="alert alert-success"><?= $success ?></div>
      <?php endif; ?>
      <form method="post">
        <h5>Cliente (sua empresa)</h5>
        <div class="mb-3">
          <label class="form-label">Nome da empresa *</label>
          <input type="text" name="client_name" class="form-control" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Documento (CNPJ/CPF) (opcional)</label>
          <input type="text" name="client_doc" class="form-control">
        </div>
        <hr>
        <h5>Admin Master</h5>
        <div class="mb-3">
          <label class="form-label">Seu nome *</label>
          <input type="text" name="admin_name" class="form-control" required>
        </div>
        <div class="mb-3">
          <label class="form-label">E-mail *</label>
          <input type="email" name="admin_email" class="form-control" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Senha *</label>
          <input type="password" name="admin_pass" class="form-control" required>
        </div>
        <button class="btn btn-primary" type="submit">Criar Admin Master</button>
      </form>
    </div>
  </div>
</div>
</body>
</html>
