<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$sql = "SELECT p.id, p.name, p.panel_key, p.is_active, p.last_seen,
               s.name AS store_name,
               c.name AS client_name
        FROM panels p
        JOIN stores s ON s.id = p.store_id
        JOIN clients c ON c.id = s.client_id ";

if (is_admin_master()) {
    $sql .= " ORDER BY c.name, s.name, p.name";
} elseif (is_admin_cliente()) {
    $sql .= " WHERE c.id = " . intval($user['client_id']) . " ORDER BY s.name, p.name";
} else {
    $sql .= " JOIN user_store_permissions usp ON usp.store_id = s.id
              WHERE usp.user_id = " . intval($user['id']) . " ORDER BY s.name, p.name";
}
$res = $mysqli->query($sql);
?>
<h3>Painéis</h3>
<?php if (is_admin_master() || is_admin_cliente()): ?>
  <a href="panel_edit.php" class="btn btn-primary mb-3">Novo Painel</a>
<?php endif; ?>
<table class="table table-striped">
  <thead>
    <tr>
      <th>Cliente</th>
      <th>Loja</th>
      <th>Painel</th>
      <th>Key</th>
      <th>Ativo</th>
      <th>Último contato</th>
      <th>Ações</th>
    </tr>
  </thead>
  <tbody>
  <?php while($row = $res->fetch_assoc()): ?>
    <tr>
      <td><?= htmlspecialchars($row['client_name']) ?></td>
      <td><?= htmlspecialchars($row['store_name']) ?></td>
      <td><?= htmlspecialchars($row['name']) ?></td>
      <td><code><?= htmlspecialchars($row['panel_key']) ?></code></td>
      <td><?= $row['is_active'] ? 'Sim' : 'Não' ?></td>
      <td><?= $row['last_seen'] ?: '-' ?></td>
      <td>
        <a href="panel_settings.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Config.</a>
        <a href="panel_preview.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-success">Preview</a>
        <a href="panel_offers.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-info">Ofertas</a>
        <a href="panel_messages.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-info">Mensagens</a>
        <?php if (is_admin_master() || is_admin_cliente()): ?>
          <a href="panel_edit.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-secondary">Editar</a>
        <?php endif; ?>
      </td>
    </tr>
  <?php endwhile; ?>
  </tbody>
</table>
<?php require 'footer.php'; ?>
