<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    echo "Painel inválido.";
    require 'footer.php';
    exit;
}

require_role(['admin_master','admin_cliente']);

$stmt = $mysqli->prepare("SELECT p.id, p.name, p.panel_key, c.name AS client_name, s.name AS store_name
                          FROM panels p
                          JOIN stores s ON s.id=p.store_id
                          JOIN clients c ON c.id=s.client_id
                          WHERE p.id = ?");
$stmt->bind_param('i', $id);
$stmt->execute();
$panel = $stmt->get_result()->fetch_assoc();
if (!$panel) {
    echo "Painel não encontrado.";
    require 'footer.php';
    exit;
}

$stmt2 = $mysqli->prepare("SELECT power, use_schedule, on_time, off_time FROM panel_settings WHERE panel_id=?");
$stmt2->bind_param('i', $id);
$stmt2->execute();
$cfg = $stmt2->get_result()->fetch_assoc();
if (!$cfg) {
    $cfg = ['power'=>1,'use_schedule'=>0,'on_time'=>'08:00','off_time'=>'22:00'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $power        = isset($_POST['power']) ? 1 : 0;
    $use_schedule = isset($_POST['use_schedule']) ? 1 : 0;
    $on_time      = $_POST['on_time'] ?: '08:00';
    $off_time     = $_POST['off_time'] ?: '22:00';

    $stmt = $mysqli->prepare("
      INSERT INTO panel_settings (panel_id, power, use_schedule, on_time, off_time)
      VALUES (?, ?, ?, ?, ?)
      ON DUPLICATE KEY UPDATE
        power=VALUES(power),
        use_schedule=VALUES(use_schedule),
        on_time=VALUES(on_time),
        off_time=VALUES(off_time)
    ");
    $stmt->bind_param('iiiss', $id, $power, $use_schedule, $on_time, $off_time);
    if ($stmt->execute()) {
        $cfg = ['power'=>$power,'use_schedule'=>$use_schedule,'on_time'=>$on_time,'off_time'=>$off_time];
        echo '<div class="alert alert-success">Configurações salvas.</div>';
    } else {
        echo '<div class="alert alert-danger">Erro ao salvar.</div>';
    }
}
?>
<h3>Configurações do Painel</h3>
<p><strong>Cliente:</strong> <?= htmlspecialchars($panel['client_name']) ?><br>
   <strong>Loja:</strong> <?= htmlspecialchars($panel['store_name']) ?><br>
   <strong>Painel:</strong> <?= htmlspecialchars($panel['name']) ?><br>
   <strong>Key:</strong> <code><?= htmlspecialchars($panel['panel_key']) ?></code></p>

<form method="post" class="mt-3" style="max-width:400px;">
  <div class="form-check form-switch mb-3">
    <input class="form-check-input" type="checkbox" id="power" name="power" <?= $cfg['power'] ? 'checked' : '' ?>>
    <label class="form-check-label" for="power">Painel ligado</label>
  </div>

  <div class="form-check form-switch mb-3">
    <input class="form-check-input" type="checkbox" id="use_schedule" name="use_schedule" <?= $cfg['use_schedule'] ? 'checked' : '' ?>>
    <label class="form-check-label" for="use_schedule">Usar horário automático</label>
  </div>

  <div class="row mb-3">
    <div class="col">
      <label class="form-label">Hora de ligar</label>
      <input type="time" name="on_time" class="form-control" value="<?= htmlspecialchars($cfg['on_time']) ?>">
    </div>
    <div class="col">
      <label class="form-label">Hora de desligar</label>
      <input type="time" name="off_time" class="form-control" value="<?= htmlspecialchars($cfg['off_time']) ?>">
    </div>
  </div>

  <button class="btn btn-primary" type="submit">Salvar</button>
  <a href="panels_list.php" class="btn btn-secondary">Voltar</a>
</form>

<?php require 'footer.php'; ?>
