<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) { echo "Painel inválido."; require 'footer.php'; exit; }

// busca painel
$stmt = $mysqli->prepare("SELECT p.id,p.name,s.name AS store_name,c.id AS client_id,c.name AS client_name
                          FROM panels p
                          JOIN stores s ON s.id=p.store_id
                          JOIN clients c ON c.id=s.client_id
                          WHERE p.id=?");
$stmt->bind_param('i',$id);
$stmt->execute();
$panel = $stmt->get_result()->fetch_assoc();
if (!$panel) { echo "Painel não encontrado."; require 'footer.php'; exit; }

// Admin master pode mexer em qualquer, admin_cliente apenas do próprio cliente, cliente também.
if (!is_admin_master() && $panel['client_id'] != $user['client_id']) {
    echo "Acesso negado.";
    require 'footer.php';
    exit;
}

// salvar
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // limpar tudo e recriar associações
    $mysqli->query("DELETE FROM panel_offers WHERE panel_id=".(int)$id);
    if (!empty($_POST['offer_id']) && is_array($_POST['offer_id'])) {
        $position = 0;
        $stmtIns = $mysqli->prepare("INSERT INTO panel_offers (panel_id,offer_id,position,enabled) VALUES (?,?,?,1)");
        foreach($_POST['offer_id'] as $off_id) {
            $off_id = intval($off_id);
            $position++;
            $stmtIns->bind_param('iii',$id,$off_id,$position);
            $stmtIns->execute();
        }
    }
    echo '<div class="alert alert-success">Playlist atualizada.</div>';
}

// ofertas disponíveis para o cliente
$resOffers = $mysqli->query("SELECT * FROM offers WHERE client_id=".(int)$panel['client_id']." AND enabled=1 ORDER BY name");

// ofertas já associadas
$assoc = [];
$resAssoc = $mysqli->query("SELECT offer_id,position FROM panel_offers WHERE panel_id=".(int)$id." ORDER BY position");
while($a=$resAssoc->fetch_assoc()) $assoc[$a['offer_id']] = $a['position'];
?>
<h3>Ofertas do Painel</h3>
<p><strong>Cliente:</strong> <?= htmlspecialchars($panel['client_name']) ?><br>
   <strong>Loja:</strong> <?= htmlspecialchars($panel['store_name']) ?><br>
   <strong>Painel:</strong> <?= htmlspecialchars($panel['name']) ?></p>

<form method="post">
  <p>Selecione as ofertas que irão aparecer neste painel (a ordem é a ordem de marcação):</p>
  <div class="mb-3" style="max-height:400px; overflow:auto;">
    <?php while($o=$resOffers->fetch_assoc()): ?>
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="offer_id[]" value="<?= $o['id'] ?>"
          id="offer_<?= $o['id'] ?>" <?= isset($assoc[$o['id']])?'checked':'' ?>>
        <label class="form-check-label" for="offer_<?= $o['id'] ?>">
          <?= htmlspecialchars($o['name'].' - '.$o['title']) ?>
        </label>
      </div>
    <?php endwhile; ?>
  </div>
  <button class="btn btn-primary" type="submit">Salvar Playlist</button>
  <a href="panels_list.php" class="btn btn-secondary">Voltar</a>
</form>
<?php require 'footer.php'; ?>
