<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

require_role(['admin_master','admin_cliente','cliente']);

$client_id = (int)$user['client_id'];
if (is_admin_master() && isset($_GET['client_id'])) $client_id = intval($_GET['client_id']);

$store_id = isset($_GET['store_id']) ? intval($_GET['store_id']) : 0;

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $selected_items = $_POST['items'] ?? [];
  $selected_panels = $_POST['panels'] ?? [];
  $mode = $_POST['mode'] ?? 'append';

  foreach ($selected_panels as $pid) {
    $pid = intval($pid);
    if ($pid<=0) continue;

    if (!is_admin_master()) {
      $st=$mysqli->prepare("SELECT c.id AS client_id FROM panels p JOIN stores s ON s.id=p.store_id JOIN clients c ON c.id=s.client_id WHERE p.id=?");
      $st->bind_param('i',$pid); $st->execute();
      $p=$st->get_result()->fetch_assoc(); $st->close();
      if(!$p || (int)$p['client_id'] !== (int)$user['client_id']) continue;
    }

    if ($mode==='replace') {
      $mysqli->query("DELETE FROM panel_playlist WHERE panel_id=".$pid);
    }
    $res = $mysqli->query("SELECT COALESCE(MAX(position),0) AS maxpos FROM panel_playlist WHERE panel_id=".$pid);
    $pos = (int)($res->fetch_assoc()['maxpos'] ?? 0);

    foreach ($selected_items as $token) {
      if (!preg_match('/^(offer|message):(\d+)$/',$token,$m)) continue;
      $type=$m[1]; $id=(int)$m[2];
      $pos++;
      $st=$mysqli->prepare("INSERT INTO panel_playlist(panel_id,item_type,item_id,position,enabled) VALUES(?,?,?,?,1)");
      $st->bind_param('isii',$pid,$type,$id,$pos);
      $st->execute(); $st->close();
    }
  }

  header("Location: mass_send.php?ok=1"); exit;
}

$stores=[];
if ($client_id>0) {
  $st=$mysqli->prepare("SELECT id,name FROM stores WHERE client_id=? ORDER BY name");
  $st->bind_param('i',$client_id); $st->execute();
  $r=$st->get_result(); while($row=$r->fetch_assoc()) $stores[]=$row; $st->close();
}

$offers=[]; $messages=[]; $panels=[];
$st=$mysqli->prepare("SELECT id,name,title FROM offers WHERE client_id=? ORDER BY updated_at DESC,id DESC");
$st->bind_param('i',$client_id); $st->execute();
$r=$st->get_result(); while($row=$r->fetch_assoc()) $offers[]=$row; $st->close();

$st=$mysqli->prepare("SELECT id,name FROM messages WHERE client_id=? ORDER BY updated_at DESC,id DESC");
$st->bind_param('i',$client_id); $st->execute();
$r=$st->get_result(); while($row=$r->fetch_assoc()) $messages[]=$row; $st->close();

if ($store_id>0) {
  $st=$mysqli->prepare("SELECT p.id,p.name FROM panels p WHERE p.store_id=? ORDER BY p.name");
  $st->bind_param('i',$store_id); $st->execute();
} else {
  $st=$mysqli->prepare("SELECT p.id,p.name FROM panels p JOIN stores s ON s.id=p.store_id WHERE s.client_id=? ORDER BY p.name");
  $st->bind_param('i',$client_id); $st->execute();
}
$r=$st->get_result(); while($row=$r->fetch_assoc()) $panels[]=$row; $st->close();
?>
<h3>Enviar Conteúdos para Painéis (em massa)</h3>
<p class="text-muted">Selecione ofertas/mensagens e os painéis. Você pode substituir a playlist ou apenas adicionar ao final.</p>
<?php if (!empty($_GET['ok'])): ?><div class="alert alert-success">Enviado!</div><?php endif; ?>

<form class="row g-3 mb-3" method="get">
  <div class="col-md-4">
    <label class="form-label">Filtrar por Loja</label>
    <select class="form-select" name="store_id" onchange="this.form.submit()">
      <option value="0">Todas</option>
      <?php foreach($stores as $s): ?>
        <option value="<?= (int)$s['id'] ?>" <?= ($store_id===(int)$s['id']?'selected':'') ?>><?= htmlspecialchars($s['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
</form>

<form method="post">
<div class="row g-3">
  <div class="col-md-5">
    <div class="card">
      <div class="card-header"><strong>Conteúdos</strong></div>
      <div class="card-body" style="max-height:520px; overflow:auto;">
        <div class="mb-2 text-muted small">Ofertas</div>
        <?php foreach($offers as $o): ?>
          <label class="d-flex gap-2 align-items-start border rounded p-2 mb-2">
            <input type="checkbox" name="items[]" value="offer:<?= (int)$o['id'] ?>" class="mt-1">
            <div>
              <strong><?= htmlspecialchars($o['name']) ?></strong>
              <div class="text-muted small"><?= htmlspecialchars($o['title']) ?></div>
            </div>
          </label>
        <?php endforeach; ?>
        <div class="mt-3 mb-2 text-muted small">Mensagens</div>
        <?php foreach($messages as $m): ?>
          <label class="d-flex gap-2 align-items-start border rounded p-2 mb-2">
            <input type="checkbox" name="items[]" value="message:<?= (int)$m['id'] ?>" class="mt-1">
            <div>
              <strong><?= htmlspecialchars($m['name']) ?></strong>
              <div class="text-muted small">Mensagem</div>
            </div>
          </label>
        <?php endforeach; ?>
      </div>
    </div>
  </div>

  <div class="col-md-4">
    <div class="card">
      <div class="card-header"><strong>Painéis</strong></div>
      <div class="card-body" style="max-height:520px; overflow:auto;">
        <?php foreach($panels as $p): ?>
          <label class="d-flex gap-2 align-items-center border rounded p-2 mb-2">
            <input type="checkbox" name="panels[]" value="<?= (int)$p['id'] ?>">
            <div><strong><?= htmlspecialchars($p['name']) ?></strong></div>
          </label>
        <?php endforeach; ?>
        <?php if(!$panels): ?><div class="text-muted">Nenhum painel neste filtro.</div><?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-md-3">
    <div class="card">
      <div class="card-header"><strong>Ação</strong></div>
      <div class="card-body">
        <label class="form-label">Modo</label>
        <select class="form-select" name="mode">
          <option value="append">Adicionar ao final</option>
          <option value="replace">Substituir playlist</option>
        </select>
        <div class="form-text">Substituir apaga a playlist atual dos painéis selecionados.</div>
      </div>
      <div class="card-footer">
        <button class="btn btn-primary w-100">Enviar</button>
      </div>
    </div>
  </div>
</div>
</form>

<?php require 'footer.php'; ?>
