<?php
// OTA Admin redirector: gera link assinado no momento do clique
require_once __DIR__ . '/../admin/auth.php';
require_role('admin_master');
require_once __DIR__ . '/../config.php'; // $pdo

function fetch_panel_secret_by_key($pdo, $panel_key){
  $st = $pdo->prepare("SELECT secret FROM ic_panels WHERE panel_key=? LIMIT 1");
  $st->execute([$panel_key]);
  $row = $st->fetch();
  return $row ? (string)$row['secret'] : null;
}

$panel_key = isset($_GET['panel_key']) ? preg_replace('/[^A-Za-z0-9_-]/', '', $_GET['panel_key']) : '';
$type = isset($_GET['type']) ? strtolower(trim($_GET['type'])) : '';
if($panel_key === '' || ($type !== 'check' && $type !== 'download')){
  http_response_code(400);
  echo "invalid request";
  exit;
}

$secret = fetch_panel_secret_by_key($pdo, $panel_key);
if(!$secret){
  http_response_code(404);
  echo "secret not found";
  exit;
}

$ts = time();
$sig = hash('sha256', $panel_key . '|' . $ts . '|' . $secret);
$target = ($type === 'check') ? 'check.php' : 'download.php';
$url = $target . '?panel_key=' . rawurlencode($panel_key) . '&ts=' . $ts . '&sig=' . $sig;
header('Location: ' . $url, true, 302);
exit;
