<?php
// OTA PULL - DOWNLOAD BIN
// GET: ?panel_key=PAINEL-001
// Serve o .bin e marca pending=false após servir (modo "botão" = 1 disparo)

require_once __DIR__ . '/../config.php';

function fetch_panel_secret($pdo, $panel_key){
  $st = $pdo->prepare("SELECT secret FROM ic_panels WHERE panel_key=? LIMIT 1");
  $st->execute([$panel_key]);
  $row = $st->fetch();
  return $row ? (string)$row['secret'] : null;
}

function verify_sig($panel_key, $ts, $sig, $secret){
  if (!$secret) return false;
  $base = $panel_key . '|' . $ts . '|' . $secret;
  $calc = hash('sha256', $base);
  return hash_equals($calc, (string)$sig);
}

$panel_key = isset($_GET['panel_key']) ? preg_replace('/[^A-Z0-9\-\_]/i','', $_GET['panel_key']) : '';
$ts = isset($_GET['ts']) ? intval($_GET['ts']) : 0;
$sig = isset($_GET['sig']) ? trim($_GET['sig']) : '';
if (abs(time() - $ts) > 600) {
  http_response_code(403);
  echo "stale signature";
  exit;
}

if ($panel_key === '') {
  http_response_code(400);
  echo "missing panel_key";
  exit;
}

$secret = fetch_panel_secret($pdo, $panel_key);
if ($ts <= 0 || !verify_sig($panel_key, $ts, $sig, $secret)) {
  http_response_code(403);
  echo "invalid signature";
  exit;
}

$stateFile = __DIR__ . '/storage/state_' . $panel_key . '.json';
if (!file_exists($stateFile)) {
  http_response_code(404);
  echo "no update";
  exit;
}

$state = json_decode(@file_get_contents($stateFile), true);
if (!is_array($state)) $state = [];
$binFile = isset($state['bin_file']) ? basename($state['bin_file']) : '';
$binPath = __DIR__ . '/storage/' . $binFile;

if (empty($state['pending']) || !$binFile || !file_exists($binPath)) {
  http_response_code(404);
  echo "no pending update";
  exit;
}

header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="firmware.bin"');
header('Content-Length: ' . filesize($binPath));
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Pragma: no-cache');

$fp = fopen($binPath, 'rb');
if ($fp) {
  while (!feof($fp)) {
    echo fread($fp, 8192);
    @ob_flush();
    flush();
  }
  fclose($fp);
}

// marca como consumido (para não ficar tentando atualizar em loop)
$state['pending'] = false;
@file_put_contents($stateFile, json_encode($state, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));