<?php
// OTA PULL - CHECK
// GET: ?panel_key=PAINEL-001
// Retorna JSON: {pending:bool, version:string, size:int, sha256:string}

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../config.php';
function fetch_panel_secret($pdo, $panel_key){
  $st = $pdo->prepare("SELECT secret FROM ic_panels WHERE panel_key=? LIMIT 1");
  $st->execute([$panel_key]);
  $row = $st->fetch();
  return $row ? (string)$row['secret'] : null;
}

function verify_sig($panel_key, $ts, $sig, $secret){
  if (!$secret) return false;
  $base = $panel_key . '|' . $ts . '|' . $secret;
  $calc = hash('sha256', $base);
  return hash_equals($calc, (string)$sig);
}



$panel_key = isset($_GET['panel_key']) ? preg_replace('/[^A-Z0-9\-\_]/i','', $_GET['panel_key']) : '';
$ts = isset($_GET['ts']) ? intval($_GET['ts']) : 0;
$sig = isset($_GET['sig']) ? trim($_GET['sig']) : '';
if (abs(time() - $ts) > 600) {
  http_response_code(403);
  echo json_encode(['error'=>'stale signature']);
  exit;
}

if ($panel_key === '') {
  http_response_code(400);
  echo json_encode(['error'=>'missing panel_key']);
  exit;
}

$secret = fetch_panel_secret($pdo, $panel_key);
if ($ts <= 0 || !verify_sig($panel_key, $ts, $sig, $secret)) {
  http_response_code(403);
  echo json_encode(['error'=>'invalid signature']);
  exit;
}

$stateFile = __DIR__ . '/storage/state_' . $panel_key . '.json';
if (!file_exists($stateFile)) {
  // sem update
  echo json_encode(['pending'=>false]);
  exit;
}

$state = json_decode(@file_get_contents($stateFile), true);
if (!is_array($state)) $state = [];

$pending = !empty($state['pending']);
$binFile = isset($state['bin_file']) ? basename($state['bin_file']) : '';
$binPath = __DIR__ . '/storage/' . $binFile;

$out = [
  'pending' => $pending,
  'version' => isset($state['version']) ? (string)$state['version'] : '',
  'sha256'  => isset($state['sha256']) ? (string)$state['sha256'] : '',
  'size'    => 0,
];

if ($pending && $binFile && file_exists($binPath)) {
  $out['size'] = filesize($binPath);
} else {
  $out['pending'] = false;
}

echo json_encode($out);