<?php
// iCartaz/api/portal_panels.php
// Retorna lista de paineis ativos (para o Portal Wi-Fi do ESP32)
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/_db.php';

try {
    $pdo = db();

    // garante tabelas minimas (compat com seu sistema)
    $pdo->exec("CREATE TABLE IF NOT EXISTS ic_clients (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        is_active TINYINT(1) NOT NULL DEFAULT 1
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

    $pdo->exec("CREATE TABLE IF NOT EXISTS ic_panels (
        id INT AUTO_INCREMENT PRIMARY KEY,
        panel_key VARCHAR(64) NOT NULL UNIQUE,
        name VARCHAR(255) NOT NULL DEFAULT '',
        location VARCHAR(255) NOT NULL DEFAULT '',
        client_id INT NULL,
        is_active TINYINT(1) NOT NULL DEFAULT 1,
        updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

    $pdo->exec("CREATE TABLE IF NOT EXISTS ic_panel_checkins (
        id INT AUTO_INCREMENT PRIMARY KEY,
        panel_key VARCHAR(64) NOT NULL,
        created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
        INDEX(panel_key),
        INDEX(created_at)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

    // Busca paineis ativos + ultimo checkin (se existir)
    $sql = "
        SELECT
            p.panel_key,
            NULLIF(p.name,'')       AS panel_name,
            NULLIF(p.location,'')   AS location,
            c.name                  AS client_name,
            MAX(ch.created_at)      AS last_seen
        FROM ic_panels p
        LEFT JOIN ic_clients c ON c.id = p.client_id
        LEFT JOIN ic_panel_checkins ch ON ch.panel_key = p.panel_key
        WHERE p.is_active = 1
        GROUP BY p.panel_key, p.name, p.location, c.name
        ORDER BY (MAX(ch.created_at) IS NULL) ASC, MAX(ch.created_at) DESC, p.panel_key ASC
        LIMIT 300
    ";

    $stmt = $pdo->query($sql);
    $items = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $items[] = [
            'panel_key'   => $row['panel_key'],
            'panel_name'  => $row['panel_name'] ?? '',
            'location'    => $row['location'] ?? '',
            'client_name' => $row['client_name'] ?? '',
            'last_seen'   => $row['last_seen'] ?? null,
        ];
    }

    echo json_encode(['ok' => true, 'items' => $items], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'Erro ao listar paineis.'], JSON_UNESCAPED_UNICODE);
}
