<?php
header("Content-Type: application/json; charset=utf-8");
date_default_timezone_set("America/Sao_Paulo");
require_once __DIR__ . "/_db.php";

$panel_key = isset($_GET["panel_key"]) ? trim($_GET["panel_key"]) : "";
if ($panel_key === "") { http_response_code(400); echo json_encode(["ok"=>false,"error"=>"panel_key required"]); exit; }

$st = $pdo->prepare("SELECT * FROM ic_panels_last WHERE panel_key=? LIMIT 1");
$st->execute([$panel_key]);
$row = $st->fetch();

if (!$row) { http_response_code(404); echo json_encode(["ok"=>false,"error"=>"panel not found"]); exit; }

$age_sec = null;
if (!empty($row["last_seen"])) $age_sec = time() - strtotime($row["last_seen"]);

$row["online"] = ($age_sec !== null && $age_sec <= 90);
$row["age_sec"] = $age_sec;

echo json_encode(["ok"=>true,"data"=>$row]);
?>