<?php
header("Content-Type: application/json; charset=utf-8");
date_default_timezone_set("America/Sao_Paulo");
require_once __DIR__ . "/_db.php";

function get_json_input() {
  $raw = file_get_contents("php://input");
  if (!$raw) return null;
  $j = json_decode($raw, true);
  return is_array($j) ? $j : null;
}

function valid_time_hm($s) {
  if (!is_string($s)) return false;
  if (!preg_match('/^\d{2}:\d{2}$/', $s)) return false;
  $h = intval(substr($s, 0, 2));
  $m = intval(substr($s, 3, 2));
  return ($h >= 0 && $h <= 23 && $m >= 0 && $m <= 59);
}

$in = get_json_input();
if (!$in) $in = $_POST;

$panel_keys = [];
if (isset($in["panel_keys"]) && is_array($in["panel_keys"])) {
  $panel_keys = array_values(array_filter(array_map("trim", $in["panel_keys"])));
} elseif (!empty($in["panel_key"])) {
  $panel_keys = [trim((string)$in["panel_key"])];
}

$use_schedule = isset($in["use_schedule"]) ? (int)$in["use_schedule"] : 0;
$on_time = isset($in["on_time"]) ? (string)$in["on_time"] : "";
$off_time = isset($in["off_time"]) ? (string)$in["off_time"] : "";

if (!$panel_keys) {
  http_response_code(400);
  echo json_encode(["ok"=>false,"error"=>"panel_keys required"]);
  exit;
}
if (!valid_time_hm($on_time) || !valid_time_hm($off_time)) {
  http_response_code(400);
  echo json_encode(["ok"=>false,"error"=>"invalid time"]);
  exit;
}
if ($use_schedule !== 1) $use_schedule = 0;

$sel = $pdo->prepare("SELECT id FROM ic_panels WHERE panel_key=? LIMIT 1");
$ins = $pdo->prepare("
  INSERT INTO panel_settings (panel_id, power, use_schedule, on_time, off_time)
  VALUES (?, 1, ?, ?, ?)
  ON DUPLICATE KEY UPDATE
    use_schedule=VALUES(use_schedule),
    on_time=VALUES(on_time),
    off_time=VALUES(off_time)
");

$updated = 0;
$missing = [];
foreach ($panel_keys as $pk) {
  $sel->execute([$pk]);
  $p = $sel->fetch();
  if (!$p) {
    $missing[] = $pk;
    continue;
  }
  $panel_id = (int)$p["id"];
  $ins->execute([$panel_id, $use_schedule, $on_time, $off_time]);
  $updated++;
}

echo json_encode([
  "ok" => true,
  "updated" => $updated,
  "missing" => $missing,
  "use_schedule" => $use_schedule,
  "on_time" => $on_time,
  "off_time" => $off_time
]);
?>
