<?php
require_once __DIR__ . '/db.php';

$panel_key = $_GET['panel_key'] ?? '';
if (!$panel_key) {
  http_response_code(400);
  header('Content-Type: application/json');
  echo json_encode(['error'=>'missing panel_key']);
  exit;
}

$st = $mysqli->prepare("
  SELECT p.id, p.name, s.client_id
  FROM panels p
  JOIN stores s ON s.id = p.store_id
  WHERE p.panel_key = ?
");
$st->bind_param('s', $panel_key);
$st->execute();
$panel = $st->get_result()->fetch_assoc();
$st->close();

if (!$panel) {
  http_response_code(404);
  header('Content-Type: application/json');
  echo json_encode(['error'=>'panel not found']);
  exit;
}

$global = $mysqli->query("SELECT * FROM global_settings WHERE id=1")->fetch_assoc();

// garante que existe config do painel
$mysqli->query("INSERT INTO panel_settings (panel_id) VALUES (".(int)$panel['id'].")
               ON DUPLICATE KEY UPDATE panel_id=panel_id");

$st = $mysqli->prepare("SELECT * FROM panel_settings WHERE panel_id=?");
$st->bind_param('i', $panel['id']);
$st->execute();
$panel_cfg = $st->get_result()->fetch_assoc();
$st->close();

// config final (global anim + power/schedule do painel)
$cfg = [
  'transition_effect' => $global['transition_effect'] ?? 'fade',
  'duration_sec'      => (int)($global['duration_sec'] ?? 8),
  'transition_sec'    => (int)($global['transition_sec'] ?? 2),
  'border_animated'   => (int)($global['border_animated'] ?? 1),
  'border_speed'      => (int)($global['border_speed'] ?? 5),
  'price_blink'       => (int)($global['price_blink'] ?? 1),

  // do painel
  'power'        => (int)($panel_cfg['power'] ?? 1),
  'use_schedule' => (int)($panel_cfg['use_schedule'] ?? 0),
  'on_time'      => ($panel_cfg['on_time'] ?? '08:00'),
  'off_time'     => ($panel_cfg['off_time'] ?? '22:00'),
];

$items = [];
$st = $mysqli->prepare("
  SELECT
    pl.item_type, pl.item_id, pl.position,
    o.name  AS offer_name,
    o.subtitle,
    o.title,
    o.price_cents,
    o.unit,
    o.aux,
    o.footer,
    m.name AS message_name,
    m.lines_json
  FROM panel_playlist pl
  LEFT JOIN offers   o ON (pl.item_type='offer'   AND o.id=pl.item_id)
  LEFT JOIN messages m ON (pl.item_type='message' AND m.id=pl.item_id)
  WHERE pl.panel_id=? AND pl.enabled=1
    AND (pl.starts_at IS NULL OR pl.starts_at <= NOW())
    AND (pl.ends_at   IS NULL OR pl.ends_at   >= NOW())
  ORDER BY pl.position ASC, pl.id ASC
");
$st->bind_param('i', $panel['id']);
$st->execute();
$r = $st->get_result();

while ($row = $r->fetch_assoc()) {
  if ($row['item_type'] === 'offer') {
    $desc = $row['footer'];
    if (!$desc) $desc = $row['aux']; // fallback

    $items[] = [
      'type'        => 'offer',
      'id'          => (int)$row['item_id'],
      'name'        => $row['offer_name'],
      'subtitle'    => $row['subtitle'],
      'title'       => $row['title'],
      'price_cents' => (int)$row['price_cents'],
      'unit'        => $row['unit'],
      'description' => $desc
    ];
  } else {
    $items[] = [
      'type'      => 'message',
      'id'        => (int)$row['item_id'],
      'name'      => $row['message_name'],
      'lines_json'=> $row['lines_json']
    ];
  }
}
$st->close();

header('Content-Type: application/json; charset=utf-8');
echo json_encode(
  [
    'panel'  => ['id'=>(int)$panel['id'], 'name'=>$panel['name']],
    'config' => $cfg,
    'items'  => $items
  ],
  JSON_UNESCAPED_UNICODE
);
