﻿<?php
require_once __DIR__ . '/_db.php';
header('Content-Type: application/json; charset=utf-8');

$raw = file_get_contents('php://input');
if(!$raw){ http_response_code(400); echo json_encode(['error'=>'empty_body']); exit; }
$payload = json_decode($raw, true);
if(!is_array($payload)) { http_response_code(400); echo json_encode(['error'=>'invalid_json']); exit; }

$panel_key = isset($payload['panel_key']) ? trim($payload['panel_key']) : '';
if($panel_key === '') { http_response_code(400); echo json_encode(['error'=>'panel_key_required']); exit; }

$stP = $pdo->prepare("SELECT id FROM ic_panels WHERE panel_key=? LIMIT 1");
$stP->execute([$panel_key]);
$panel = $stP->fetch();
if(!$panel){ http_response_code(404); echo json_encode(['error'=>'panel_not_found']); exit; }
$panel_id = (int)$panel['id'];

$logs = isset($payload['logs']) && is_array($payload['logs']) ? $payload['logs'] : [];
if(!$logs){ echo json_encode(['ok'=>true,'inserted'=>0]); exit; }

$stI = $pdo->prepare("INSERT INTO ic_panel_logs (panel_id,panel_key,level,message,created_at) VALUES (?,?,?,?,NOW())");
$inserted = 0;
foreach($logs as $l){
  if(!is_array($l)) continue;
  $level = isset($l['level']) ? substr((string)$l['level'],0,16) : 'info';
  $message = isset($l['message']) ? (string)$l['message'] : '';
  if($message === '') continue;
  $stI->execute([$panel_id, $panel_key, $level, $message]);
  $inserted++;
}

echo json_encode(['ok'=>true,'inserted'=>$inserted]);

