<?php
header("Content-Type: application/json; charset=utf-8");
date_default_timezone_set("America/Sao_Paulo");
require_once __DIR__ . "/_db.php";
header('Cache-Control: no-store, no-cache, must-revalidate');
header('Pragma: no-cache');
header('X-Accel-Buffering: no');

function fetch_panel_secret($pdo, $panel_key){
  $st = $pdo->prepare("SELECT secret FROM ic_panels WHERE panel_key=? LIMIT 1");
  $st->execute([$panel_key]);
  $row = $st->fetch();
  return $row ? (string)$row['secret'] : null;
}

function verify_sig($panel_key, $ts, $sig, $secret){
  if (!$secret) return false;
  $base = $panel_key . '|' . $ts . '|' . $secret;
  $calc = hash('sha256', $base);
  return hash_equals($calc, (string)$sig);
}

$panel_key = isset($_GET["panel_key"]) ? trim($_GET["panel_key"]) : "";
$ts = isset($_GET["ts"]) ? intval($_GET["ts"]) : 0;
$sig = isset($_GET["sig"]) ? trim($_GET["sig"]) : "";
$wait = isset($_GET["wait"]) ? intval($_GET["wait"]) : 0;
if (abs(time() - $ts) > 600) {
  http_response_code(403);
  echo json_encode(["ok"=>false,"error"=>"stale signature"]);
  exit;
}

if ($wait < 0) $wait = 0;
if ($wait > 25) $wait = 25;

if ($panel_key === "") { http_response_code(400); echo json_encode(["ok"=>false,"error"=>"panel_key required"]); exit; }

$secret = fetch_panel_secret($pdo, $panel_key);
if (!$secret) { http_response_code(404); echo json_encode(["ok"=>false,"error"=>"panel not found"]); exit; }

if ($ts <= 0 || !verify_sig($panel_key, $ts, $sig, $secret)) {
  http_response_code(403);
  echo json_encode(["ok"=>false,"error"=>"invalid signature"]);
  exit;
}

$st = $pdo->prepare("SELECT id FROM ic_panels WHERE panel_key=? LIMIT 1");
$st->execute([$panel_key]);
$p = $st->fetch();
if (!$p) { http_response_code(404); echo json_encode(["ok"=>false,"error"=>"panel not found"]); exit; }

$panel_id = intval($p["id"]);

$cmds = [];
$start = microtime(true);
do {
  $pdo->beginTransaction();
  try {
    $st2 = $pdo->prepare("SELECT id,cmd,payload,created_at FROM ic_panel_commands WHERE panel_id=? AND status='pending' ORDER BY id ASC LIMIT 10");
    $st2->execute([$panel_id]);
    $cmds = $st2->fetchAll();

    if ($cmds) {
      $ids = array_map(function($r){ return intval($r["id"]); }, $cmds);
      $in = implode(",", $ids);
      $pdo->exec("UPDATE ic_panel_commands SET status='sent', sent_at=NOW() WHERE id IN ($in)");
    }

    $pdo->commit();
  } catch (Exception $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode(["ok"=>false,"error"=>$e->getMessage()]);
    exit;
  }

  if ($cmds || $wait === 0) break;
  usleep(200000);
} while ((microtime(true) - $start) < $wait);

foreach ($cmds as &$c) {
  $c["payload"] = $c["payload"] ? json_decode($c["payload"], true) : null;
}

echo json_encode(["ok"=>true,"panel_key"=>$panel_key,"commands"=>$cmds]);
