<?php
header("Content-Type: application/json; charset=utf-8");
date_default_timezone_set("America/Sao_Paulo");
require_once __DIR__ . "/_db.php";
function fetch_panel_secret($pdo, $panel_key){
  $st = $pdo->prepare("SELECT secret FROM ic_panels WHERE panel_key=? LIMIT 1");
  $st->execute([$panel_key]);
  $row = $st->fetch();
  return $row ? (string)$row['secret'] : null;
}

function verify_sig($panel_key, $ts, $sig, $secret){
  if (!$secret) return false;
  $base = $panel_key . '|' . $ts . '|' . $secret;
  $calc = hash('sha256', $base);
  return hash_equals($calc, (string)$sig);
}



function get_json_input() {
  $raw = file_get_contents("php://input");
  if (!$raw) return null;
  $j = json_decode($raw, true);
  return is_array($j) ? $j : null;
}

$in = get_json_input();
if (!$in) $in = $_POST;

$panel_key = isset($in["panel_key"]) ? trim($in["panel_key"]) : "";
$id = isset($in["id"]) ? intval($in["id"]) : 0;
$status = isset($in["status"]) ? trim($in["status"]) : "done";
$result = isset($in["result"]) ? trim($in["result"]) : null;
$ts = isset($in["ts"]) ? intval($in["ts"]) : 0;
$sig = isset($in["sig"]) ? trim($in["sig"]) : "";
if (abs(time() - $ts) > 600) {
  http_response_code(403);
  echo json_encode(["ok"=>false,"error"=>"stale signature"]);
  exit;
}


if ($panel_key === "" || $id <= 0) {
  http_response_code(400);
  echo json_encode(["ok"=>false,"error"=>"panel_key and id required"]);
  exit;
}

$st = $pdo->prepare("SELECT id FROM ic_panels WHERE panel_key=? LIMIT 1");
$st->execute([$panel_key]);
$p = $st->fetch();
if (!$p) { http_response_code(404); echo json_encode(["ok"=>false,"error"=>"panel not found"]); exit; }

$secret = fetch_panel_secret($pdo, $panel_key);
if ($ts <= 0 || !verify_sig($panel_key, $ts, $sig, $secret)) {
  http_response_code(403);
  echo json_encode(["ok"=>false,"error"=>"invalid signature"]);
  exit;
}

$panel_id = intval($p["id"]);
$upd = $pdo->prepare("UPDATE ic_panel_commands SET status=?, result=?, done_at=NOW() WHERE id=? AND panel_id=?");
$upd->execute([$status ?: "done",$result,$id,$panel_id]);

echo json_encode(["ok"=>true]);
?>
