<?php
header("Content-Type: application/json; charset=utf-8");
date_default_timezone_set("America/Sao_Paulo");
require_once __DIR__ . "/_db.php";

function get_json_input() {
  $raw = file_get_contents("php://input");
  if (!$raw) return null;
  $j = json_decode($raw, true);
  return is_array($j) ? $j : null;
}

$in = get_json_input();
if (!$in) $in = $_POST;

$panel_key = isset($in["panel_key"]) ? trim($in["panel_key"]) : "";
$cmd = isset($in["cmd"]) ? trim($in["cmd"]) : "";
$payload = isset($in["payload"]) ? $in["payload"] : null;
$redirect = isset($in["redirect"]) ? trim($in["redirect"]) : "";

if ($panel_key === "" || $cmd === "") {
  http_response_code(400);
  echo json_encode(["ok"=>false,"error"=>"panel_key and cmd required"]);
  exit;
}

$allowed = ["restart","leds_off","leds_on","rescue","rescue_off"];
if (!in_array($cmd, $allowed, true)) {
  http_response_code(400);
  echo json_encode(["ok"=>false,"error"=>"invalid cmd"]);
  exit;
}

$st = $pdo->prepare("SELECT id FROM ic_panels WHERE panel_key=? LIMIT 1");
$st->execute([$panel_key]);
$p = $st->fetch();
if (!$p) {
  http_response_code(404);
  echo json_encode(["ok"=>false,"error"=>"panel not found"]);
  exit;
}

$panel_id = intval($p["id"]);
$payload_json = null;
if ($payload !== null) $payload_json = is_string($payload) ? $payload : json_encode($payload, JSON_UNESCAPED_UNICODE);

$ins = $pdo->prepare("INSERT INTO ic_panel_commands(panel_id,panel_key,cmd,payload,status) VALUES(?,?,?,?,?)");
$ins->execute([$panel_id,$panel_key,$cmd,$payload_json,"pending"]);

if ($redirect) {
  header("Location: " . $redirect);
  exit;
}

echo json_encode(["ok"=>true,"panel_key"=>$panel_key,"cmd"=>$cmd]);
?>
