<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

require_role(['admin_master','admin_cliente']);

$sql = "SELECT u.id,u.name,u.email,u.role,u.is_active,c.name AS client_name
        FROM users u
        LEFT JOIN clients c ON c.id=u.client_id";

if (is_admin_master()) {
    $sql .= " ORDER BY u.role, u.name";
} else {
    $sql .= " WHERE u.client_id=" . intval($user['client_id']) . " ORDER BY u.role, u.name";
}
$res = $mysqli->query($sql);
?>
<h3>Usuários</h3>
<a href="user_edit.php" class="btn btn-primary mb-3">Novo Usuário</a>
<table class="table table-striped">
  <thead>
    <tr><th>Nome</th><th>E-mail</th><th>Cliente</th><th>Perfil</th><th>Ativo</th><th>Ações</th></tr>
  </thead>
  <tbody>
  <?php while($u = $res->fetch_assoc()): ?>
    <tr>
      <td><?= htmlspecialchars($u['name']) ?></td>
      <td><?= htmlspecialchars($u['email']) ?></td>
      <td><?= htmlspecialchars($u['client_name']) ?></td>
      <td><?= htmlspecialchars($u['role']) ?></td>
      <td><?= $u['is_active'] ? 'Sim' : 'Não' ?></td>
      <td><a class="btn btn-sm btn-secondary" href="user_edit.php?id=<?= $u['id'] ?>">Editar</a></td>
    </tr>
  <?php endwhile; ?>
  </tbody>
</table>
<?php require 'footer.php'; ?>
