<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

require_role(['admin_master','admin_cliente']);

$id = intval($_GET['id'] ?? 0);
$userEdit = ['id'=>0,'client_id'=>$user['client_id'],'name'=>'','email'=>'','role'=>'cliente','is_active'=>1];

if ($id > 0) {
    $stmt = $mysqli->prepare("SELECT * FROM users WHERE id=?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $userEdit = $stmt->get_result()->fetch_assoc();
    if (!$userEdit) { echo "Usuário não encontrado."; require 'footer.php'; exit; }
}

// lista de clientes
$clients = [];
if (is_admin_master()) {
    $res = $mysqli->query("SELECT id,name FROM clients ORDER BY name");
    while($c=$res->fetch_assoc()) $clients[] = $c;
} else {
    $clients[] = ['id'=>$user['client_id'],'name'=>''];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $client_id = intval($_POST['client_id'] ?? 0);
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $role = $_POST['role'] ?? 'cliente';
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $password = $_POST['password'] ?? '';

    if ($id > 0) {
        if ($password !== '') {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $mysqli->prepare("UPDATE users SET client_id=?, name=?, email=?, role=?, is_active=?, password_hash=? WHERE id=?");
            $stmt->bind_param('isssisi', $client_id, $name, $email, $role, $is_active, $hash, $id);
        } else {
            $stmt = $mysqli->prepare("UPDATE users SET client_id=?, name=?, email=?, role=?, is_active=? WHERE id=?");
            $stmt->bind_param('isssii', $client_id, $name, $email, $role, $is_active, $id);
        }
    } else {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $mysqli->prepare("INSERT INTO users (client_id,name,email,role,is_active,password_hash) VALUES (?,?,?,?,?,?)");
        $stmt->bind_param('isssis', $client_id, $name, $email, $role, $is_active, $hash);
    }
    if ($stmt->execute()) {
        header('Location: users_list.php');
        exit;
    } else {
        echo '<div class="alert alert-danger">Erro ao salvar.</div>';
    }
}
?>
<h3><?= $id>0 ? 'Editar' : 'Novo' ?> Usuário</h3>
<form method="post" style="max-width:500px;">
  <div class="mb-3">
    <label class="form-label">Cliente</label>
    <select name="client_id" class="form-select">
      <?php foreach($clients as $c): ?>
        <option value="<?= $c['id'] ?>" <?= $c['id']==$userEdit['client_id']?'selected':'' ?>>
          <?= htmlspecialchars($c['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Nome</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($userEdit['name']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">E-mail</label>
    <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($userEdit['email']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Perfil</label>
    <select name="role" class="form-select">
      <option value="admin_master" <?= $userEdit['role']=='admin_master'?'selected':'' ?>>Admin Master</option>
      <option value="admin_cliente" <?= $userEdit['role']=='admin_cliente'?'selected':'' ?>>Admin Cliente</option>
      <option value="cliente" <?= $userEdit['role']=='cliente'?'selected':'' ?>>Cliente</option>
    </select>
  </div>
  <div class="form-check mb-3">
    <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= $userEdit['is_active']?'checked':'' ?>>
    <label class="form-check-label" for="is_active">Ativo</label>
  </div>
  <div class="mb-3">
    <label class="form-label">Senha <?= $id>0 ? '(deixe em branco para manter)' : '' ?></label>
    <input type="password" name="password" class="form-control" <?= $id==0?'required':'' ?>>
  </div>
  <button class="btn btn-primary" type="submit">Salvar</button>
  <a href="users_list.php" class="btn btn-secondary">Voltar</a>
</form>
<?php require 'footer.php'; ?>
