<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master','admin_cliente']);

$id = intval($_GET['id'] ?? 0);
$store = ['id'=>0,'client_id'=>$user['client_id'],'name'=>'','code'=>''];

if ($id > 0) {
    $stmt = $mysqli->prepare("SELECT * FROM stores WHERE id=?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $store = $stmt->get_result()->fetch_assoc();
    if (!$store) { echo "Loja não encontrada."; require 'footer.php'; exit; }
}

// Admin master escolhe cliente, admin_cliente fixa no seu
$clients = [];
if (is_admin_master()) {
    $res = $mysqli->query("SELECT id,name FROM clients ORDER BY name");
    while($c = $res->fetch_assoc()) $clients[] = $c;
} else {
    $clients[] = ['id'=>$user['client_id'],'name'=>''];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $client_id = intval($_POST['client_id'] ?? 0);
    $name = $_POST['name'] ?? '';
    $code = $_POST['code'] ?? '';
    if ($id > 0) {
        $stmt = $mysqli->prepare("UPDATE stores SET client_id=?, name=?, code=? WHERE id=?");
        $stmt->bind_param('issi', $client_id, $name, $code, $id);
    } else {
        $stmt = $mysqli->prepare("INSERT INTO stores (client_id, name, code) VALUES (?,?,?)");
        $stmt->bind_param('iss', $client_id, $name, $code);
    }
    if ($stmt->execute()) {
        header('Location: stores_list.php');
        exit;
    } else {
        echo '<div class="alert alert-danger">Erro ao salvar.</div>';
    }
}
?>
<h3><?= $id>0 ? 'Editar' : 'Nova' ?> Loja</h3>
<form method="post" style="max-width:400px;">
  <div class="mb-3">
    <label class="form-label">Cliente</label>
    <select name="client_id" class="form-select">
      <?php foreach($clients as $c): ?>
        <option value="<?= $c['id'] ?>" <?= $c['id']==$store['client_id']?'selected':'' ?>>
          <?= htmlspecialchars($c['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Nome da Loja</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($store['name']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Código / Referência</label>
    <input type="text" name="code" class="form-control" value="<?= htmlspecialchars($store['code']) ?>">
  </div>
  <button class="btn btn-primary" type="submit">Salvar</button>
  <a href="stores_list.php" class="btn btn-secondary">Voltar</a>
</form>
<?php require 'footer.php'; ?>
