﻿<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$sql = "SELECT p.id, p.name, p.panel_key, p.is_active, p.last_seen,
               s.name AS store_name,
               c.name AS client_name
        FROM panels p
        JOIN stores s ON s.id = p.store_id
        JOIN clients c ON c.id = s.client_id ";

$client_id = 0;
$clients = [];
if (is_admin_master()) {
    $client_id = intval($_GET['client_id'] ?? 0);
    $clients = $mysqli->query("SELECT id,name FROM clients ORDER BY name")->fetch_all(MYSQLI_ASSOC);
}

if (is_admin_master()) {
    if ($client_id > 0) {
        $sql .= " WHERE c.id = " . intval($client_id);
    }
    $sql .= " ORDER BY c.name, s.name, p.name";
} elseif (is_admin_cliente()) {
    $sql .= " WHERE c.id = " . intval($user['client_id']) . " ORDER BY s.name, p.name";
} else {
    $sql .= " JOIN user_store_permissions usp ON usp.store_id = s.id
              WHERE usp.user_id = " . intval($user['id']) . " ORDER BY s.name, p.name";
}
$res = $mysqli->query($sql);
$stLed = $mysqli->prepare("SELECT cmd FROM ic_panel_commands WHERE panel_key=? AND cmd IN ('leds_on','leds_off') ORDER BY id DESC LIMIT 1");
?>
<style>
  .btn-restart-icon{
    color:#dc3545; border:1px solid #dc3545; background:transparent;
    border-radius:50%; width:30px; height:30px;
    display:inline-flex; align-items:center; justify-content:center;
  }
  .btn-restart-icon .power{ font-size:16px; line-height:1; }
  .action-group{ display:inline-flex; align-items:center; gap:6px; flex-wrap:wrap; }
  .switch-btn{
    display:inline-flex; align-items:center; gap:8px;
    border:1px solid #2b2f33; background:#0f1113; color:#fff;
    padding:4px 8px; border-radius:999px; cursor:pointer; font-size:12px;
  }
  .switch-track{
    width:36px; height:20px; border-radius:999px; position:relative;
    background:#b02a37; box-shadow:inset 0 0 0 1px rgba(0,0,0,.35);
  }
  .switch-thumb{
    width:14px; height:14px; border-radius:50%; background:#fff;
    position:absolute; top:3px; left:3px; transition:all .15s ease;
  }
  .switch-on .switch-track{ background:#1f8a4c; }
  .switch-on .switch-thumb{ left:19px; }
  .bulk-bar{ display:flex; align-items:center; gap:10px; flex-wrap:wrap; margin:8px 0 16px; }
  .bulk-actions{ display:flex; align-items:center; gap:8px; flex-wrap:wrap; }
  .bulk-inline{ display:flex; align-items:center; gap:8px; flex-wrap:wrap; }
  .bulk-inline .form-select{ min-width: 220px; }
  .col-select{ width:36px; }
  .page-head{ display:flex; align-items:center; justify-content:space-between; gap:12px; flex-wrap:wrap; margin-bottom:12px; }
  .head-right{ display:flex; align-items:center; gap:10px; flex-wrap:wrap; }
  .table td, .table th{ vertical-align: middle; }
  .col-programacao{ min-width: 160px; }
  .action-group{ flex-wrap:nowrap; }
</style>
<div class="page-head">
  <div>
    <h3 class="mb-1">Pain&eacute;is</h3>
    <?php if (is_admin_master() || is_admin_cliente()): ?>
      <a href="panel_edit.php" class="btn btn-primary">Novo Painel</a>
    <?php endif; ?>
  </div>
  <div class="head-right">
    <?php if (is_admin_master()): ?>
      <form method="get" class="d-flex align-items-center gap-2 m-0">
        <select name="client_id" class="form-select form-select-sm" onchange="this.form.submit()">
          <option value="0">Todos os clientes</option>
          <?php foreach ($clients as $c): ?>
            <option value="<?php echo (int)$c['id']; ?>" <?php echo ((int)$c['id']===$client_id?'selected':''); ?>>
              <?php echo htmlspecialchars($c['name']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </form>
    <?php endif; ?>
    <a class="btn btn-outline-secondary btn-sm" href="panels_list.php<?php echo $client_id>0 ? '?client_id='.(int)$client_id : ''; ?>">Atualizar</a>
  </div>
</div>

<?php if (is_admin_master()): ?>
  <div class="bulk-bar">
    <div class="bulk-inline">
      <label class="form-label m-0 text-secondary">A&ccedil;&otilde;es em massa</label>
      <select id="bulk_cmd" class="form-select form-select-sm">
        <option value="">Selecione...</option>
        <option value="leds_on">Ligar LEDs</option>
        <option value="leds_off">Desligar LEDs</option>
        <option value="restart">Reiniciar</option>
      </select>
      <button type="button" class="btn btn-sm btn-outline-primary" onclick="bulkSendCmd()">Aplicar</button>
      <button type="button" class="btn btn-sm btn-outline-secondary" onclick="bulkOpenConfig()">Configura&ccedil;&atilde;o</button>
      <button type="button" class="btn btn-sm btn-outline-secondary" onclick="selectAllPanels(true)">Selecionar todos</button>
      <button type="button" class="btn btn-sm btn-outline-secondary" onclick="selectAllPanels(false)">Limpar</button>
    </div>
  </div>
<?php endif; ?>

<table class="table table-striped">
  <thead>
    <tr>
      <?php if (is_admin_master()): ?>
        <th class="col-select"><input type="checkbox" id="chk_all" onclick="selectAllPanels(this.checked)"></th>
      <?php endif; ?>
      <th>Cliente</th>
      <th>Loja</th>
      <th>Painel</th>
      <th>Key</th>
      <th>Ativo</th>
      <th>&Uacute;ltimo contato</th>
      <th class="col-programacao">Programa&ccedil;&atilde;o</th>
      <th>Configura&ccedil;&atilde;o</th>
    </tr>
  </thead>
  <tbody>
  <?php while($row = $res->fetch_assoc()): ?>
    <?php
      $ledCmd = null;
      if ($stLed) {
        $stLed->bind_param("s", $row['panel_key']);
        $stLed->execute();
        $stLed->bind_result($ledCmd);
        $stLed->fetch();
        $stLed->free_result();
      }
      $ledState = 'desligado';
      if ($ledCmd === 'leds_on') $ledState = 'ligado';
    ?>
    <tr>
      <?php if (is_admin_master()): ?>
        <td class="col-select">
          <input type="checkbox" class="panel-check" value="<?= htmlspecialchars($row['panel_key']) ?>" data-panel-id="<?= (int)$row['id'] ?>">
        </td>
      <?php endif; ?>
      <td><?= htmlspecialchars($row['client_name']) ?></td>
      <td><?= htmlspecialchars($row['store_name']) ?></td>
      <td><?= htmlspecialchars($row['name']) ?></td>
      <td><code><?= htmlspecialchars($row['panel_key']) ?></code></td>
      <td><?= $row['is_active'] ? 'Sim' : 'N&atilde;o' ?></td>
      <td><?= $row['last_seen'] ?: '-' ?></td>
      <td class="col-programacao">
        <a href="panel_contents.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Programa&ccedil;&atilde;o</a>
      </td>
      <td>
        <span class="action-group">
          <a href="panel_settings.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Config.</a>
          <?php if (is_admin_master()): ?>
            <a href="panel_edit.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-secondary">Editar</a>
            <form method="post" action="panel_delete.php" class="d-inline" onsubmit="return confirm('Excluir painel?');">
              <input type="hidden" name="id" value="<?= (int)$row['id'] ?>">
              <button type="submit" class="btn btn-sm btn-outline-danger">Excluir</button>
            </form>
            <form method="post" action="../api/panel_cmd.php" class="d-inline"
                  onsubmit="return confirm('<?= $ledState === 'ligado' ? 'Desligar LEDs do painel?' : 'Ligar LEDs do painel?' ?>');">
              <input type="hidden" name="panel_key" value="<?= htmlspecialchars($row['panel_key']) ?>">
              <input type="hidden" name="cmd" value="<?= $ledState === 'ligado' ? 'leds_off' : 'leds_on' ?>">
              <input type="hidden" name="redirect" value="../admin/panels_list.php">
              <button type="submit"
                      class="switch-btn <?= $ledState === 'ligado' ? 'switch-on' : '' ?>"
                      title="<?= $ledState === 'ligado' ? 'Os LEDs estão ligados' : 'Os LEDs estão desligados' ?>">
                <span class="switch-track"><span class="switch-thumb"></span></span>
                LEDs <?= $ledState === 'ligado' ? 'ON' : 'OFF' ?>
              </button>
            </form>
            <form method="post" action="../api/panel_cmd.php" class="d-inline" onsubmit="return confirm('Reiniciar o painel agora?');">
              <input type="hidden" name="panel_key" value="<?= htmlspecialchars($row['panel_key']) ?>">
              <input type="hidden" name="cmd" value="restart">
              <input type="hidden" name="redirect" value="../admin/panels_list.php">
              <button type="submit" class="btn-restart-icon" title="Reiniciar">
                <span class="power">&#x23FB;</span>
              </button>
            </form>
          <?php endif; ?>
        </span>
      </td>
    </tr>
  <?php endwhile; ?>
  </tbody>
</table>

<script>
function getSelectedPanels(){
  return Array.from(document.querySelectorAll('.panel-check:checked'));
}
function selectAllPanels(state){
  document.querySelectorAll('.panel-check').forEach(el => { el.checked = state; });
  const all = document.getElementById('chk_all');
  if (all) all.checked = state;
}
function bulkSendCmd(){
  const cmd = document.getElementById('bulk_cmd').value;
  if (!cmd) { alert('Selecione uma ação.'); return; }
  const selected = getSelectedPanels();
  if (!selected.length) { alert('Selecione ao menos um painel.'); return; }
  if (!confirm('Aplicar \"' + cmd + '\" para ' + selected.length + ' painéis?')) return;
  const url = '../api/panel_cmd.php';
  let done = 0;
  selected.forEach(el => {
    const fd = new FormData();
    fd.append('panel_key', el.value);
    fd.append('cmd', cmd);
    fd.append('redirect', 'panels_list.php<?php echo $client_id>0 ? '?client_id='.(int)$client_id : ''; ?>');
    fetch(url, { method:'POST', body: fd }).finally(() => {
      done++;
      if (done === selected.length) location.reload();
    });
  });
}
function bulkOpenConfig(){
  const selected = getSelectedPanels();
  if (!selected.length) { alert('Selecione ao menos um painel.'); return; }
  if (!confirm('Abrir configuração para ' + selected.length + ' painéis?')) return;
  selected.forEach(el => {
    const id = el.getAttribute('data-panel-id');
    if (id) window.open('panel_settings.php?id=' + encodeURIComponent(id), '_blank');
  });
}
</script>
<script>
  // Auto refresh removed per request.
</script>
<?php require 'footer.php'; ?>



