<?php
require_once __DIR__ . '/../api/db.php';

// mode=thumb e usado nos cards (iframe) de Ofertas/Mensagens. Nao renderiza o layout do admin.
$mode = isset($_GET['mode']) ? (string)$_GET['mode'] : '';
$isThumb = ($mode === 'thumb');

if (!$isThumb) {
  require_once 'header.php';
}

$panel_id   = intval($_GET['id'] ?? 0);
$offer_id   = intval($_GET['offer_id'] ?? 0);
$message_id = intval($_GET['message_id'] ?? 0);

// Compatibilidade: as telas antigas de listagem (Ofertas/Mensagens) chamam este
// iframe como panel_preview.php?offer_id=... ou ?message_id=... (sem panel_id).
// Para não quebrar e evitar "Painel inválido", renderizamos um preview simples
// baseado no conteúdo.
if ($panel_id <= 0) {
  $global = $mysqli->query("SELECT * FROM global_settings WHERE id=1")->fetch_assoc();
  $cfg = [
    'transition_effect' => $global['transition_effect'] ?? 'fade',
    'duration_sec'      => (int)($global['duration_sec'] ?? 8),
    'transition_sec'    => (int)($global['transition_sec'] ?? 2),
    'border_animated'   => (int)($global['border_animated'] ?? 1),
    'border_speed'      => (int)($global['border_speed'] ?? 5),
    'price_blink'       => (int)($global['price_blink'] ?? 1),
  ];

  // preview de oferta
  if ($offer_id > 0) {
    $st = $mysqli->prepare("SELECT name,title,subtitle,price_cents,unit,footer,aux,updated_at FROM offers WHERE id=? LIMIT 1");
    $st->bind_param('i', $offer_id);
    $st->execute();
    $o = $st->get_result()->fetch_assoc();
    $st->close();
    if (!$o) {
      echo "Conte?do inv?lido.";
      if (!$isThumb) require 'footer.php';
      exit;
    }
    $item = [
      'type' => 'offer',
      'id' => (int)$offer_id,
      'name' => $o['name'] ?? '',
      'subtitle' => $o['subtitle'] ?? '',
      'title' => $o['title'] ?? '',
      'price_cents' => (int)($o['price_cents'] ?? 0),
      'unit' => $o['unit'] ?? '',
      'description' => $o['footer'] ?: ($o['aux'] ?? '')
    ];
    $payload = ['config'=>$cfg,'items'=>[$item]];
    if ($isThumb) {
      header('Content-Type: text/html; charset=utf-8');
      echo "<style>html,body{margin:0;padding:0;background:#000;}canvas{display:block;width:100%;height:auto;image-rendering:pixelated;}</style>";
      echo "<canvas id=\"previewCanvas\" width=\"300\" height=\"300\"></canvas>";
      echo "<script src=\"assets/flb_fonts.js\"></script>";
      echo "<script src=\"assets/led_sim.js\"></script>";
      echo "<script>const payload=".json_encode($payload, JSON_UNESCAPED_UNICODE).";const canvas=document.getElementById('previewCanvas');const m=LED_SIM.makeMatrix();let t0=performance.now();function loop(){requestAnimationFrame(loop);LED_SIM.clear(m);const t=(performance.now()-t0)/1000;LED_SIM.renderOffer(m,payload.items[0],payload.config,t);if(payload.config.border_animated){LED_SIM.drawBorder(m,t,payload.config.border_speed||5);}LED_SIM.drawToCanvas(m,canvas,{solid:true});}loop();</script>";
      exit;
    }
  }

  // preview de mensagem
  if ($message_id > 0) {
    $st = $mysqli->prepare("SELECT name, lines_json, updated_at FROM messages WHERE id=? LIMIT 1");
    $st->bind_param('i', $message_id);
    $st->execute();
    $m = $st->get_result()->fetch_assoc();
    $st->close();
    if (!$m) {
      echo "Conte?do inv?lido.";
      if (!$isThumb) require 'footer.php';
      exit;
    }
    if ($isThumb) {
      header('Content-Type: text/html; charset=utf-8');
      $item = [
        'type' => 'message',
        'id' => (int)$message_id,
        'name' => $m['name'] ?? '',
        'lines_json' => $m['lines_json'] ?? '[]'
      ];
      $payload = ['config'=>$cfg,'items'=>[$item]];
      echo "<style>html,body{margin:0;padding:0;background:#000;}canvas{display:block;width:100%;height:auto;image-rendering:pixelated;}</style>";
      echo "<canvas id=\"previewCanvas\" width=\"300\" height=\"300\"></canvas>";
      echo "<script src=\"assets/flb_fonts.js\"></script>";
      echo "<script src=\"assets/led_sim.js\"></script>";
      echo "<script>const payload=".json_encode($payload, JSON_UNESCAPED_UNICODE).";const canvas=document.getElementById('previewCanvas');const m=LED_SIM.makeMatrix();let t0=performance.now();function loop(){requestAnimationFrame(loop);LED_SIM.clear(m);const t=(performance.now()-t0)/1000;LED_SIM.renderMessage(m,payload.items[0],payload.config,t);if(payload.config.border_animated){LED_SIM.drawBorder(m,t,payload.config.border_speed||5);}LED_SIM.drawToCanvas(m,canvas,{solid:true});}loop();</script>";
      exit;
    }
  }

  echo "Painel inv?lido.";
  if (!$isThumb) require 'footer.php';
  exit;
}

$st = $mysqli->prepare("SELECT p.id,p.name,p.panel_key,s.name AS store_name,c.name AS client_name
                        FROM panels p
                        JOIN stores s ON s.id=p.store_id
                        JOIN clients c ON c.id=s.client_id
                        WHERE p.id=?");
$st->bind_param('i', $panel_id);
$st->execute();
$panel = $st->get_result()->fetch_assoc();
$st->close();
if (!$panel) {
  echo "Painel não encontrado.";
  if (!$isThumb) require 'footer.php';
  exit;
}

$panelKey = $panel['panel_key'];
?>

<?php if ($isThumb): ?>
  <style>
    html, body { margin:0; padding:0; background:#000; }
    canvas { display:block; width:100%; height:auto; image-rendering: pixelated; }
  </style>
  <canvas id="previewCanvas" width="300" height="300"></canvas>
<?php else: ?>
  <h3>Preview do Painel: <?= htmlspecialchars($panel['name']) ?></h3>
  <p class="text-muted"><?= htmlspecialchars($panel['client_name']) ?> / <?= htmlspecialchars($panel['store_name']) ?></p>
  <div class="card">
    <div class="card-body">
      <canvas id="previewCanvas" width="600" height="600" style="width:100%;max-width:600px;height:auto;background:#000;display:block;"></canvas>
    </div>
  </div>
<?php endif; ?>

<script src="assets/flb_fonts.js"></script>
<script src="assets/led_sim.js"></script>
<script>
const PANEL_KEY = <?= json_encode($panelKey) ?>;
const canvas = document.getElementById('previewCanvas');
const m = LED_SIM.makeMatrix();
const clamp = (v,min,max)=>Math.max(min, Math.min(max, v));


let payload = null;
let idx = 0;
let lastSwitch = performance.now();
let phase = 'show'; // show | trans
let t0 = performance.now();

async function loadPayload(){
  const res = await fetch('../api/panel_payload.php?panel_key='+encodeURIComponent(PANEL_KEY));
  payload = await res.json();
  idx = 0;
  lastSwitch = performance.now();
}
loadPayload();

function getCurrentItem(){
  if(!payload || !payload.items || !payload.items.length) return null;
  return payload.items[idx % payload.items.length];
}

function tick(){
  requestAnimationFrame(tick);
  if(!payload || !payload.items || !payload.items.length) return;

  const now = performance.now();
  const cfg = Object.assign({}, payload.config || {});
  const item = getCurrentItem();
  const elapsed = (now - lastSwitch)/1000;

  LED_SIM.clear(m);

  // Draw content
  const tsec = (now - t0)/1000;
  if(item.type==='offer'){
    LED_SIM.renderOffer(m, item, cfg, tsec);
  } else {
    LED_SIM.renderMessage(m, item, cfg, tsec);
  }

  // Border follows content/transitions
  if(cfg.border_animated){
    LED_SIM.drawBorder(m, tsec, cfg.border_speed||5);
  }

  // Transition timing: basic switch; visual effect is best-effort (matrix fade/slide could be added)
  const dur = clamp(cfg.duration_sec||8,5,15);
  if(elapsed >= dur){
    idx = (idx+1) % payload.items.length;
    lastSwitch = now;
  }

  LED_SIM.drawToCanvas(m, canvas);
}
tick();
</script>
<?php if (!$isThumb) require 'footer.php'; ?>
