<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master','admin_cliente']);

function gen_panel_secret(){
  try { return bin2hex(random_bytes(32)); } catch (Exception $e) { return bin2hex(openssl_random_pseudo_bytes(32)); }
}

function ensure_ic_panels_row($mysqli, $panel_key, $panel_name, $location, $is_active){
  // cria/atualiza registro da tabela de check-in (ic_panels)
  $secret = null;
  $st = $mysqli->prepare("SELECT secret FROM ic_panels WHERE panel_key=? LIMIT 1");
  if ($st) {
    $st->bind_param('s', $panel_key);
    $st->execute();
    $res = $st->get_result();
    if ($row = $res->fetch_assoc()) {
      $secret = $row['secret'];
    }
    $st->close();
  }

  if (!$secret) {
    $secret = gen_panel_secret();
  }

  $sql = "INSERT INTO ic_panels(panel_key,name,location,secret,is_active) VALUES(?,?,?,?,?)\n"
       ."ON DUPLICATE KEY UPDATE\n"
       ."name=VALUES(name), location=VALUES(location), is_active=VALUES(is_active),\n"
       ."secret=IF(secret IS NULL OR secret='', VALUES(secret), secret)";
  $ins = $mysqli->prepare($sql);
  if (!$ins) {
    // tabela pode não existir ainda
    return;
  }
  $ins->bind_param('ssssi', $panel_key, $panel_name, $location, $secret, $is_active);
  $ins->execute();
  $ins->close();
}

$id = intval($_GET['id'] ?? 0);
$panel = ['id'=>0,'store_id'=>0,'name'=>'','panel_key'=>'','width'=>96,'height'=>96,'brightness'=>10,'is_active'=>1];
$panel_secret = '';

if ($id > 0) {
    $stmt = $mysqli->prepare("SELECT * FROM panels WHERE id=?");
    $stmt->bind_param('i',$id);
    $stmt->execute();
    $panel = $stmt->get_result()->fetch_assoc();
    if (!$panel) { echo "Painel não encontrado."; require 'footer.php'; exit; }
}

// Secret (check-in/OTA) visível apenas para admin_master
if (is_admin_master() && !empty($panel['panel_key'])) {
	$stmtS = $mysqli->prepare("SELECT secret FROM ic_panels WHERE panel_key=? LIMIT 1");
	if ($stmtS) {
		$stmtS->bind_param('s', $panel['panel_key']);
		$stmtS->execute();
		$rS = $stmtS->get_result()->fetch_assoc();
		$panel_secret = $rS['secret'] ?? '';
		$stmtS->close();
	}
}

// lojas disponíveis
if (is_admin_master()) {
    $res = $mysqli->query("SELECT s.id,s.name,c.name AS client_name FROM stores s JOIN clients c ON c.id=s.client_id ORDER BY c.name,s.name");
} else {
    $res = $mysqli->query("SELECT s.id,s.name,c.name AS client_name FROM stores s JOIN clients c ON c.id=s.client_id WHERE c.id=".(int)$user['client_id']." ORDER BY s.name");
}
$stores = [];
while($s=$res->fetch_assoc()) $stores[]=$s;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $store_id   = intval($_POST['store_id'] ?? 0);
    $name       = $_POST['name'] ?? '';
    $panel_key  = $_POST['panel_key'] ?? '';
    $width      = intval($_POST['width'] ?? 96);
    $height     = intval($_POST['height'] ?? 96);
    $brightness = intval($_POST['brightness'] ?? 10);
    $is_active  = isset($_POST['is_active']) ? 1 : 0;

    if ($id > 0) {
        $stmt = $mysqli->prepare("UPDATE panels SET store_id=?, name=?, panel_key=?, width=?, height=?, brightness=?, is_active=? WHERE id=?");
        $stmt->bind_param('issiiiii',$store_id,$name,$panel_key,$width,$height,$brightness,$is_active,$id);
    } else {
        $stmt = $mysqli->prepare("INSERT INTO panels (store_id,name,panel_key,width,height,brightness,is_active) VALUES (?,?,?,?,?,?,?)");
        $stmt->bind_param('issiiii',$store_id,$name,$panel_key,$width,$height,$brightness,$is_active);
    }
    if ($stmt->execute()) {
	        // Mantém tabela de check-in (ic_panels) sincronizada e automatizada
	        $loc = null;
	        $stLoc = $mysqli->prepare("SELECT name FROM stores WHERE id=? LIMIT 1");
	        if ($stLoc) {
	            $stLoc->bind_param('i', $store_id);
	            if ($stLoc->execute()) {
	                $resLoc = $stLoc->get_result();
	                $rowLoc = $resLoc ? $resLoc->fetch_assoc() : null;
	                if ($rowLoc && isset($rowLoc['name'])) $loc = $rowLoc['name'];
	            }
	            $stLoc->close();
	        }
	        ensure_ic_panels_row($mysqli, $panel_key, $name, $loc, $is_active);

        header('Location: panels_list.php');
        exit;
    } else {
        echo '<div class="alert alert-danger">Erro ao salvar.</div>';
    }
}
?>
<h3><?= $id>0 ? 'Editar' : 'Novo' ?> Painel</h3>
<form method="post" style="max-width:500px;">
  <div class="mb-3">
    <label class="form-label">Loja</label>
    <select name="store_id" class="form-select" required>
      <?php foreach($stores as $s): ?>
        <option value="<?= $s['id'] ?>" <?= $s['id']==$panel['store_id']?'selected':'' ?>>
          <?= htmlspecialchars($s['client_name'].' - '.$s['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Nome do Painel</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($panel['name']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Panel Key (usar no ESP32)</label>
    <input type="text" name="panel_key" class="form-control" value="<?= htmlspecialchars($panel['panel_key']) ?>" required>
  </div>
  <?php if (is_admin_master()): ?>
    <div class="mb-3">
      <label class="form-label">Secret (Check-in/OTA) <small class="text-muted">(automático)</small></label>
      <?php $secret_value = ($panel_secret ?: ''); ?>
      <div class="d-flex gap-2 align-items-start">
        <div class="flex-grow-1">
          <input id="panelSecret" type="text" class="form-control" value="<?= htmlspecialchars($secret_value ?: 'ainda não gerado (será criado automaticamente no 1º check-in ou ao salvar)') ?>" readonly>
          <div class="form-text">Esse secret é único por painel e será usado no firmware para assinar o check-in (sig). Depois vamos colocar um leitor de QR Code no portal Wi‑Fi para preencher automaticamente.</div>
        </div>
        <div class="d-flex flex-column gap-2">
          <button type="button" class="btn btn-outline-secondary" onclick="copySecret()">Copiar</button>
          <?php if ($secret_value): ?>
            <img
              alt="QR Code do secret"
              style="width:140px;height:140px;border:1px solid #e5e5e5;border-radius:8px;"
              src="https://api.qrserver.com/v1/create-qr-code/?size=140x140&data=<?= rawurlencode($secret_value) ?>"
              onerror="this.style.display='none';this.nextElementSibling.style.display='flex';">
            <div class="text-muted" style="display:none;width:140px;height:140px;border:1px dashed #ddd;border-radius:8px;align-items:center;justify-content:center;font-size:12px;">QR indisponível</div>
          <?php else: ?>
            <div class="text-muted" style="width:140px;height:140px;border:1px dashed #ddd;border-radius:8px;display:flex;align-items:center;justify-content:center;font-size:12px;">QR disponível após gerar</div>
          <?php endif; ?>
        </div>
      </div>
      <div class="form-text">Esse secret é único por painel e será usado no firmware para assinar o check-in (sig). No momento, se o firmware ainda não enviar a assinatura, o servidor aceita e marca como <code>sig_missing</code> no dashboard.</div>
    </div>
  <?php endif; ?>
  <div class="row mb-3">
    <div class="col">
      <label class="form-label">Largura</label>
      <input type="number" name="width" class="form-control" value="<?= htmlspecialchars($panel['width']) ?>">
    </div>
    <div class="col">
      <label class="form-label">Altura</label>
      <input type="number" name="height" class="form-control" value="<?= htmlspecialchars($panel['height']) ?>">
    </div>
    <div class="col">
      <label class="form-label">Brilho</label>
      <input type="number" name="brightness" class="form-control" value="<?= htmlspecialchars($panel['brightness']) ?>">
    </div>
  </div>
  <div class="form-check mb-3">
    <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= $panel['is_active']?'checked':'' ?>>
    <label class="form-check-label" for="is_active">Ativo</label>
  </div>
  <button class="btn btn-primary" type="submit">Salvar</button>
  <a href="panels_list.php" class="btn btn-secondary">Voltar</a>
</form>

<script>
  function copySecret(){
    const el = document.getElementById('panelSecret');
    if (!el) return;
    const v = (el.value || '').trim();
    if (!v || v.indexOf('ainda não gerado') === 0) return;
    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard.writeText(v);
    } else {
      el.select();
      document.execCommand('copy');
      el.blur();
    }
  }
</script>
<?php require 'footer.php'; ?>
