<?php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master','admin_cliente']);

$id = intval($_POST['id'] ?? $_GET['id'] ?? 0);
if ($id <= 0) {
  header('Location: panels_list.php');
  exit;
}

$panel_key = '';
$client_id = 0;
$st = $mysqli->prepare("SELECT p.panel_key, s.client_id FROM panels p JOIN stores s ON s.id=p.store_id WHERE p.id=?");
$st->bind_param('i', $id);
$st->execute();
$st->bind_result($panel_key, $client_id);
if (!$st->fetch()) {
  $st->close();
  http_response_code(404);
  echo "Painel não encontrado.";
  exit;
}
$st->close();

if (is_admin_cliente() && (int)$client_id !== (int)$user['client_id']) {
  http_response_code(403);
  echo "Acesso negado.";
  exit;
}

// remove comandos pendentes
$st = $mysqli->prepare("DELETE FROM ic_panel_commands WHERE panel_id=?");
$st->bind_param('i', $id);
$st->execute();
$st->close();

// remove painel (playlist/settings têm FK cascade)
$st = $mysqli->prepare("DELETE FROM panels WHERE id=? LIMIT 1");
$st->bind_param('i', $id);
$st->execute();
$st->close();

$redir = 'panels_list.php';
if (is_admin_master() && $client_id > 0) {
  $redir .= '?client_id=' . (int)$client_id;
}
header('Location: ' . $redir);
exit;
