<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$panel_id = intval($_GET['id'] ?? 0);
if ($panel_id <= 0) { echo "Painel inválido."; require 'footer.php'; exit; }

$stmt = $mysqli->prepare("SELECT p.id, p.name, s.name AS store_name, c.id AS client_id, c.name AS client_name
                          FROM panels p
                          JOIN stores s ON s.id=p.store_id
                          JOIN clients c ON c.id=s.client_id
                          WHERE p.id=?");
$stmt->bind_param('i', $panel_id);
$stmt->execute();
$panel = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$panel) { echo "Painel não encontrado."; require 'footer.php'; exit; }
if (!is_admin_master() && $panel['client_id'] != $user['client_id']) { echo "Acesso negado."; require 'footer.php'; exit; }

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $action = $_POST['action'] ?? '';
  if ($action==='add') {
    $item_type = ($_POST['item_type']==='message') ? 'message' : 'offer';
    $item_id = intval($_POST['item_id'] ?? 0);
    if ($item_id>0) {
      $res = $mysqli->query("SELECT COALESCE(MAX(position),0) AS maxpos FROM panel_playlist WHERE panel_id=".(int)$panel_id);
      $pos = (int)($res->fetch_assoc()['maxpos'] ?? 0) + 1;
      $st = $mysqli->prepare("INSERT INTO panel_playlist(panel_id,item_type,item_id,position,enabled) VALUES(?,?,?,?,1)");
      $st->bind_param('isii', $panel_id, $item_type, $item_id, $pos);
      $st->execute(); $st->close();
    }
  }
  if ($action==='remove') {
    $pl_id = intval($_POST['pl_id'] ?? 0);
    $st = $mysqli->prepare("DELETE FROM panel_playlist WHERE id=? AND panel_id=?");
    $st->bind_param('ii',$pl_id,$panel_id); $st->execute(); $st->close();
  }
  if ($action==='toggle') {
    $pl_id = intval($_POST['pl_id'] ?? 0);
    $enabled = intval($_POST['enabled'] ?? 0) ? 1 : 0;
    $st = $mysqli->prepare("UPDATE panel_playlist SET enabled=? WHERE id=? AND panel_id=?");
    $st->bind_param('iii',$enabled,$pl_id,$panel_id); $st->execute(); $st->close();
  }
  if ($action==='move') {
    $pl_id = intval($_POST['pl_id'] ?? 0);
    $dir = $_POST['dir'] ?? '';
    if (in_array($dir,['up','down'],true)) {
      $st = $mysqli->prepare("SELECT id, position FROM panel_playlist WHERE id=? AND panel_id=?");
      $st->bind_param('ii',$pl_id,$panel_id); $st->execute();
      $cur = $st->get_result()->fetch_assoc(); $st->close();
      if ($cur) {
        $pos = (int)$cur['position'];
        if ($dir==='up') {
          $st = $mysqli->prepare("SELECT id, position FROM panel_playlist WHERE panel_id=? AND position < ? ORDER BY position DESC LIMIT 1");
        } else {
          $st = $mysqli->prepare("SELECT id, position FROM panel_playlist WHERE panel_id=? AND position > ? ORDER BY position ASC LIMIT 1");
        }
        $st->bind_param('ii',$panel_id,$pos); $st->execute();
        $other = $st->get_result()->fetch_assoc(); $st->close();
        if ($other) {
          $st = $mysqli->prepare("UPDATE panel_playlist SET position=? WHERE id=? AND panel_id=?");
          $st->bind_param('iii',$other['position'],$cur['id'],$panel_id); $st->execute(); $st->close();
          $st = $mysqli->prepare("UPDATE panel_playlist SET position=? WHERE id=? AND panel_id=?");
          $st->bind_param('iii',$pos,$other['id'],$panel_id); $st->execute(); $st->close();
        }
      }
    }
  }

  // Atualiza agendamento (por item da playlist)
  if ($action==='schedule') {
    $pl_id = intval($_POST['pl_id'] ?? 0);
    $starts_at = trim($_POST['starts_at'] ?? '');
    $ends_at   = trim($_POST['ends_at'] ?? '');

    // datetime-local => "YYYY-MM-DDTHH:MM". Converte para "YYYY-MM-DD HH:MM:SS".
    $starts_sql = null;
    $ends_sql   = null;

    if ($starts_at !== '') {
      $starts_at = str_replace('T', ' ', $starts_at);
      if (preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}$/', $starts_at)) {
        $starts_sql = $starts_at . ':00';
      }
    }
    if ($ends_at !== '') {
      $ends_at = str_replace('T', ' ', $ends_at);
      if (preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}$/', $ends_at)) {
        $ends_sql = $ends_at . ':00';
      }
    }

    // valida: fim não pode ser menor que início (quando ambos definidos)
    if ($starts_sql && $ends_sql && strtotime($ends_sql) < strtotime($starts_sql)) {
      $_SESSION['flash_error'] = 'Agendamento inválido: a data/hora de saída não pode ser menor que a de entrada.';
      header("Location: panel_contents.php?id={$panel_id}");
      exit;
    }

    $starts_esc = $starts_sql ? ("'".$mysqli->real_escape_string($starts_sql)."'") : 'NULL';
    $ends_esc   = $ends_sql   ? ("'".$mysqli->real_escape_string($ends_sql)."'")   : 'NULL';
    $mysqli->query("UPDATE panel_playlist SET starts_at={$starts_esc}, ends_at={$ends_esc} WHERE id=".(int)$pl_id." AND panel_id=".(int)$panel_id." LIMIT 1");

    $_SESSION['flash_success'] = 'Agendamento atualizado.';
    header("Location: panel_contents.php?id={$panel_id}");
    exit;
  }
  header("Location: panel_contents.php?id=".$panel_id."&ok=1"); exit;
}

$playlist = [];
$st = $mysqli->prepare("SELECT pl.id AS pl_id, pl.item_type, pl.item_id, pl.position, pl.enabled, pl.starts_at, pl.ends_at,
                               o.name AS offer_name, o.title AS offer_title,
                               m.name AS message_name
                        FROM panel_playlist pl
                        LEFT JOIN offers o ON (pl.item_type='offer' AND o.id=pl.item_id)
                        LEFT JOIN messages m ON (pl.item_type='message' AND m.id=pl.item_id)
                        WHERE pl.panel_id=?
                        ORDER BY pl.position ASC, pl.id ASC");
$st->bind_param('i',$panel_id); $st->execute();
$r = $st->get_result(); while($row=$r->fetch_assoc()) $playlist[]=$row; $st->close();

$offers=[]; $st=$mysqli->prepare("SELECT id,name,title FROM offers WHERE client_id=? ORDER BY updated_at DESC,id DESC");
$st->bind_param('i',$panel['client_id']); $st->execute(); $r=$st->get_result(); while($row=$r->fetch_assoc()) $offers[]=$row; $st->close();
$messages=[]; $st=$mysqli->prepare("SELECT id,name FROM messages WHERE client_id=? ORDER BY updated_at DESC,id DESC");
$st->bind_param('i',$panel['client_id']); $st->execute(); $r=$st->get_result(); while($row=$r->fetch_assoc()) $messages[]=$row; $st->close();
?>
<h3>Conteúdos do Painel (ordem intercalada)</h3>
<p class="text-muted"><strong>Painel:</strong> <?= htmlspecialchars($panel['name']) ?> — <strong>Cliente:</strong> <?= htmlspecialchars($panel['client_name']) ?> — <strong>Loja:</strong> <?= htmlspecialchars($panel['store_name']) ?></p>
<?php if (!empty($_GET['ok'])): ?><div class="alert alert-success">Alterações salvas.</div><?php endif; ?>

<div class="row g-3">
  <div class="col-md-5">
    <div class="card">
      <div class="card-header">
        <ul class="nav nav-tabs card-header-tabs">
          <li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tabOffers" type="button">Ofertas</button></li>
          <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tabMessages" type="button">Mensagens</button></li>
        </ul>
      </div>
      <div class="card-body">
        <div class="tab-content">
          <div class="tab-pane fade show active" id="tabOffers">
            <div style="max-height:520px; overflow:auto;">
              <?php foreach($offers as $o): ?>
                <div class="d-flex justify-content-between align-items-center border rounded p-2 mb-2">
                  <div><strong><?= htmlspecialchars($o['name']) ?></strong><div class="text-muted small"><?= htmlspecialchars($o['title']) ?></div></div>
                  <form method="post">
                    <input type="hidden" name="action" value="add">
                    <input type="hidden" name="item_type" value="offer">
                    <input type="hidden" name="item_id" value="<?= (int)$o['id'] ?>">
                    <button class="btn btn-sm btn-outline-primary">Adicionar</button>
                  </form>
                </div>
              <?php endforeach; ?>
              <?php if(!$offers): ?><div class="text-muted">Nenhuma oferta cadastrada.</div><?php endif; ?>
            </div>
          </div>
          <div class="tab-pane fade" id="tabMessages">
            <div style="max-height:520px; overflow:auto;">
              <?php foreach($messages as $m): ?>
                <div class="d-flex justify-content-between align-items-center border rounded p-2 mb-2">
                  <div><strong><?= htmlspecialchars($m['name']) ?></strong><div class="text-muted small">Mensagem</div></div>
                  <form method="post">
                    <input type="hidden" name="action" value="add">
                    <input type="hidden" name="item_type" value="message">
                    <input type="hidden" name="item_id" value="<?= (int)$m['id'] ?>">
                    <button class="btn btn-sm btn-outline-primary">Adicionar</button>
                  </form>
                </div>
              <?php endforeach; ?>
              <?php if(!$messages): ?><div class="text-muted">Nenhuma mensagem cadastrada.</div><?php endif; ?>
            </div>
          </div>
        </div>
      </div>
      <div class="card-footer d-flex gap-2">
        <a href="offers_list.php" class="btn btn-sm btn-outline-secondary">Gerenciar Ofertas</a>
        <a href="messages_list.php" class="btn btn-sm btn-outline-secondary">Gerenciar Mensagens</a>
      </div>
    </div>
  </div>

  <div class="col-md-7">
    <div class="card">
      <div class="card-header d-flex justify-content-between align-items-center">
        <strong>Playlist intercalada</strong>
        <a href="panel_preview.php?id=<?= (int)$panel_id ?>" class="btn btn-sm btn-primary">Preview</a>
      </div>
      <div class="card-body">
        <?php if(!$playlist): ?>
          <div class="text-muted">Adicione ofertas/mensagens à playlist.</div>
        <?php else: ?>
          <div class="list-group">
          <?php foreach($playlist as $it): ?>
            <div class="list-group-item d-flex justify-content-between align-items-center">
              <div>
                <?php if($it['item_type']==='offer'): ?>
                  <span class="badge bg-info text-dark me-2">Oferta</span>
                  <strong><?= htmlspecialchars($it['offer_name'] ?: ('Oferta #'.$it['item_id'])) ?></strong>
                  <span class="text-muted small">— <?= htmlspecialchars($it['offer_title'] ?: '') ?></span>
                <?php else: ?>
                  <span class="badge bg-secondary me-2">Mensagem</span>
                  <strong><?= htmlspecialchars($it['message_name'] ?: ('Mensagem #'.$it['item_id'])) ?></strong>
                <?php endif; ?>
                <?php
                  $now = new DateTime('now', new DateTimeZone('America/Sao_Paulo'));
                  $st = $it['starts_at'] ? new DateTime($it['starts_at'], new DateTimeZone('America/Sao_Paulo')) : null;
                  $en = $it['ends_at'] ? new DateTime($it['ends_at'], new DateTimeZone('America/Sao_Paulo')) : null;
                  $status = 'Inativo';
                  if ((int)$it['enabled']===1) {
                    if ($st && $st > $now) $status = 'Programado';
                    else if ($en && $en < $now) $status = 'Expirado';
                    else $status = 'Ativo';
                  }
                ?>
                <div class="text-muted small">Posição: <?= (int)$it['position'] ?> · Status: <strong><?= htmlspecialchars($status) ?></strong></div>
                <div class="text-muted small">
                  <?php if($it['starts_at']): ?>
                    Início: <?= htmlspecialchars($it['starts_at']) ?>
                  <?php else: ?>
                    Início: —
                  <?php endif; ?>
                  &nbsp;|&nbsp;
                  <?php if($it['ends_at']): ?>
                    Fim: <?= htmlspecialchars($it['ends_at']) ?>
                  <?php else: ?>
                    Fim: —
                  <?php endif; ?>
                </div>
              </div>
              <div class="d-flex gap-2 align-items-center">
                <form method="post" class="d-flex gap-1 align-items-center">
                  <input type="hidden" name="action" value="schedule">
                  <input type="hidden" name="pl_id" value="<?= (int)$it['pl_id'] ?>">
                  <input type="datetime-local" name="starts_at" class="form-control form-control-sm" style="width:180px"
                    value="<?= $it['starts_at'] ? htmlspecialchars(str_replace(' ','T',substr($it['starts_at'],0,16))) : '' ?>"
                    title="Início (opcional)">
                  <input type="datetime-local" name="ends_at" class="form-control form-control-sm" style="width:180px"
                    value="<?= $it['ends_at'] ? htmlspecialchars(str_replace(' ','T',substr($it['ends_at'],0,16))) : '' ?>"
                    title="Fim (opcional)">
                  <button class="btn btn-sm btn-outline-primary">Salvar</button>
                </form>
                <form method="post">
                  <input type="hidden" name="action" value="toggle">
                  <input type="hidden" name="pl_id" value="<?= (int)$it['pl_id'] ?>">
                  <input type="hidden" name="enabled" value="<?= $it['enabled'] ? 0 : 1 ?>">
                  <button class="btn btn-sm <?= $it['enabled'] ? 'btn-outline-success' : 'btn-outline-danger' ?>"><?= $it['enabled'] ? 'Ativo' : 'Inativo' ?></button>
                </form>
                <form method="post"><input type="hidden" name="action" value="move"><input type="hidden" name="pl_id" value="<?= (int)$it['pl_id'] ?>"><input type="hidden" name="dir" value="up"><button class="btn btn-sm btn-outline-secondary">↑</button></form>
                <form method="post"><input type="hidden" name="action" value="move"><input type="hidden" name="pl_id" value="<?= (int)$it['pl_id'] ?>"><input type="hidden" name="dir" value="down"><button class="btn btn-sm btn-outline-secondary">↓</button></form>
                <form method="post" onsubmit="return confirm('Remover?');"><input type="hidden" name="action" value="remove"><input type="hidden" name="pl_id" value="<?= (int)$it['pl_id'] ?>"><button class="btn btn-sm btn-outline-danger">Remover</button></form>
              </div>
            </div>
          <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
      <div class="card-footer text-muted small">A ordem do painel é exatamente esta lista (intercalada).</div>
    </div>
  </div>
</div>

<?php require 'footer.php'; ?>
