<?php
require_once __DIR__ . '/auth.php';
require_role(['admin_master']);
require_once __DIR__ . '/header.php';
require_once __DIR__ . '/../api/_db.php';
header("Content-Type: text/html; charset=utf-8");

date_default_timezone_set('America/Sao_Paulo');
$ONLINE_SECONDS = 360;

$client_id = 0;
$clients = [];
if (function_exists('is_admin_master') && is_admin_master()) {
  $client_id = intval($_GET['client_id'] ?? 0);
  $clients = $pdo->query("SELECT id,name FROM clients ORDER BY name")->fetchAll();
} else if (function_exists('is_admin_cliente') && is_admin_cliente()) {
  $client_id = intval($user['client_id'] ?? 0);
}

$sql = "SELECT p.id,p.panel_key,p.name,p.location,p.is_active,p.secret,p.created_at,
               c.id AS client_id,c.name AS client_name,s.name AS store_name,pp.name AS panel_name
        FROM ic_panels p
        LEFT JOIN panels pp ON pp.panel_key = p.panel_key
        LEFT JOIN stores s ON s.id = pp.store_id
        LEFT JOIN clients c ON c.id = s.client_id
        WHERE pp.panel_key IS NOT NULL";
if ($client_id > 0) $sql .= " AND c.id = :client_id";
$sql .= " ORDER BY p.id DESC";

$stPanels = $pdo->prepare($sql);
if ($client_id > 0) $stPanels->bindValue(':client_id', $client_id, PDO::PARAM_INT);
$stPanels->execute();
$panels = $stPanels->fetchAll();

$stLast = $pdo->prepare("SELECT id,fw_version,mac,ip_local,rssi,uptime_ms,free_heap,free_psram,wifi_ssid,status,last_error,payload_hash,temp_c,brightness,mode,created_at FROM ic_panel_checkins WHERE panel_id=? ORDER BY id DESC LIMIT 1");
$stLed = $pdo->prepare("SELECT cmd FROM ic_panel_commands WHERE panel_id=? AND cmd IN ('leds_on','leds_off') ORDER BY id DESC LIMIT 1");
$stRes = $pdo->prepare("SELECT cmd FROM ic_panel_commands WHERE panel_id=? AND cmd IN ('rescue','rescue_off') ORDER BY id DESC LIMIT 1");
$stSet = $pdo->prepare("SELECT power, use_schedule, on_time, off_time FROM panel_settings WHERE panel_id=? LIMIT 1");

$now = time();
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
$panelMeta = [];
?>

<style>
  .switch-btn{
    display:inline-flex; align-items:center; gap:8px;
    border:1px solid rgba(255,255,255,.2); background:transparent; color:#fff;
    padding:4px 8px; border-radius:999px; cursor:pointer; font-size:12px;
  }
  .switch-track{
    width:36px; height:20px; border-radius:999px; position:relative;
    background:#b02a37; box-shadow:inset 0 0 0 1px rgba(0,0,0,.35);
  }
  .switch-thumb{
    width:14px; height:14px; border-radius:50%; background:#fff;
    position:absolute; top:3px; left:3px; transition:all .15s ease;
  }
  .switch-on .switch-track{ background:#1f8a4c; }
  .switch-on .switch-thumb{ left:19px; }
  .btn-restart-icon{
    color:#ffc107; border:1px solid #ffc107; background:transparent;
    border-radius:50%; width:30px; height:30px;
    display:inline-flex; align-items:center; justify-content:center;
  }
  .btn-restart-icon .power{ font-size:16px; line-height:1; }
  .action-btn{ height:30px; display:inline-flex; align-items:center; }
  .action-btn.btn{ padding-top:0; padding-bottom:0; }
  .card-compact .card-body{
    padding:12px;
    display:flex;
    flex-direction:column;
    justify-content:center;
  }
  .panel-meta{ display:flex; flex-wrap:wrap; gap:8px 14px; align-items:center; color:#b7bcc2; background:rgba(255,255,255,0.04); border-radius:4px; padding:6px 10px; }
  .panel-meta .label{ color:#9aa3aa; font-size:12px; }
  .panel-meta .value{ font-size:13px; }
  .panel-card:last-child{ margin-bottom:16px; }
</style>

<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="mb-0">Dashboard de Painéis</h3>
    <div class="text-secondary small">Online = visto ≤ <?php echo (int)$ONLINE_SECONDS; ?>s</div>
  </div>
  <div class="d-flex gap-2 align-items-center">
    <?php if (function_exists('is_admin_master') && is_admin_master()): ?>
      <form method="get" class="m-0">
        <select name="client_id" class="form-select form-select-sm" onchange="this.form.submit()">
          <option value="0">Todos os clientes</option>
          <?php foreach ($clients as $c): ?>
            <option value="<?php echo (int)$c['id']; ?>" <?php echo ((int)$c['id']===$client_id?'selected':''); ?>>
              <?php echo h($c['name']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </form>
    <?php endif; ?>
    <a class="btn btn-outline-secondary" href="painels_dashboard.php<?php echo $client_id>0 ? '?client_id='.(int)$client_id : ''; ?>" title="Atualizar lista de painéis">Atualizar</a>
  </div>
</div>


<div class="row g-3">
<?php foreach ($panels as $p):
  $stLast->execute([$p['id']]);
  $c = $stLast->fetch();
  $stLed->execute([$p['id']]);
  $ledCmd = $stLed->fetchColumn();
  $ledState = ($ledCmd === 'leds_on') ? 'ligado' : 'desligado';
  $stSet->execute([$p['id']]);
  $cfg = $stSet->fetch();
  if(!$cfg){
    $cfg = ['power'=>1,'use_schedule'=>0,'on_time'=>'08:00','off_time'=>'22:00'];
  }
  $schedule_label = $cfg['use_schedule'] ? ($cfg['on_time'].' - '.$cfg['off_time']) : 'desativada';
  $seen = $c ? strtotime($c['created_at']) : 0;
  $online = $seen && (($now - $seen) <= $ONLINE_SECONDS);
  $isUpdating = $online && isset($c['status']) && $c['status'] === 'UPDATING';
?>
  <div class="col-12 panel-card">
    <div class="card bg-dark text-light card-compact" style="border:1px solid rgba(255,255,255,.08)">
      <div class="card-body">
        <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
          <div>
            <div class="h6 mb-0"><?php echo h($p['panel_key']); ?></div>
            <div class="text-secondary small"><?php echo h($p['name'] ?: 'Sem nome'); ?><?php if (!empty($p['location'])) echo ' • '.h($p['location']); ?></div>
            <?php if (!empty($p['client_name'])): ?>
              <div class="text-secondary small">Cliente: <?php echo h($p['client_name']); ?></div>
            <?php endif; ?>
          </div>
          <div class="d-flex align-items-center gap-2">
            <span class="badge <?php echo $isUpdating ? 'bg-warning text-dark' : ($online ? 'bg-success' : 'bg-danger'); ?>">
              <?php echo $isUpdating ? 'ATUALIZANDO' : ($online ? 'ONLINE' : 'OFFLINE'); ?>
            </span>
            <form method="post" action="../api/panel_cmd.php" class="m-0" onsubmit="return confirm('Reiniciar o painel agora?');">
              <input type="hidden" name="panel_key" value="<?php echo h($p['panel_key']); ?>">
              <input type="hidden" name="cmd" value="restart">
              <input type="hidden" name="redirect" value="../admin/painels_dashboard.php<?php echo $client_id>0 ? '?client_id='.(int)$client_id : ''; ?>">
              <button type="submit" class="btn-restart-icon action-btn" title="Reiniciar o painel">
                <span class="power">&#x23FB;</span>
              </button>
            </form>
            <form method="post" action="../api/panel_cmd.php" class="m-0"
                  onsubmit="return confirm('<?php echo $ledState === 'ligado' ? 'Desligar LEDs do painel?' : 'Ligar LEDs do painel?'; ?>');">
              <input type="hidden" name="panel_key" value="<?php echo h($p['panel_key']); ?>">
              <input type="hidden" name="cmd" value="<?php echo $ledState === 'ligado' ? 'leds_off' : 'leds_on'; ?>">
              <input type="hidden" name="redirect" value="../admin/painels_dashboard.php<?php echo $client_id>0 ? '?client_id='.(int)$client_id : ''; ?>">
              <button type="submit" class="switch-btn action-btn <?php echo $ledState === 'ligado' ? 'switch-on' : ''; ?>" title="<?php echo $ledState === 'ligado' ? 'Os LEDs estão ligados' : 'Os LEDs estão desligados'; ?>">
                <span class="switch-track"><span class="switch-thumb"></span></span>
                LEDs <?php echo $ledState === 'ligado' ? 'ON' : 'OFF'; ?>
              </button>
            </form>
            <a class="btn btn-outline-light btn-sm action-btn" href="painel_detalhe.php?panel_key=<?php echo urlencode($p['panel_key']); ?>" title="Abrir detalhes do painel">Detalhes</a>
          </div>
        </div>

        <div class="panel-meta mt-2">
          <div><span class="label">Versão</span> <span class="value"><?php echo h($c['fw_version'] ?? '-'); ?></span></div>
          <div><span class="label">Visto</span> <span class="value"><?php echo $seen ? h(date('d/m/Y H:i:s', $seen)).' (há '.h($now-$seen).'s)' : '-'; ?></span></div>
          <div><span class="label">IP</span> <span class="value"><?php echo h($c['ip_local'] ?? '-'); ?></span></div>
          <div><span class="label">SSID</span> <span class="value"><?php echo h($c['wifi_ssid'] ?? '-'); ?></span></div>
          <div><span class="label">RSSI</span> <span class="value"><?php echo isset($c['rssi']) ? h($c['rssi']) : '-'; ?></span></div>
          <div><span class="label">Horário (liga/desliga)</span> <span class="value"><?php echo h($schedule_label); ?></span></div>
        </div>
      </div>
    </div>
  </div>
<?php endforeach; ?>
</div>

<script>
  setTimeout(() => location.reload(), 30000);
</script>

<?php require_once __DIR__ . '/footer.php'; ?>
