<?php
require_once __DIR__ . '/auth.php';
require_role(['admin_master']);
require_once __DIR__ . '/header.php';
require_once __DIR__ . '/../api/_db.php';
header("Content-Type: text/html; charset=utf-8");

date_default_timezone_set('America/Sao_Paulo');
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$panel_key = isset($_GET['panel_key']) ? trim($_GET['panel_key']) : '';
if ($panel_key === '') { echo '<div class="alert alert-danger">panel_key ausente.</div>'; require_once __DIR__.'/footer.php'; exit; }

$stP = $pdo->prepare("SELECT id,panel_key,name,location,is_active,secret,created_at FROM ic_panels WHERE panel_key=? LIMIT 1");
$stP->execute([$panel_key]);
$p = $stP->fetch();
if (!$p) { echo '<div class="alert alert-danger">Painel não encontrado.</div>'; require_once __DIR__.'/footer.php'; exit; }

$stC = $pdo->prepare("SELECT * FROM ic_panel_checkins WHERE panel_id=? ORDER BY id DESC LIMIT 15");
$stC->execute([$p['id']]);
$rows = $stC->fetchAll();

// Match dashboard status logic exactly
$ONLINE_SECONDS = 360;
$now = time();
$stLast = $pdo->prepare("SELECT status,fw_version,created_at FROM ic_panel_checkins WHERE panel_id=? ORDER BY id DESC LIMIT 1");
$stLast->execute([$p['id']]);
$last = $stLast->fetch();
$seen = $last ? strtotime($last['created_at']) : 0;
$is_online = $seen && (($now - $seen) <= $ONLINE_SECONDS);
$last_status = $last['status'] ?? '';
$isUpdating = $is_online && (trim((string)$last_status) === 'UPDATING');
$last_fw = $last['fw_version'] ?? '';

$stCmd = $pdo->prepare("SELECT id,cmd,status,result,created_at,sent_at,done_at FROM ic_panel_commands WHERE panel_id=? ORDER BY id DESC LIMIT 15");
$stCmd->execute([$p['id']]);
$cmds = $stCmd->fetchAll();

$stLog = $pdo->prepare("SELECT id,level,message,created_at FROM ic_panel_logs WHERE panel_id=? ORDER BY id DESC LIMIT 50");
$stLog->execute([$p['id']]);
$logs = $stLog->fetchAll();

$LOG_AJAX_LIMIT = 200;
$stLogAll = $pdo->prepare("SELECT id,level,message,created_at FROM ic_panel_logs WHERE panel_id=? ORDER BY id DESC LIMIT {$LOG_AJAX_LIMIT}");
$stLogAll->execute([$p['id']]);
$logs_all = $stLogAll->fetchAll();

$stCAll = $pdo->prepare("SELECT created_at FROM ic_panel_checkins WHERE panel_id=? ORDER BY id ASC");
$stCAll->execute([$p['id']]);
$checkins_all = $stCAll->fetchAll();

$stSet = $pdo->prepare("SELECT power, use_schedule, on_time, off_time FROM panel_settings WHERE panel_id=? LIMIT 1");
$stSet->execute([$p['id']]);
$cfg = $stSet->fetch();
if(!$cfg){
  $cfg = ['power'=>1,'use_schedule'=>0,'on_time'=>'08:00','off_time'=>'22:00'];
}
$schedule_label = $cfg['use_schedule'] ? (string)$cfg['on_time'].' - '.(string)$cfg['off_time'] : 'desativada';

$stPanelMap = $pdo->prepare("SELECT id FROM panels WHERE panel_key=? LIMIT 1");
$stPanelMap->execute([$p['panel_key']]);
$panel_map = $stPanelMap->fetch();
$panel_real_id = $panel_map ? (int)$panel_map['id'] : 0;

$active_items = [];
if($panel_real_id > 0){
  $stItems = $pdo->prepare("
    SELECT pl.item_type, pl.item_id, pl.position,
           o.name  AS offer_name,
           o.title AS offer_title,
           o.price_cents,
           o.unit,
           m.name AS message_name
    FROM panel_playlist pl
    LEFT JOIN offers   o ON (pl.item_type='offer'   AND o.id=pl.item_id)
    LEFT JOIN messages m ON (pl.item_type='message' AND m.id=pl.item_id)
    WHERE pl.panel_id=? AND pl.enabled=1
      AND (pl.starts_at IS NULL OR pl.starts_at <= NOW())
      AND (pl.ends_at   IS NULL OR pl.ends_at   >= NOW())
    ORDER BY pl.position ASC, pl.id ASC
    LIMIT 50
  ");
  $stItems->execute([$panel_real_id]);
  $active_items = $stItems->fetchAll();
}

function fmt_duration($sec){
  if($sec < 0) $sec = 0;
  $h = floor($sec / 3600);
  $m = floor(($sec % 3600) / 60);
  $s = $sec % 60;
  if($h > 0) return $h.'h '.$m.'m';
  if($m > 0) return $m.'m '.$s.'s';
  return $s.'s';
}

// Offline history
$offline_history = [];
$prev_ts = 0;
foreach($checkins_all as $c){
  $ts = strtotime($c['created_at']);
  if($prev_ts > 0){
    $gap = $ts - $prev_ts;
    if($gap > $ONLINE_SECONDS){
      $start = $prev_ts + $ONLINE_SECONDS;
      $end = $ts;
      $offline_history[] = [
        'start' => $start,
        'end' => $end,
        'duration' => $end - $start,
      ];
    }
  }
  $prev_ts = $ts;
}
if($seen && (($now - $seen) > $ONLINE_SECONDS)){
  $offline_history[] = [
    'start' => $seen + $ONLINE_SECONDS,
    'end' => null,
    'duration' => $now - ($seen + $ONLINE_SECONDS),
  ];
}
$offline_history = array_reverse($offline_history);
$offline_history = array_slice($offline_history, 0, 10);

// Recent events from logs
$events = [];
foreach($logs_all as $l){
  $lvl = trim((string)$l['level']);
  $msg = trim((string)$l['message']);
  $type = '';
  if($lvl === 'ota'){
    if(stripos($msg, 'updating') !== false) $type = 'OTA: iniciada';
    else if(stripos($msg, 'progress') !== false) $type = 'OTA: progresso';
    else if(stripos($msg, 'sha256') !== false) $type = 'OTA: erro SHA';
    else if(stripos($msg, 'download') !== false) $type = 'OTA: download';
    else if(stripos($msg, 'pending=1') !== false) $type = 'OTA: pendente';
    else if(stripos($msg, 'pending=0') !== false) $type = 'OTA: sem update';
    else $type = 'OTA';
  } else if($lvl === 'payload'){
    if(stripos($msg, 'items=') !== false) $type = 'Payload OK';
    else if(stripos($msg, 'fetch_failed') !== false) $type = 'Payload erro';
    else if(stripos($msg, 'json_error') !== false) $type = 'Payload JSON';
    else $type = 'Payload';
  } else if($lvl === 'wifi'){
    if(stripos($msg, 'connected') !== false) $type = 'WiFi conectado';
    else if(stripos($msg, 'reconnect_try') !== false) $type = 'WiFi reconectando';
    else $type = 'WiFi';
  } else if($lvl === 'cmd'){
    $type = 'Comando';
  } else if($lvl === 'rescue'){
    $type = 'Rescue';
  }
  if($type !== ''){
    $events[] = [
      'created_at' => $l['created_at'],
      'type' => $type,
      'message' => $msg,
    ];
  }
  if(count($events) >= 10) break;
}

$stLed = $pdo->prepare("SELECT cmd,result,created_at FROM ic_panel_commands WHERE panel_id=? AND cmd IN ('leds_on','leds_off') ORDER BY id DESC LIMIT 1");
$stLed->execute([$p['id']]);
$ledRow = $stLed->fetch();
$ledState = 'desconhecido';
if ($ledRow) {
  if ($ledRow['cmd'] === 'leds_on') $ledState = 'ligado';
  if ($ledRow['cmd'] === 'leds_off') $ledState = 'desligado';
}

$stRes = $pdo->prepare("SELECT cmd,result,created_at FROM ic_panel_commands WHERE panel_id=? AND cmd IN ('rescue','rescue_off') ORDER BY id DESC LIMIT 1");
$stRes->execute([$p['id']]);
$resRow = $stRes->fetch();
$rescueState = 'desconhecido';
if ($resRow) {
  if ($resRow['cmd'] === 'rescue') $rescueState = 'on';
  if ($resRow['cmd'] === 'rescue_off') $rescueState = 'off';
}

if (isset($_GET['ajax']) && $_GET['ajax'] === '1') {
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode([
    'online' => $is_online,
    'updating' => $isUpdating,
    'seen' => $seen,
    'now' => $now,
    'online_seconds' => $ONLINE_SECONDS,
    'last_status' => $last_status,
    'offline_history' => array_map(function($o){
      return [
        'start' => $o['start'],
        'end' => $o['end'],
        'duration' => $o['duration'],
      ];
    }, $offline_history),
    'events' => $events,
    'logs' => $logs_all,
  ]);
  exit;
}
?>

<style>
  .sticky-topbar{
    position: sticky;
    top: 0;
    z-index: 1030;
    background: #fff;
    padding-top: 8px;
    padding-bottom: 8px;
    border-bottom: 1px solid #e6e6e6;
  }
  .switch-btn{
    display:inline-flex; align-items:center; gap:10px;
    border:1px solid #2b2f33; background:#0f1113; color:#fff;
    padding:8px 12px; border-radius:999px; cursor:pointer;
  }
  .switch-track{
    width:52px; height:28px; border-radius:999px; position:relative;
    background:#b02a37; box-shadow:inset 0 0 0 1px rgba(0,0,0,.35);
  }
  .switch-thumb{
    width:22px; height:22px; border-radius:50%; background:#fff;
    position:absolute; top:3px; left:3px; transition:all .15s ease;
  }
  .switch-on .switch-track{ background:#1f8a4c; }
  .switch-on .switch-thumb{ left:27px; }
  .switch-label{ font-size:13px; color:#cbd3da; }
  .top-actions{ display:flex; align-items:center; gap:12px; flex-wrap:wrap; }
  .top-actions .group{ display:flex; align-items:center; gap:10px; }
  .btn-icon{
    display:inline-flex; flex-direction:column; align-items:center; gap:2px;
    border:0; background:transparent; color:#dc3545; padding:0;
  }
  .btn-icon.btn-restart .power{ font-size:36px; line-height:1; }
  .btn-restart-wrap{ display:inline-flex; align-items:center; }
  .btn-restart-label{ color:#dc3545; font-size:12px; line-height:1; }
  .log-level-hb{ color:#9aa0a6; }
  .log-level-ota{ color:#ffd166; }
  .log-level-payload{ color:#4cc9f0; }
  .log-level-chk{ color:#f4d35e; }
  .log-level-cmd{ color:#bdb2ff; }
  .log-level-wifi{ color:#80ed99; }
  .log-level-render{ color:#adb5bd; }
  .log-level-log{ color:#ff6b6b; }
  .panel-info .row > div{ margin-bottom:10px; }
</style>

<div class="sticky-topbar">
  <div class="d-flex justify-content-between align-items-center">
  <div>
    <h3 class="mb-0"><?php echo h($p['panel_key']); ?></h3>
    <div class="text-secondary small"><?php echo h($p['name'] ?: 'Sem nome'); ?><?php if (!empty($p['location'])) echo ' &bull; '.h($p['location']); ?></div>
  </div>
  <div class="top-actions">
    <span class="text-secondary small" id="seen-label">Visto: <?php echo $seen ? h(date('d/m/Y H:i:s', $seen)).' (há '.h($now-$seen).'s)' : '-'; ?></span>
    <span class="badge <?php echo $isUpdating ? 'bg-warning text-dark' : ($is_online ? 'bg-success' : 'bg-danger'); ?>" id="status-badge">
      <?php echo $isUpdating ? 'ATUALIZANDO' : ($is_online ? 'ONLINE' : 'OFFLINE'); ?>
    </span>
    <div class="group">
    <a class="btn btn-outline-secondary" href="painels_dashboard.php" title="Voltar para o dashboard">Dashboard</a>
    <a class="btn btn-outline-secondary" href="painel_detalhe.php?panel_key=<?php echo urlencode($p['panel_key']); ?>" title="Atualizar esta página">Atualizar</a>
    <a class="btn btn-outline-secondary" href="../atualizacoes/admin.php" target="_blank" rel="noopener" title="Abrir OTA Admin">OTA</a>
  </div>
    <div class="group">
      <form method="post" action="../api/panel_cmd.php" class="m-0"
          onsubmit="if('<?php echo $rescueState; ?>'==='on'){ return confirm('Sair do modo RESCUE?'); } var c=prompt('CONFIRME RESCUE (digite RESCUE):'); if(c!=='RESCUE') return false; return true;">
        <input type="hidden" name="panel_key" value="<?php echo h($p['panel_key']); ?>">
        <input type="hidden" name="cmd" value="<?php echo $rescueState === 'on' ? 'rescue_off' : 'rescue'; ?>">
        <input type="hidden" name="payload[confirm]" value="YES">
        <input type="hidden" name="redirect" value="../admin/painel_detalhe.php?panel_key=<?php echo urlencode($p['panel_key']); ?>">
      <button type="submit"
              class="switch-btn <?php echo $rescueState === 'on' ? '' : 'switch-on'; ?>"
              title="<?php echo $rescueState === 'on' ? 'Rescue ativo' : 'Rescue desligado'; ?>">
        <span class="switch-track"><span class="switch-thumb"></span></span>
        <span class="switch-label">Rescue <?php echo $rescueState === 'on' ? 'ON' : 'OFF'; ?></span>
      </button>
      </form>
      <form method="post" action="../api/panel_cmd.php" class="m-0"
          onsubmit="return confirm('<?php echo $ledState === 'ligado' ? 'Desligar LEDs do painel?' : 'Ligar LEDs do painel?'; ?>');">
        <input type="hidden" name="panel_key" value="<?php echo h($p['panel_key']); ?>">
        <input type="hidden" name="cmd" value="<?php echo $ledState === 'ligado' ? 'leds_off' : 'leds_on'; ?>">
        <input type="hidden" name="redirect" value="../admin/painel_detalhe.php?panel_key=<?php echo urlencode($p['panel_key']); ?>">
      <button type="submit"
              class="switch-btn <?php echo $ledState === 'ligado' ? 'switch-on' : ''; ?>"
              title="<?php echo $ledState === 'ligado' ? 'Os LEDs estão ligados' : 'Os LEDs estão desligados'; ?>">
        <span class="switch-track"><span class="switch-thumb"></span></span>
        <span class="switch-label">LEDs <?php echo $ledState === 'ligado' ? 'ON' : 'OFF'; ?></span>
      </button>
      </form>
    </div>
    <div class="group">
      <form method="post" action="../api/panel_cmd.php" class="m-0" onsubmit="return confirm('Reiniciar o painel agora?');">
        <input type="hidden" name="panel_key" value="<?php echo h($p['panel_key']); ?>">
        <input type="hidden" name="cmd" value="restart">
        <input type="hidden" name="redirect" value="../admin/painel_detalhe.php?panel_key=<?php echo urlencode($p['panel_key']); ?>">
        <div class="btn-restart-wrap">
          <button type="submit" class="btn-icon btn-restart" title="Reiniciar o painel">
            <span class="power">&#x23FB;</span>
            <span class="btn-restart-label">Reiniciar</span>
          </button>
        </div>
      </form>
    </div>
  </div>
  </div>
</div>

<div class="card mb-3 panel-info">
  <div class="card-body">
    <div class="row small">
      <div class="col-md-3"><span class="text-secondary">Ativo</span><br><?php echo $p['is_active'] ? 'Sim' : 'Não'; ?></div>
      <div class="col-md-3"><span class="text-secondary">Criado</span><br><?php echo h($p['created_at'] ?? '-'); ?></div>
      <div class="col-md-3"><span class="text-secondary">LEDs</span><br><?php echo h(ucfirst($ledState)); ?></div>
      <div class="col-md-3"><span class="text-secondary">Firmware</span><br><?php echo h($last_fw ?: '-'); ?></div>
      <div class="col-md-3"><span class="text-secondary">Horário (liga/desliga)</span><br><?php echo h($schedule_label); ?></div>
      <div class="col-md-6"><span class="text-secondary">Secret (assinatura)</span><br><code><?php echo h($p['secret'] ?: '(vazio)'); ?></code></div>
    </div>
  </div>
</div>

<div class="card mb-3">
  <div class="card-header">Itens ativos no painel</div>
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-dark table-striped table-hover mb-0 align-middle">
        <thead>
          <tr>
            <th>Posição</th>
            <th>Tipo</th>
            <th>Nome</th>
            <th>Detalhe</th>
          </tr>
        </thead>
        <tbody>
        <?php if (!$active_items): ?>
          <tr><td colspan="4" class="text-center text-secondary py-4">Nenhum item ativo no momento.</td></tr>
        <?php else: foreach ($active_items as $it): ?>
          <tr>
            <td><?php echo h($it['position'] ?? '-'); ?></td>
            <td><?php echo h($it['item_type'] === 'offer' ? 'Oferta' : 'Mensagem'); ?></td>
            <td>
              <?php
                if($it['item_type'] === 'offer') echo h($it['offer_name'] ?: ('Oferta #'.$it['item_id']));
                else echo h($it['message_name'] ?: ('Mensagem #'.$it['item_id']));
              ?>
            </td>
            <td>
              <?php if($it['item_type'] === 'offer'): ?>
                <?php
                  $price = '';
                  if(isset($it['price_cents'])){
                    $price = number_format(((int)$it['price_cents'])/100, 2, ',', '.');
                    $unit = $it['unit'] ? (' '.$it['unit']) : '';
                    $price = $price . $unit;
                  }
                  echo h(($it['offer_title'] ?? '') . ($price ? ' • '.$price : ''));
                ?>
              <?php else: ?>
                <?php echo h($it['message_name'] ?? ''); ?>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<div class="card mt-3">
  <div class="card-header">Comandos</div>
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-dark table-striped table-hover mb-0 align-middle">
        <thead>
          <tr>
            <th>ID</th>
            <th>Comando</th>
            <th>Status</th>
            <th>Criado</th>
            <th>Enviado</th>
            <th>Concluído</th>
            <th>Resultado</th>
          </tr>
        </thead>
        <tbody>
        <?php if (!$cmds): ?>
          <tr><td colspan="7" class="text-center text-secondary py-4">Nenhum comando.</td></tr>
        <?php else: foreach ($cmds as $idx => $c): ?>
          <tr class="command-row" style="<?php echo $idx < 5 ? '' : 'display:none;'; ?>">
            <td><?php echo h($c['id']); ?></td>
            <td><?php echo h($c['cmd']); ?></td>
            <td><?php echo h($c['status']); ?></td>
            <td><?php echo h($c['created_at']); ?></td>
            <td><?php echo h($c['sent_at'] ?? '-'); ?></td>
            <td><?php echo h($c['done_at'] ?? '-'); ?></td>
            <td><?php echo h($c['result'] ?? '-'); ?></td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
    <?php if (count($cmds) > 5): ?>
      <div class="text-end p-2 bg-dark" style="border-top:1px solid rgba(255,255,255,.08);">
        <button type="button" class="btn btn-sm btn-outline-light btn-show-more" data-target="command-row" data-increment="5">Ver mais</button>
      </div>
    <?php endif; ?>
  </div>
</div>

<div class="card mb-3">
  <div class="card-header">Offline / Online (últimos 10)</div>
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-dark table-striped table-hover mb-0 align-middle">
        <thead>
          <tr>
            <th>Ficou offline</th>
            <th>Voltou online</th>
            <th>Duração</th>
          </tr>
        </thead>
        <tbody id="offline-body">
        <?php if (!$offline_history): ?>
          <tr><td colspan="3" class="text-center text-secondary py-4">Sem quedas detectadas.</td></tr>
        <?php else: foreach ($offline_history as $idx => $o): ?>
          <tr class="offline-row" style="<?php echo $idx < 5 ? '' : 'display:none;'; ?>">
            <td><?php echo h(date('d/m/Y H:i:s', $o['start'])); ?></td>
            <td><?php echo $o['end'] ? h(date('d/m/Y H:i:s', $o['end'])) : '<span class="text-warning">offline agora</span>'; ?></td>
            <td><?php echo h(fmt_duration($o['duration'])); ?></td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
    <?php if (count($offline_history) > 5): ?>
      <div class="text-end p-2 bg-dark" style="border-top:1px solid rgba(255,255,255,.08);">
        <button type="button" class="btn btn-sm btn-outline-light btn-show-more" data-target="offline-row" data-increment="5">Ver mais</button>
      </div>
    <?php endif; ?>
  </div>
</div>

<div class="card">
  <div class="card-header">Últimos check-ins</div>
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-dark table-striped table-hover mb-0 align-middle">
        <thead>
          <tr>
            <th>Data</th>
            <th>FW</th>
            <th>IP</th>
            <th>RSSI</th>
            <th>SSID</th>
            <th>Uptime (ms)</th>
            <th>Status</th>
            <th>Erro</th>
          </tr>
        </thead>
        <tbody>
        <?php if (!$rows): ?>
          <tr><td colspan="8" class="text-center text-secondary py-4">Nenhum check-in ainda.</td></tr>
        <?php else: foreach ($rows as $idx => $r): ?>
          <tr class="checkin-row" style="<?php echo $idx < 5 ? '' : 'display:none;'; ?>">
            <td><?php echo h($r['created_at']); ?></td>
            <td><?php echo h($r['fw_version'] ?? '-'); ?></td>
            <td><?php echo h($r['ip_local'] ?? '-'); ?></td>
            <td><?php echo h($r['rssi'] ?? '-'); ?></td>
            <td><?php echo h($r['wifi_ssid'] ?? '-'); ?></td>
            <td><?php echo h($r['uptime_ms'] ?? '-'); ?></td>
            <td><?php echo h($r['status'] ?? '-'); ?></td>
            <td><?php echo h($r['last_error'] ?? '-'); ?></td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
    <?php if (count($rows) > 5): ?>
      <div class="text-end p-2 bg-dark" style="border-top:1px solid rgba(255,255,255,.08);">
        <button type="button" class="btn btn-sm btn-outline-light btn-show-more" data-target="checkin-row" data-increment="5">Ver mais</button>
      </div>
    <?php endif; ?>
  </div>
</div>

<div class="card mt-3">
  <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2">
    <span>Monitor (últimas 200 linhas)</span>
    <div class="d-flex align-items-center flex-wrap gap-2 small">
      <button type="button" class="btn btn-outline-light btn-sm" id="log-only-errors">Somente erros</button>
      <label class="form-check-label me-2"><input type="checkbox" class="form-check-input log-filter" value="hb" checked> hb</label>
      <label class="form-check-label me-2"><input type="checkbox" class="form-check-input log-filter" value="ota" checked> ota</label>
      <label class="form-check-label me-2"><input type="checkbox" class="form-check-input log-filter" value="payload" checked> payload</label>
      <label class="form-check-label me-2"><input type="checkbox" class="form-check-input log-filter" value="chk" checked> chk</label>
      <label class="form-check-label me-2"><input type="checkbox" class="form-check-input log-filter" value="cmd" checked> cmd</label>
      <label class="form-check-label me-2"><input type="checkbox" class="form-check-input log-filter" value="wifi" checked> wifi</label>
      <label class="form-check-label me-2"><input type="checkbox" class="form-check-input log-filter" value="render" checked> render</label>
      <label class="form-check-label me-2"><input type="checkbox" class="form-check-input log-filter" value="log" checked> log</label>
    </div>
  </div>
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-dark table-striped table-hover mb-0 align-middle">
        <thead>
          <tr>
            <th>Data</th>
            <th>Nível</th>
            <th>Mensagem</th>
          </tr>
        </thead>
        <tbody id="monitor-body">
        <?php if (!$logs): ?>
          <tr><td colspan="3" class="text-center text-secondary py-4">Sem logs.</td></tr>
        <?php else: foreach ($logs as $idx => $l): ?>
          <tr class="monitor-row" style="<?php echo $idx < 25 ? '' : 'display:none;'; ?>">
            <td><?php echo h($l['created_at']); ?></td>
            <td><?php echo h($l['level']); ?></td>
            <td style="white-space:pre-wrap"><?php echo h($l['message']); ?></td>
          </tr>
        <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
      <div class="text-end p-2 bg-dark d-flex justify-content-between align-items-center" style="border-top:1px solid rgba(255,255,255,.08);">
        <div class="small text-secondary">Exibindo <span id="log-count">0</span> linhas</div>
        <div class="d-flex gap-2">
          <button type="button" class="btn btn-sm btn-outline-light" id="monitor-less">-50</button>
          <button type="button" class="btn btn-sm btn-outline-light" id="monitor-more">+50</button>
        </div>
      </div>
  </div>
</div>

<div style="padding-bottom:24px;"></div>

<script>
  document.addEventListener('DOMContentLoaded', function(){
    document.querySelectorAll('.btn-show-more').forEach(function(btn){
      btn.addEventListener('click', function(){
        var target = btn.dataset.target;
        var increment = parseInt(btn.dataset.increment, 10) || 5;
        var rows = Array.prototype.slice.call(document.querySelectorAll('.' + target));
        var shown = rows.filter(function(row){ return row.style.display !== 'none'; }).length;
        var toShow = Math.min(rows.length, shown + increment);
        for(var i=shown; i<toShow; i++){
          rows[i].style.display = '';
        }
        if(toShow >= rows.length){
          btn.style.display = 'none';
        }
      });
    });
  });
  function fmtDuration(sec){
    sec = Math.max(0, sec|0);
    var h = Math.floor(sec / 3600);
    var m = Math.floor((sec % 3600) / 60);
    var s = sec % 60;
    if(h > 0) return h + "h " + m + "m";
    if(m > 0) return m + "m " + s + "s";
    return s + "s";
  }
  function renderOffline(rows){
    var body = document.getElementById('offline-body');
    if(!body) return;
    if(!rows || rows.length === 0){
      body.innerHTML = '<tr><td colspan="3" class="text-center text-secondary py-4">Sem quedas detectadas.</td></tr>';
      return;
    }
    body.innerHTML = rows.map(function(o, idx){
      var end = o.end ? new Date(o.end * 1000).toLocaleString('pt-BR') : '<span class="text-warning">offline agora</span>';
      return '<tr class="offline-row">' +
        '<td>' + new Date(o.start * 1000).toLocaleString('pt-BR') + '</td>' +
        '<td>' + end + '</td>' +
        '<td>' + fmtDuration(o.duration) + '</td>' +
      '</tr>';
    }).join('');
    Array.prototype.slice.call(body.querySelectorAll('tr')).forEach(function(tr, idx){
      if(idx >= 5) tr.style.display = 'none';
    });
  }
  function renderEvents(rows){
    var body = document.getElementById('events-body');
    if(!body) return;
    if(!rows || rows.length === 0){
      body.innerHTML = '<tr><td colspan="3" class="text-center text-secondary py-4">Sem eventos.</td></tr>';
      return;
    }
    body.innerHTML = rows.map(function(e, idx){
      return '<tr class="event-row">' +
        '<td>' + e.created_at + '</td>' +
        '<td>' + e.type + '</td>' +
        '<td style="white-space:pre-wrap">' + e.message + '</td>' +
      '</tr>';
    }).join('');
    Array.prototype.slice.call(body.querySelectorAll('tr')).forEach(function(tr, idx){
      if(idx >= 5) tr.style.display = 'none';
    });
  }
  function renderLogs(rows){
    var body = document.getElementById('monitor-body');
    if(!body) return;
    if(!rows || rows.length === 0){
      body.innerHTML = '<tr><td colspan="3" class="text-center text-secondary py-4">Sem logs.</td></tr>';
      return;
    }
    body.innerHTML = rows.map(function(l){
      var lvl = String(l.level || '').toLowerCase();
      return '<tr>' +
        '<td>' + l.created_at + '</td>' +
        '<td class="log-level-' + lvl + '">' + l.level + '</td>' +
        '<td style="white-space:pre-wrap">' + l.message + '</td>' +
      '</tr>';
    }).join('');
  }
  function updateStatus(data){
    var badge = document.getElementById('status-badge');
    var seenLabel = document.getElementById('seen-label');
    if(badge){
      badge.classList.remove('bg-success','bg-danger','bg-warning','text-dark');
      if(data.updating){
        badge.classList.add('bg-warning','text-dark');
        badge.textContent = 'ATUALIZANDO';
      } else if(data.online){
        badge.classList.add('bg-success');
        badge.textContent = 'ONLINE';
      } else {
        badge.classList.add('bg-danger');
        badge.textContent = 'OFFLINE';
      }
    }
    if(seenLabel){
      if(data.seen){
        var diff = (data.now || Math.floor(Date.now()/1000)) - data.seen;
        var seenText = new Date(data.seen * 1000).toLocaleString('pt-BR');
        seenLabel.textContent = 'Visto: ' + seenText + ' (há ' + diff + 's)';
      } else {
        seenLabel.textContent = 'Visto: -';
      }
    }
  }
  var allLogs = <?php echo json_encode($logs_all, JSON_UNESCAPED_UNICODE); ?> || [];
  var logLimit = 25;
  function getActiveFilters(){
    var set = {};
    document.querySelectorAll('.log-filter').forEach(function(el){
      if(el.checked) set[el.value] = true;
    });
    return set;
  }
  function isErrorLike(l){
    var lvl = String(l.level || '').toLowerCase();
    var msg = String(l.message || '').toLowerCase();
    if(lvl === 'chk' && msg.indexOf('post_code=200') === -1) return true;
    if(lvl === 'ota' && (msg.indexOf('mismatch') >= 0 || msg.indexOf('fail') >= 0 || msg.indexOf('stall') >= 0)) return true;
    if(lvl === 'payload' && (msg.indexOf('error') >= 0 || msg.indexOf('json') >= 0 || msg.indexOf('failed') >= 0)) return true;
    if(lvl === 'log' && msg.indexOf('push_failed') >= 0) return true;
    if(lvl === 'wifi' && (msg.indexOf('reconnect') >= 0 || msg.indexOf('disconnect') >= 0)) return true;
    return false;
  }
  function applyLogFilters(){
    var filters = getActiveFilters();
    var filtered = allLogs.filter(function(l){
      var lvl = String(l.level || '').toLowerCase();
      return !!filters[lvl];
    });
    if(onlyErrors){
      filtered = filtered.filter(isErrorLike);
    }
    renderLogs(filtered.slice(0, logLimit));
    var cnt = document.getElementById('log-count');
    if(cnt) cnt.textContent = Math.min(filtered.length, logLimit);
  }
  document.querySelectorAll('.log-filter').forEach(function(el){
    el.addEventListener('change', function(){
      logLimit = 25;
      applyLogFilters();
    });
  });
  var moreBtn = document.getElementById('monitor-more');
  if(moreBtn){
    moreBtn.addEventListener('click', function(){
      logLimit += 50;
      applyLogFilters();
    });
  }
  var lessBtn = document.getElementById('monitor-less');
  if(lessBtn){
    lessBtn.addEventListener('click', function(){
      logLimit = Math.max(25, logLimit - 50);
      applyLogFilters();
    });
  }
  var onlyErrors = false;
  var onlyErrorsBtn = document.getElementById('log-only-errors');
  if(onlyErrorsBtn){
    onlyErrorsBtn.addEventListener('click', function(){
      onlyErrors = !onlyErrors;
      onlyErrorsBtn.classList.toggle('btn-outline-light', !onlyErrors);
      onlyErrorsBtn.classList.toggle('btn-warning', onlyErrors);
      onlyErrorsBtn.textContent = onlyErrors ? 'Somente erros: ON' : 'Somente erros';
      logLimit = 25;
      applyLogFilters();
    });
  }
  function refreshData(){
    fetch('painel_detalhe.php?panel_key=<?php echo urlencode($p['panel_key']); ?>&ajax=1')
      .then(function(r){ return r.json(); })
      .then(function(data){
        renderOffline(data.offline_history || []);
        renderEvents(data.events || []);
        allLogs = data.logs || [];
        applyLogFilters();
        updateStatus(data);
      })
      .catch(function(){});
  }
  refreshData();
  setInterval(refreshData, 10000);
  // Fallback: full page refresh every 10s to guarantee updates
  setInterval(function(){
    window.location.reload();
  }, 10000);
</script>

<?php require_once __DIR__ . '/footer.php'; ?>


