<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master','admin_cliente']);

$client_id = is_admin_master() ? intval($_GET['client_id'] ?? 0) : intval($user['client_id']);

if (is_admin_master() && $client_id<=0) {
  $clients = $mysqli->query("SELECT id,name FROM clients ORDER BY name")->fetch_all(MYSQLI_ASSOC);
} else { $clients = []; }

$rows = [];
if ($client_id>0) {
  $st = $mysqli->prepare("SELECT id, name, title, updated_at FROM offers WHERE client_id=? ORDER BY updated_at DESC, id DESC");
  $st->bind_param('i',$client_id); $st->execute();
  $r = $st->get_result();
  while($row=$r->fetch_assoc()) $rows[]=$row;
  $st->close();
}

// Mapa de vínculos (por oferta -> lista de painéis + agendamento)
$links = [];
if ($rows) {
  $ids = array_map(fn($r)=>intval($r['id']), $rows);
  $in = implode(',', $ids);
  $sql = "SELECT pl.item_id AS offer_id, p.panel_key, p.name AS panel_name, s.name AS store_name,
                 pl.enabled, pl.starts_at, pl.ends_at
          FROM panel_playlist pl
          JOIN panels p ON p.id = pl.panel_id
          JOIN stores s ON s.id = p.store_id
          WHERE pl.item_type='offer' AND pl.item_id IN ($in)
          ORDER BY p.name";
  $res = $mysqli->query($sql);
  if ($res) {
    while($r=$res->fetch_assoc()) {
      $oid = intval($r['offer_id']);
      if (!isset($links[$oid])) $links[$oid]=[];
      $links[$oid][] = $r;
    }
  }
}
?>
<h3>Conteúdos</h3>
<ul class="nav nav-tabs mb-3">
  <li class="nav-item"><a class="nav-link active" href="offers_list.php<?= is_admin_master() ? '?client_id='.(int)$client_id : '' ?>">Ofertas</a></li>
  <li class="nav-item"><a class="nav-link" href="messages_list.php<?= is_admin_master() ? '?client_id='.(int)$client_id : '' ?>">Mensagens</a></li>
</ul>

<div class="d-flex justify-content-between align-items-center mb-3">
  <div class="d-flex gap-2 align-items-center">
    <?php if (is_admin_master()): ?>
      <form method="get" class="d-flex gap-2">
        <select name="client_id" class="form-select" style="max-width:280px">
          <option value="0">Selecione um cliente</option>
          <?php foreach($clients as $c): ?>
            <option value="<?= (int)$c['id'] ?>" <?= ((int)$c['id']===$client_id?'selected':'') ?>><?= htmlspecialchars($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
        <button class="btn btn-outline-secondary">Filtrar</button>
      </form>
    <?php else: ?>
      <span class="text-muted">Cliente: #<?= (int)$client_id ?></span>
    <?php endif; ?>
  </div>
  <div class="d-flex gap-2">
    <?php if ($client_id>0): ?>
      <a class="btn btn-outline-secondary" href="import_offers.php?client_id=<?= intval($client_id) ?>">Importar CSV</a>
      <a class="btn btn-primary" href="offer_edit.php?id=0">+ Nova Oferta</a>
      <a class="btn btn-outline-primary ms-2" href="import_offers.php?client_id=<?= $client_id ?>">Importar CSV</a>
    <?php endif; ?>
  </div>
</div>

<?php if ($client_id<=0): ?>
  <div class="alert alert-info">Selecione um cliente.</div>
<?php elseif (!$rows): ?>
  <div class="alert alert-warning">Nenhuma oferta cadastrada.</div>
<?php else: ?>
  <div class="table-responsive">
    <table class="table align-middle">
      <thead>
        <tr>
          <th style="width:120px">Preview</th>
          <th>Oferta</th>
          <th style="width:320px">Painéis + status</th>
          <th style="width:220px">Agendamento</th>
          <th style="width:160px">Ações</th>
        </tr>
      </thead>
      <tbody>
      <?php
        $now = new DateTime('now', new DateTimeZone('America/Sao_Paulo'));
      ?>
      <?php foreach($rows as $o):
        $oid = intval($o['id']);
        $lks = $links[$oid] ?? [];
      ?>
        <tr>
          <td>
            <div class="ratio" style="--bs-aspect-ratio:100%;max-width:110px">
              <iframe src="panel_preview.php?mode=thumb&offer_id=<?= $oid ?>" style="border:0;width:100%;height:100%;"></iframe>
            </div>
          </td>
          <td>
            <div class="fw-semibold"><?= htmlspecialchars($o['name']) ?></div>
            <div class="text-muted small"><?= htmlspecialchars($o['title']) ?></div>
            <div class="text-muted small">Atualizado: <?= htmlspecialchars($o['updated_at']) ?></div>
          </td>
          <td>
            <?php if (!$lks): ?>
              <span class="badge bg-secondary">Não vinculado</span>
            <?php else:
              $shown = 0;
              foreach($lks as $lk) {
                if ($shown>=3) break;
                $enabled = intval($lk['enabled'])===1;
                $st = 'Inativo';
                $cls = 'bg-secondary';
                $sa = $lk['starts_at'] ? new DateTime($lk['starts_at']) : null;
                $ea = $lk['ends_at'] ? new DateTime($lk['ends_at']) : null;
                if ($enabled) {
                  if ($sa && $sa > $now) { $st='Programado'; $cls='bg-warning text-dark'; }
                  else if ($ea && $ea < $now) { $st='Expirado'; $cls='bg-danger'; }
                  else { $st='Ativo'; $cls='bg-success'; }
                }
            ?>
                <div class="small mb-1">
                  <span class="badge <?= $cls ?>"><?= $st ?></span>
                  <span class="text-muted"><?= htmlspecialchars($lk['store_name']) ?> • <?= htmlspecialchars($lk['panel_name']) ?></span>
                  <span class="text-muted">(<?= htmlspecialchars($lk['panel_key']) ?>)</span>
                </div>
            <?php $shown++; } ?>
              <?php if (count($lks)>3): ?>
                <div class="text-muted small">+<?= count($lks)-3 ?> painéis…</div>
              <?php endif; ?>
            <?php endif; ?>
          </td>
          <td>
            <?php if (!$lks): ?>
              <span class="text-muted small">—</span>
            <?php else:
              // Mostra o primeiro agendamento (cada painel pode ter o seu; aqui é um resumo)
              $first = $lks[0];
            ?>
              <div class="small"><span class="text-muted">Início:</span> <?= htmlspecialchars($first['starts_at'] ?: '—') ?></div>
              <div class="small"><span class="text-muted">Fim:</span> <?= htmlspecialchars($first['ends_at'] ?: '—') ?></div>
              <div class="text-muted small">(agendamento é por painel, ajuste em “Envio em Massa”)</div>
            <?php endif; ?>
          </td>
          <td>
            <div class="d-flex gap-2">
              <a class="btn btn-sm btn-outline-primary" href="offer_edit.php?id=<?= $oid ?>">Editar</a>
              <a class="btn btn-sm btn-outline-secondary" href="mass_send.php?client_id=<?= $client_id ?>&preselect_type=offer&preselect_id=<?= $oid ?>">Agendar</a>
              <form method="post" action="offer_delete.php" class="d-inline" onsubmit="return confirm('Excluir oferta?');">
                <input type="hidden" name="id" value="<?= $oid ?>">
                <button type="submit" class="btn btn-sm btn-outline-danger">Excluir</button>
              </form>
            </div>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
<?php endif; ?>
<?php require 'footer.php'; ?>
