<?php
// admin/offer_edit.php
// Editor: máscara fixa e controles "Linhas" editáveis (limitados ao máximo da máscara).
// As linhas representam LED rows; o renderizador ajusta a fonte para caber nessas linhas.
// Esta é a versão anterior ao último ajuste (controles de fonte habilitados por padrão).
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$id = intval($_GET['id'] ?? 0);
$offer = [
  'id'=>0,
  'client_id'=>$user['client_id'],
  'name'=>'',
  'title'=>'',
  'subtitle'=>'',
  'subtitle_position'=>'', // default set below
  'price_cents'=>0,
  'unit'=>'',
  'footer'=>'',
  'duration_sec'=>5,
  'enabled'=>1,
  'opt_half_screen'=>0
];

if ($id > 0) {
    $stmt = $mysqli->prepare("SELECT * FROM offers WHERE id=?");
    $stmt->bind_param('i',$id);
    $stmt->execute();
    $tmp = $stmt->get_result()->fetch_assoc();
    if ($tmp) $offer = $tmp;
}

// default server-side: descrição em cima (above) when empty
if (!isset($offer['subtitle_position']) || !$offer['subtitle_position']) {
    $offer['subtitle_position'] = 'above';
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $client_id = is_admin_master() ? intval($_POST['client_id'] ?? $user['client_id']) : $user['client_id'];
    $name = $_POST['name'] ?? '';
    $title = $_POST['title'] ?? '';
    $subtitle = $_POST['subtitle'] ?? '';
    $subtitle_position = 'above';
    $price = floatval(str_replace(',', '.', $_POST['price'] ?? '0'));
    $price_cents = intval(round($price * 100));
    $unit = $_POST['unit'] ?? '';
    $footer = $_POST['footer'] ?? '';
    $duration_sec = intval($_POST['duration_sec'] ?? 5);
    $enabled = isset($_POST['enabled']) ? 1 : 0;
    $opt_half_screen = isset($_POST['opt_half_screen']) ? 1 : 0;

    $header = '';
    $aux = '';

    if ($id > 0) {
        $stmt = $mysqli->prepare("UPDATE offers SET client_id=?, name=?, header=?, title=?, subtitle=?, subtitle_position=?, price_cents=?, unit=?, aux=?, footer=?, duration_sec=?, enabled=?, opt_half_screen=? WHERE id=?");
        $stmt->bind_param('isssssisssiiii', $client_id,$name,$header,$title,$subtitle,$subtitle_position,$price_cents,$unit,$aux,$footer,$duration_sec,$enabled,$opt_half_screen,$id);
    } else {
        $stmt = $mysqli->prepare("INSERT INTO offers (client_id,name,header,title,subtitle,subtitle_position,price_cents,unit,aux,footer,duration_sec,enabled,opt_half_screen) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isssssisssiii', $client_id,$name,$header,$title,$subtitle,$subtitle_position,$price_cents,$unit,$aux,$footer,$duration_sec,$enabled,$opt_half_screen);
    }
    if ($stmt->execute()) {
        header('Location: offers_list.php');
        exit;
    } else {
        echo '<div class="alert alert-danger">Erro ao salvar.</div>';
    }
}

// clients
$clients = [];
if (is_admin_master()) {
    $res = $mysqli->query("SELECT id,name FROM clients ORDER BY name");
    while($c=$res->fetch_assoc()) $clients[] = $c;
}

?>
<?php
$global = $mysqli->query("SELECT * FROM global_settings WHERE id=1")->fetch_assoc();
$preview_cfg = [
  'transition_effect' => $global['transition_effect'] ?? 'fade',
  'duration_sec'      => (int)($global['duration_sec'] ?? 8),
  'transition_sec'    => (int)($global['transition_sec'] ?? 2),
  'border_animated'   => (int)($global['border_animated'] ?? 1),
  'border_speed'      => (int)($global['border_speed'] ?? 5),
  'price_blink'       => (int)($global['price_blink'] ?? 1),
];
?>
<style>
.page-wrap { display:flex; gap:20px; align-items:flex-start; }
.form-wrap { flex:1; max-width:820px; }
.preview-float { position: sticky; top: 80px; width: 440px; max-width: 100%; z-index: 2; }
@media (max-width:1000px){ .preview-float { position: static; width:100%; margin-top:18px; } .page-wrap { flex-direction:column; } }
.preview-box { background:#fff; padding:8px; border-radius:6px; box-shadow:0 6px 18px rgba(0,0,0,.06); }
.preview-canvas { width:100%; height:auto; display:block; background:#000; border-radius:6px; }
.small-note { font-size:12px; color:#666; margin-top:6px; }
</style>

<div class="page-wrap">
  <div class="form-wrap">
    <div class="d-flex align-items-center justify-content-between mb-2">
      <h3 class="mb-0"><?= $id>0 ? 'Editar' : 'Nova' ?> Oferta</h3>
      <?php if ($id>0): ?>
        <form method="post" action="offer_delete.php" onsubmit="return confirm('Excluir oferta?');">
          <input type="hidden" name="id" value="<?= (int)$id ?>">
          <button type="submit" class="btn btn-outline-danger btn-sm">Excluir</button>
        </form>
      <?php endif; ?>
    </div>
    <div style="margin:10px 0;padding:10px;border:1px solid #ddd;background:#fafafa;border-radius:8px;font-size:14px">
      <b>Dica:</b> ofertas s?o uma <b>biblioteca do cliente</b>. A programa??o ? <b>por painel</b> (playlist). Depois de salvar, v? em <b>Pain?is ? Conte?do/Playlist</b> ou use <b>Enviar em Massa</b> para escolher exatamente quais pain?is recebem esta oferta.
    </div>

    <form method="post" style="max-width:100%;">
      <?php if (is_admin_master()): ?>
      <div class="mb-3">
        <label class="form-label">Cliente</label>
        <select name="client_id" class="form-select">
          <?php foreach($clients as $c): ?>
            <option value="<?= $c['id'] ?>" <?= $c['id']==$offer['client_id']?'selected':'' ?>><?= htmlspecialchars($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <?php endif; ?>

      <div class="mb-3">
        <label class="form-label">Nome da oferta (interno)</label>
        <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($offer['name']) ?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Subt?tulo (linha superior)</label>
        <textarea name="subtitle" class="form-control" id="subtitle_input" rows="2" placeholder="Ex: OFERTA DA SEMANA"><?= htmlspecialchars($offer['subtitle']) ?></textarea>
      </div>

      <div class="mb-3">
        <label class="form-label">T?tulo (principal)</label>
        <input type="text" name="title" id="field_title" class="form-control" value="<?= htmlspecialchars($offer['title']) ?>" placeholder="Ex: ARROZ TIPO 1">
      </div>

      <div class="row mb-3">
        <div class="col">
          <label class="form-label">Valor (ex: 3,39)</label>
          <input type="text" name="price" id="field_price" class="form-control" value="<?= number_format($offer['price_cents']/100, 2, ',', '') ?>">
        </div>
        <div class="col">
          <label class="form-label">Unidade (KG, UN, etc.)</label>
          <input type="text" name="unit" id="field_unit" class="form-control" value="<?= htmlspecialchars($offer['unit']) ?>">
        </div>
      </div>

      <div class="mb-3">
        <label class="form-label">Rodap? (linha inferior)</label>
        <input type="text" name="footer" id="field_footer" class="form-control" value="<?= htmlspecialchars($offer['footer']) ?>" placeholder="Ex: OFERTA V?LIDA AT? 31/01">
      </div>

      <div class="mb-3">
        <label class="form-label">Tempo em tela (segundos)</label>
        <input type="number" name="duration_sec" class="form-control" value="<?= (int)$offer['duration_sec'] ?>">
      </div>

      <div class="form-check mb-3">
        <input class="form-check-input" type="checkbox" name="enabled" id="enabled" <?= $offer['enabled']?'checked':'' ?>>
        <label class="form-check-label" for="enabled">Oferta ativa</label>
      </div>

      <button class="btn btn-primary" type="submit">Salvar</button>
      <a href="offers_list.php" class="btn btn-secondary">Voltar</a>
    </form>
  </div>

  <div class="preview-float">
    <div class="preview-box">
      <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:8px;">
        <strong>Preview ao vivo</strong>
      </div>
      <canvas id="previewCanvas" width="600" height="600" class="preview-canvas"></canvas>
      <div class="small-note">Preview baseado no painel real (configura??es globais).</div>
    </div>
  </div>
</div>

<script src="assets/flb_fonts.js?v=<?= file_exists(__DIR__.'/assets/flb_fonts.js') ? filemtime(__DIR__.'/assets/flb_fonts.js') : time() ?>"></script>
<script src="assets/led_sim.js?v=<?= file_exists(__DIR__.'/assets/led_sim.js') ? filemtime(__DIR__.'/assets/led_sim.js') : time() ?>"></script>
<script>
(function(){
  if(!window.LED_SIM) return;
  const canvas = document.getElementById('previewCanvas');
  const m = LED_SIM.makeMatrix();
  const cfg = <?= json_encode($preview_cfg, JSON_UNESCAPED_UNICODE) ?>;

  function parsePriceToCents(v){
    v = String(v||'').replace(/[^\d,\.]/g,'').replace('.', '').replace(',', '.');
    const f = parseFloat(v || '0');
    return Math.round(f * 100);
  }

  function buildOffer(){
    const get = (id) => document.getElementById(id);
    return {
      subtitle: get('subtitle_input')?.value || '',
      title: get('field_title')?.value || '',
      price_cents: parsePriceToCents(get('field_price')?.value || ''),
      unit: get('field_unit')?.value || '',
      description: get('field_footer')?.value || ''
    };
  }

  let t0 = performance.now();
  function loop(){
    requestAnimationFrame(loop);
    LED_SIM.clear(m);
    const t = (performance.now() - t0) / 1000;
    const offer = buildOffer();
    LED_SIM.renderOffer(m, offer, cfg, t);
    if(cfg.border_animated){
      LED_SIM.drawBorder(m, t, cfg.border_speed || 5);
    }
    LED_SIM.drawToCanvas(m, canvas);
  }
  loop();
})();
</script>

<?php require 'footer.php'; ?>
