<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master','admin_cliente']);

$client_id = is_admin_master() ? intval($_GET['client_id'] ?? 0) : intval($user['client_id']);

if (is_admin_master() && $client_id<=0) {
  $clients = $mysqli->query("SELECT id,name FROM clients ORDER BY name")->fetch_all(MYSQLI_ASSOC);
} else { $clients = []; }

$rows = [];
if ($client_id>0) {
  $st = $mysqli->prepare("SELECT id, name, updated_at FROM messages WHERE client_id=? ORDER BY updated_at DESC, id DESC");
  $st->bind_param('i',$client_id); $st->execute();
  $r = $st->get_result();
  while($row=$r->fetch_assoc()) $rows[]=$row;
  $st->close();
}

// Mapa de vínculos (mensagem -> painéis)
$links = [];
if ($rows) {
  $ids = array_map(fn($r)=>intval($r['id']), $rows);
  $in = implode(',', $ids);
  $sql = "SELECT pl.item_id AS message_id, p.panel_key, p.name AS panel_name, s.name AS store_name,
                 pl.enabled, pl.starts_at, pl.ends_at
          FROM panel_playlist pl
          JOIN panels p ON p.id=pl.panel_id
          LEFT JOIN stores s ON s.id=p.store_id
          WHERE pl.item_type='message' AND pl.item_id IN ($in)
          ORDER BY p.name";
  $res = $mysqli->query($sql);
  while($r = $res->fetch_assoc()) {
    $mid = intval($r['message_id']);
    if (!isset($links[$mid])) $links[$mid] = [];
    $links[$mid][] = $r;
  }
}
?>
<h3>Conteúdos</h3>
<ul class="nav nav-tabs mb-3">
  <li class="nav-item"><a class="nav-link" href="offers_list.php<?= is_admin_master() ? '?client_id='.(int)$client_id : '' ?>">Ofertas</a></li>
  <li class="nav-item"><a class="nav-link active" href="messages_list.php<?= is_admin_master() ? '?client_id='.(int)$client_id : '' ?>">Mensagens</a></li>
</ul>

<div class="d-flex justify-content-between align-items-center mb-3">
  <div class="d-flex gap-2 align-items-center">
    <?php if (is_admin_master()): ?>
      <form method="get" class="d-flex gap-2">
        <select name="client_id" class="form-select" style="max-width:280px">
          <option value="0">Selecione um cliente</option>
          <?php foreach($clients as $c): ?>
            <option value="<?= (int)$c['id'] ?>" <?= ((int)$c['id']===$client_id?'selected':'') ?>><?= htmlspecialchars($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
        <button class="btn btn-outline-secondary">Filtrar</button>
      </form>
    <?php else: ?>
      <span class="text-muted">Cliente: #<?= (int)$client_id ?></span>
    <?php endif; ?>
  </div>
  <?php if ($client_id>0): ?><a class="btn btn-primary" href="message_edit.php?id=0">+ Nova Mensagem</a><?php endif; ?>
</div>

<?php if ($client_id<=0): ?>
  <div class="alert alert-info">Selecione um cliente.</div>
<?php elseif (!$rows): ?>
  <div class="alert alert-warning">Nenhuma mensagem cadastrada.</div>
<?php else: ?>
  <div class="table-responsive">
    <table class="table align-middle">
      <thead>
        <tr>
          <th style="width:140px;">Preview</th>
          <th>Mensagem</th>
          <th>Painéis / Status</th>
          <th style="width:210px;">Ações</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($rows as $m): $mid=(int)$m['id']; $ls=$links[$mid] ?? []; ?>
          <tr>
            <td>
              <div class="border rounded" style="width:120px;height:120px;overflow:hidden;">
                <iframe src="panel_preview.php?mode=thumb&message_id=<?= $mid ?>" style="border:0;width:120px;height:120px;"></iframe>
              </div>
            </td>
            <td>
              <div class="fw-semibold"><?= htmlspecialchars($m['name']) ?></div>
              <div class="text-muted small">Atualizado: <?= htmlspecialchars($m['updated_at']) ?></div>
            </td>
            <td>
              <?php if(!$ls): ?>
                <span class="badge text-bg-secondary">Sem painel</span>
              <?php else: ?>
                <?php foreach($ls as $i=>$ln): if($i>=6) break; ?>
                  <div class="mb-1">
                    <span class="badge text-bg-light border"><?= htmlspecialchars($ln['panel_key']) ?></span>
                    <span class="text-muted small"><?= htmlspecialchars($ln['panel_name']) ?> · <?= htmlspecialchars($ln['store_name']) ?></span>
                    <span class="badge text-bg-<?= $ln['status']=='Ativo'?'success':($ln['status']=='Programado'?'warning':($ln['status']=='Inativo'?'secondary':'dark')) ?>"><?= htmlspecialchars($ln['status']) ?></span>
                    <?php if($ln['starts_at'] || $ln['ends_at']): ?>
                      <span class="text-muted small">(<?= htmlspecialchars($ln['starts_at'] ?: '---') ?> → <?= htmlspecialchars($ln['ends_at'] ?: '---') ?>)</span>
                    <?php endif; ?>
                  </div>
                <?php endforeach; ?>
                <?php if(count($ls)>6): ?>
                  <div class="text-muted small">+<?= count($ls)-6 ?> painel(is)</div>
                <?php endif; ?>
              <?php endif; ?>
            </td>
            <td>
              <a class="btn btn-sm btn-outline-primary" href="message_edit.php?id=<?= $mid ?>">Editar</a>
              <a class="btn btn-sm btn-outline-secondary" href="mass_send.php?client_id=<?= $client_id ?>&preselect_type=message&preselect_id=<?= $mid ?>">Agendar/Enviar</a>
              <form method="post" action="message_delete.php" class="d-inline" onsubmit="return confirm('Excluir mensagem?');">
                <input type="hidden" name="id" value="<?= $mid ?>">
                <button type="submit" class="btn btn-sm btn-outline-danger">Excluir</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
<?php endif; ?>
<?php require 'footer.php'; ?>
