<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

$id = intval($_GET['id'] ?? 0);

$message = [
  'id' => 0,
  'client_id' => $user['client_id'],
  'name' => '',
  'enabled' => 1,
  'use_global' => 1,
  'transition_effect' => 'fade',
  'duration_sec' => 8,
  'border_animated' => 1,
  'border_speed' => 5,
  'lines_json' => '[]'
];

if ($id > 0) {
  // segurança: limita pelo client_id do usuário (exceto admin master)
  if (is_admin_master()) {
    $stmt = $mysqli->prepare("SELECT * FROM messages WHERE id=?");
    $stmt->bind_param('i',$id);
  } else {
    $stmt = $mysqli->prepare("SELECT * FROM messages WHERE id=? AND client_id=?");
    $stmt->bind_param('ii',$id,$user['client_id']);
  }
  $stmt->execute();
  $res = $stmt->get_result();
  if ($row = $res->fetch_assoc()) {
    $message = $row;
  } else {
    echo "Mensagem não encontrada.";
    require 'footer.php';
    exit;
  }
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $client_id = is_admin_master() ? intval($_POST['client_id'] ?? $user['client_id']) : $user['client_id'];
  $name = $_POST['name'] ?? '';
  $enabled = isset($_POST['enabled']) ? 1 : 0;
  $use_global = isset($_POST['use_global']) ? 1 : 0;

  $transition_effect = $_POST['transition_effect'] ?? 'fade';
  $duration_sec = max(5, min(15, intval($_POST['duration_sec'] ?? 8)));
  $border_animated = isset($_POST['border_animated']) ? 1 : 0;
  $border_speed = max(1, min(10, intval($_POST['border_speed'] ?? 5)));

  // linhas
  $texts = $_POST['line_text'] ?? [];
  $sizes = $_POST['line_size'] ?? [];
  $aligns = $_POST['line_align'] ?? [];
  $ys = $_POST['line_y'] ?? [];
  $offsets = $_POST['line_offset'] ?? [];
  $scrolls = $_POST['line_scroll'] ?? [];
  $scroll_speeds = $_POST['line_scroll_speed'] ?? [];

  $allowed_sizes = [7, 17, 28, 42];
  $legacy_sizes = [8 => 7, 16 => 17, 24 => 28];

  $lines = [];
  $count = count($texts);
  for ($i=0;$i<$count;$i++) {
    $t = trim($texts[$i]);
    if ($t === '') continue;
    $size = (function($v, $allowed, $legacy){
      $v = intval($v);
      if (isset($legacy[$v])) $v = $legacy[$v];
      return in_array($v, $allowed, true) ? $v : 17;
    })($sizes[$i] ?? 17, $allowed_sizes, $legacy_sizes);
    $lines[] = [
      'text' => $t,
      'size' => $size,
      'align' => $aligns[$i] ?? 'center',
      'y' => max(0, min(95, intval($ys[$i] ?? 20))),
      'offset' => intval($offsets[$i] ?? 0),
      'scroll' => isset($scrolls[$i]) ? 1 : 0,
      'scroll_speed' => max(1, min(20, intval($scroll_speeds[$i] ?? 8)))
    ];
  }
  $lines_json = json_encode($lines, JSON_UNESCAPED_UNICODE);

  if ($id > 0) {
    $stmt = $mysqli->prepare("UPDATE messages SET client_id=?, name=?, enabled=?, use_global=?, transition_effect=?, duration_sec=?, border_animated=?, border_speed=?, lines_json=? WHERE id=?");
    $stmt->bind_param('isiiisiisi',
      $client_id, $name, $enabled, $use_global,
      $transition_effect, $duration_sec, $border_animated,
      $border_speed, $lines_json, $id
    );
  } else {
    $stmt = $mysqli->prepare("INSERT INTO messages (client_id,name,enabled,use_global,transition_effect,duration_sec,border_animated,border_speed,lines_json) VALUES (?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiisiis',
      $client_id, $name, $enabled, $use_global,
      $transition_effect, $duration_sec, $border_animated,
      $border_speed, $lines_json
    );
  }
  if ($stmt->execute()) {
    echo '<div class="alert alert-success">Mensagem salva.</div>';
    if ($id == 0) {
      $id = $mysqli->insert_id;
    }
    // recarrega dados
    $message['client_id'] = $client_id;
    $message['name'] = $name;
    $message['enabled'] = $enabled;
    $message['use_global'] = $use_global;
    $message['transition_effect'] = $transition_effect;
    $message['duration_sec'] = $duration_sec;
    $message['border_animated'] = $border_animated;
    $message['border_speed'] = $border_speed;
    $message['lines_json'] = $lines_json;
  } else {
    echo '<div class="alert alert-danger">Erro ao salvar.</div>';
  }
}

$lines = json_decode($message['lines_json'], true) ?: [];
$legacy_sizes = [8 => 7, 16 => 17, 24 => 28];
$allowed_sizes = [7, 17, 28, 42];
foreach ($lines as &$ln) {
  $sz = intval($ln['size'] ?? 17);
  if (isset($legacy_sizes[$sz])) $sz = $legacy_sizes[$sz];
  if (!in_array($sz, $allowed_sizes, true)) $sz = 17;
  $ln['size'] = $sz;
}
unset($ln);
if (empty($lines)) {
  $lines = [[
    'text' => 'NOVA MENSAGEM',
    'size' => 17,
    'align' => 'center',
    'y' => 32,
    'offset' => 0,
    'scroll' => 0,
    'scroll_speed' => 8
  ]];
}

$global = $mysqli->query("SELECT * FROM global_settings WHERE id=1")->fetch_assoc();
$global_cfg = [
  'transition_effect' => $global['transition_effect'] ?? 'fade',
  'duration_sec'      => (int)($global['duration_sec'] ?? 8),
  'transition_sec'    => (int)($global['transition_sec'] ?? 2),
  'border_animated'   => (int)($global['border_animated'] ?? 1),
  'border_speed'      => (int)($global['border_speed'] ?? 5),
];

$effects = [
  'fade' => 'Fade',
  'slide_right' => 'Entrada direita',
  'slide_left' => 'Entrada esquerda',
  'slide_top' => 'Entrada cima',
  'slide_bottom' => 'Entrada baixo',
  'zoom' => 'Zoom',
  'dissolve' => 'Dissolve',
];
?>
<div class="d-flex align-items-center justify-content-between mb-2">
  <h3 class="mb-0"><?= $id ? 'Editar Mensagem' : 'Nova Mensagem' ?></h3>
  <?php if ($id): ?>
    <form method="post" action="message_delete.php" onsubmit="return confirm('Excluir mensagem?');">
      <input type="hidden" name="id" value="<?= (int)$id ?>">
      <button type="submit" class="btn btn-outline-danger btn-sm">Excluir</button>
    </form>
  <?php endif; ?>
</div>

<div style="margin:10px 0;padding:10px;border:1px solid #ddd;background:#fafafa;border-radius:8px;font-size:14px">
  <b>Dica:</b> mensagens são uma <b>biblioteca do cliente</b>. A programação é <b>por painel</b> (playlist). Depois de salvar, vá em <b>Painéis → Conteúdo/Playlist</b> ou use <b>Enviar em Massa</b> para escolher exatamente quais painéis recebem esta mensagem.
</div>
<div class="row">
  <div class="col-md-5">
    <form method="post">
      <?php if (is_admin_master()): ?>
      <div class="mb-2">
        <label class="form-label">Cliente</label>
        <select name="client_id" class="form-select form-select-sm">
          <?php
          $cres = $mysqli->query("SELECT id,name FROM clients ORDER BY name");
          while($c = $cres->fetch_assoc()):
          ?>
            <option value="<?= $c['id'] ?>" <?= $c['id']==$message['client_id']?'selected':'' ?>>
              <?= htmlspecialchars($c['name']) ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>
      <?php endif; ?>

      <div class="mb-2">
        <label class="form-label">Nome interno</label>
        <input type="text" name="name" class="form-control form-control-sm" value="<?= htmlspecialchars($message['name']) ?>" required>
      </div>
      <div class="form-check mb-2">
        <input class="form-check-input" type="checkbox" name="enabled" id="enabled" <?= $message['enabled'] ? 'checked' : '' ?>>
        <label class="form-check-label" for="enabled">Mensagem ativa</label>
      </div>

      <hr>
      <h6>Configuração</h6>
      <div class="form-check mb-2">
        <input class="form-check-input" type="checkbox" name="use_global" id="use_global" <?= $message['use_global'] ? 'checked' : '' ?>>
        <label class="form-check-label" for="use_global">Usar config global do painel</label>
      </div>

      <div id="overrideArea" style="<?= $message['use_global'] ? 'display:none;' : '' ?>">
        <div class="mb-2">
          <label class="form-label">Efeito de transição</label>
          <select name="transition_effect" class="form-select form-select-sm">
            <?php foreach ($effects as $k=>$label): ?>
              <option value="<?= $k ?>" <?= $message['transition_effect']===$k?'selected':'' ?>><?= $label ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="mb-2">
          <label class="form-label">Tempo na tela (5-15s)</label>
          <input type="number" class="form-control form-control-sm" name="duration_sec" min="5" max="15" value="<?= (int)$message['duration_sec'] ?>">
        </div>
        <div class="form-check mb-2">
          <input class="form-check-input" type="checkbox" name="border_animated" id="border_animated" <?= $message['border_animated'] ? 'checked' : '' ?>>
          <label class="form-check-label" for="border_animated">Borda animada</label>
        </div>
        <div class="mb-2">
          <label class="form-label">Velocidade da borda (1-10)</label>
          <input type="number" class="form-control form-control-sm" name="border_speed" min="1" max="10" value="<?= (int)$message['border_speed'] ?>">
        </div>
      </div>

      <hr>
      <h6>Linhas da mensagem</h6>
      <div id="linesContainer">
        <?php foreach ($lines as $line): ?>
        <div class="border rounded p-2 mb-2 line-block">
          <div class="mb-1">
            <label class="form-label">Texto</label>
            <input type="text" name="line_text[]" class="form-control form-control-sm" value="<?= htmlspecialchars($line['text']) ?>">
          </div>
          <div class="row g-1">
            <div class="col-4">
              <label class="form-label">Tamanho</label>
              <select name="line_size[]" class="form-select form-select-sm">
                <option value="7" <?= ((int)$line['size']===7)?'selected':'' ?>>7</option>
                <option value="17" <?= ((int)$line['size']===17)?'selected':'' ?>>17</option>
                <option value="28" <?= ((int)$line['size']===28)?'selected':'' ?>>28</option>
                <option value="42" <?= ((int)$line['size']===42)?'selected':'' ?>>42</option>
              </select>
            </div>
            <div class="col-4">
              <label class="form-label">Posição Y (0-95)</label>
              <input type="number" name="line_y[]" class="form-control form-control-sm" min="0" max="95" value="<?= (int)$line['y'] ?>">
            </div>
            <div class="col-4">
              <label class="form-label">Offset X (-96 a 96)</label>
              <input type="number" name="line_offset[]" class="form-control form-control-sm" min="-96" max="96" value="<?= (int)$line['offset'] ?>">
            </div>
          </div>
          <div class="row g-1 mt-1">
            <div class="col-6">
              <label class="form-label">Alinhamento</label>
              <select name="line_align[]" class="form-select form-select-sm">
                <option value="left" <?= $line['align']==='left'?'selected':'' ?>>Esquerda</option>
                <option value="center" <?= $line['align']==='center'?'selected':'' ?>>Centro</option>
                <option value="right" <?= $line['align']==='right'?'selected':'' ?>>Direita</option>
              </select>
            </div>
            <div class="col-6">
              <label class="form-label">Scroll</label>
              <div class="form-check">
                <input class="form-check-input" type="checkbox" name="line_scroll[]" value="1" <?= $line['scroll'] ? 'checked' : '' ?>>
                <span class="form-check-label">Ativar scroll</span>
              </div>
              <input type="number" name="line_scroll_speed[]" class="form-control form-control-sm mt-1" min="1" max="20" value="<?= (int)$line['scroll_speed'] ?>">
            </div>
          </div>
          <button type="button" class="btn btn-outline-danger btn-sm mt-2 btn-remove-line">Remover linha</button>
        </div>
        <?php endforeach; ?>
      </div>

      <button type="button" class="btn btn-secondary btn-sm" id="addLine">+ Adicionar linha</button>

      <button type="submit" class="btn btn-primary btn-sm mt-3">Salvar</button>
    </form>
  </div>

  <div class="col-md-7">
    <h6>Preview 96x96</h6>
    <canvas id="previewCanvas" width="480" height="480" style="background:#000; border:1px solid #333; width:100%; max-width:480px; height:auto;"></canvas>
    <p class="mt-2"><small>Pré-visualização aproximada. O desenho 1:1 será definido na API / firmware.</small></p>
  </div>
</div>

<script>
const useGlobal = document.getElementById('use_global');
useGlobal.addEventListener('change', () => {
  document.getElementById('overrideArea').style.display = useGlobal.checked ? 'none' : 'block';
});

const linesContainer = document.getElementById('linesContainer');
document.getElementById('addLine').addEventListener('click', () => {
  const tpl = document.querySelector('.line-block');
  if (!tpl) return;
  const clone = tpl.cloneNode(true);
  clone.querySelectorAll('input').forEach(inp => {
    if (inp.name.startsWith('line_text')) inp.value = '';
  });
  const sizeSel = clone.querySelector('select[name^="line_size"]');
  if (sizeSel) sizeSel.value = '17';
  const yInput = clone.querySelector('input[name^="line_y"]');
  if (yInput) yInput.value = '32';
  const offInput = clone.querySelector('input[name^="line_offset"]');
  if (offInput) offInput.value = '0';
  const alignSel = clone.querySelector('select[name^="line_align"]');
  if (alignSel) alignSel.value = 'center';
  const scrollChk = clone.querySelector('input[name^="line_scroll"]');
  if (scrollChk) scrollChk.checked = false;
  const scrollSpd = clone.querySelector('input[name^="line_scroll_speed"]');
  if (scrollSpd) scrollSpd.value = '8';
  linesContainer.appendChild(clone);
  bindRemoveButtons();
});

function bindRemoveButtons() {
  document.querySelectorAll('.btn-remove-line').forEach(btn => {
    btn.onclick = () => {
      const block = btn.closest('.line-block');
      if (document.querySelectorAll('.line-block').length > 1) {
        block.remove();
      }
    };
  });
}
bindRemoveButtons();
</script>

<script src="assets/flb_fonts.js?v=<?= file_exists(__DIR__.'/assets/flb_fonts.js') ? filemtime(__DIR__.'/assets/flb_fonts.js') : time() ?>"></script>
<script src="assets/led_sim.js?v=<?= file_exists(__DIR__.'/assets/led_sim.js') ? filemtime(__DIR__.'/assets/led_sim.js') : time() ?>"></script>

<script>
// preview com renderer real do painel
const canvas = document.getElementById('previewCanvas');
const mtx = window.LED_SIM ? LED_SIM.makeMatrix() : null;
const globalCfg = <?= json_encode($global_cfg, JSON_UNESCAPED_UNICODE) ?>;

function buildCfg(){
  if (!document.getElementById('use_global') || document.getElementById('use_global').checked) {
    return Object.assign({}, globalCfg);
  }
  return {
    transition_effect: document.querySelector('[name="transition_effect"]')?.value || globalCfg.transition_effect || 'fade',
    duration_sec: parseInt(document.querySelector('[name="duration_sec"]')?.value || globalCfg.duration_sec || 8, 10),
    border_animated: document.getElementById('border_animated')?.checked ? 1 : 0,
    border_speed: parseInt(document.querySelector('[name="border_speed"]')?.value || globalCfg.border_speed || 5, 10),
  };
}

function collectLines(){
  const blocks = document.querySelectorAll('.line-block');
  const lines = [];
  const mapSize = (v) => {
    const legacy = { 8: 7, 16: 17, 24: 28 };
    const allowed = [7, 17, 28, 42];
    if (legacy[v]) return legacy[v];
    return allowed.includes(v) ? v : 17;
  };
  blocks.forEach((b)=>{
    const text = b.querySelector('input[name^="line_text"]')?.value || '';
    if (!text.trim()) return;
    const sizeRaw = parseInt(b.querySelector('select[name^="line_size"]')?.value || '17', 10);
    const size = mapSize(isNaN(sizeRaw) ? 17 : sizeRaw);
    const align = b.querySelector('select[name^="line_align"]')?.value || 'center';
    const y = parseInt(b.querySelector('input[name^="line_y"]')?.value || '32', 10);
    const offset = parseInt(b.querySelector('input[name^="line_offset"]')?.value || '0', 10);
    const scroll = b.querySelector('input[name^="line_scroll"]')?.checked ? 1 : 0;
    const scroll_speed = parseInt(b.querySelector('input[name^="line_scroll_speed"]')?.value || '8', 10);
    lines.push({ text, size, align, y, offset, scroll, scroll_speed });
  });
  return lines;
}

let t0 = performance.now();
function loop(){
  requestAnimationFrame(loop);
  if (!window.LED_SIM || !mtx) return;
  const t = (performance.now() - t0) / 1000;
  const msg = { lines: collectLines() };
  const cfg = buildCfg();
  LED_SIM.renderMessage(mtx, msg, cfg, t);
  if (cfg.border_animated) {
    LED_SIM.drawBorder(mtx, t, cfg.border_speed || 5);
  }
  LED_SIM.drawToCanvas(mtx, canvas);
}
loop();

</script>

<?php require 'footer.php'; ?>
