<?php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master','admin_cliente']);

$id = intval($_POST['id'] ?? $_GET['id'] ?? 0);
if ($id <= 0) {
  header('Location: messages_list.php');
  exit;
}

$client_id = 0;
if (is_admin_master()) {
  $st = $mysqli->prepare("SELECT client_id FROM messages WHERE id=?");
  $st->bind_param('i', $id);
} else {
  $st = $mysqli->prepare("SELECT client_id FROM messages WHERE id=? AND client_id=?");
  $st->bind_param('ii', $id, $user['client_id']);
}
$st->execute();
$st->bind_result($client_id);
if (!$st->fetch()) {
  $st->close();
  http_response_code(404);
  echo "Mensagem não encontrada.";
  exit;
}
$st->close();

// remove vínculos da playlist
$st = $mysqli->prepare("DELETE FROM panel_playlist WHERE item_type='message' AND item_id=?");
$st->bind_param('i', $id);
$st->execute();
$st->close();

// remove mensagem
$st = $mysqli->prepare("DELETE FROM messages WHERE id=? LIMIT 1");
$st->bind_param('i', $id);
$st->execute();
$st->close();

$redir = 'messages_list.php';
if (is_admin_master() && $client_id > 0) {
  $redir .= '?client_id=' . (int)$client_id;
}
header('Location: ' . $redir);
exit;
