﻿<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';

require_role(['admin_master','admin_cliente','cliente']);

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function require_client_for_master($client_id){
  if (is_admin_master() && $client_id<=0) return false;
  return true;
}

$client_id = (int)$user['client_id'];
if (is_admin_master()) $client_id = intval($_GET['client_id'] ?? 0);

$clients = [];
if (is_admin_master()) {
  $clients = $mysqli->query("SELECT id,name FROM clients ORDER BY name")->fetch_all(MYSQLI_ASSOC);
}

$store_id = isset($_GET['store_id']) ? intval($_GET['store_id']) : 0;
if (!is_admin_master()) {
  $store_id = max(0, $store_id);
}

if ($store_id>0 && $client_id>0) {
  $st=$mysqli->prepare('SELECT id FROM stores WHERE id=? AND client_id=?');
  $st->bind_param('ii',$store_id,$client_id); $st->execute();
  $ok=$st->get_result()->fetch_assoc(); $st->close();
  if (!$ok) $store_id = 0;
}

$pre_item = '';
if (isset($_GET['type'], $_GET['id']) && preg_match('/^(offer|message)$/', $_GET['type']) && ctype_digit((string)$_GET['id'])) {
  $pre_item = $_GET['type'] . ':' . (int)$_GET['id'];
}
if (!$pre_item && isset($_GET['preselect_type'], $_GET['preselect_id']) && preg_match('/^(offer|message)$/', $_GET['preselect_type']) && ctype_digit((string)$_GET['preselect_id'])) {
  $pre_item = $_GET['preselect_type'] . ':' . (int)$_GET['preselect_id'];
}

$errMsg = null;

function parse_dt_local($s) {
  $s = trim((string)$s);
  if ($s==='') return null;
  // HTML datetime-local: 2026-01-18T12:30
  $s = str_replace('T',' ',$s);
  $dt = DateTime::createFromFormat('Y-m-d H:i', $s);
  if (!$dt) {
    $dt = DateTime::createFromFormat('Y-m-d H:i:s', $s);
  }
  if (!$dt) return false;
  return $dt->format('Y-m-d H:i:s');
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $action = $_POST['action'] ?? 'add_schedule';

  if (!require_client_for_master($client_id)) {
    $errMsg = 'Selecione um cliente para programar.';
  } else {
    $selected_items = $_POST['items'] ?? [];
    $selected_panels = $_POST['panels'] ?? [];
    $mode = $_POST['mode'] ?? 'append';

    $enabled = isset($_POST['enabled']) ? 1 : 0;
    $starts_at = parse_dt_local($_POST['starts_at'] ?? '');
    $ends_at   = parse_dt_local($_POST['ends_at'] ?? '');

    if ($starts_at===false || $ends_at===false) {
      $errMsg = 'Data/hora inválida no agendamento.';
    } else {
      if (!is_array($selected_items)) $selected_items = [];
      if (!is_array($selected_panels)) $selected_panels = [];

      // Validar itens pelo cliente
      $valid_items = [];
      foreach ($selected_items as $token) {
        if (!preg_match('/^(offer|message):(\d+)$/',$token,$m)) continue;
        $type=$m[1];
        $id=(int)$m[2];
        if ($type==='offer') {
          $st=$mysqli->prepare('SELECT id FROM offers WHERE id=? AND client_id=?');
        } else {
          $st=$mysqli->prepare('SELECT id FROM messages WHERE id=? AND client_id=?');
        }
        $st->bind_param('ii',$id,$client_id); $st->execute();
        $ok=$st->get_result()->fetch_assoc(); $st->close();
        if ($ok) $valid_items[] = $type.':'.$id;
      }
      $selected_items = $valid_items;

      // Validar painéis pelo cliente/loja
      $valid_panels = [];
      foreach ($selected_panels as $pid) {
        $pid = (int)$pid;
        if ($pid<=0) continue;
        if ($store_id>0) {
          $st=$mysqli->prepare('SELECT p.id FROM panels p JOIN stores s ON s.id=p.store_id WHERE p.id=? AND s.client_id=? AND s.id=?');
          $st->bind_param('iii',$pid,$client_id,$store_id);
        } else {
          $st=$mysqli->prepare('SELECT p.id FROM panels p JOIN stores s ON s.id=p.store_id WHERE p.id=? AND s.client_id=?');
          $st->bind_param('ii',$pid,$client_id);
        }
        $st->execute();
        $ok=$st->get_result()->fetch_assoc(); $st->close();
        if ($ok) $valid_panels[] = $pid;
      }
      $selected_panels = $valid_panels;

      if (!$selected_items || !$selected_panels) {
        $errMsg = 'Selecione itens e painéis válidos do cliente.';
      } else {
        $starts_at_db = $starts_at;
        $ends_at_db   = $ends_at;

        foreach ($selected_panels as $pid) {
          $pid = intval($pid);
          if ($pid<=0) continue;

          if ($mode==='replace') {
            $mysqli->query('DELETE FROM panel_playlist WHERE panel_id='.$pid);
          }

          $res = $mysqli->query('SELECT COALESCE(MAX(position),0) AS maxpos FROM panel_playlist WHERE panel_id='.$pid);
          $pos = (int)($res && ($row=$res->fetch_assoc()) ? ($row['maxpos'] ?? 0) : 0);

          foreach ($selected_items as $token) {
            if (!preg_match('/^(offer|message):(\d+)$/',$token,$m)) continue;
            $type=$m[1];
            $id=(int)$m[2];

            $existingPos = null;
            $order_override = null;
            if (isset($_POST['item_order'][$token]) && $_POST['item_order'][$token] !== '') {
              $order_override = (int)$_POST['item_order'][$token];
            }

            if ($mode !== 'replace') {
              $chk=$mysqli->prepare('SELECT position FROM panel_playlist WHERE panel_id=? AND item_type=? AND item_id=?');
              $chk->bind_param('isi',$pid,$type,$id);
              $chk->execute();
              $existingRow = $chk->get_result()->fetch_assoc();
              $chk->close();
              if ($existingRow && isset($existingRow['position'])) {
                $existingPos = (int)$existingRow['position'];
              } else {
                $pos++;
              }
            } else {
              $pos++;
            }

            if ($order_override !== null && $order_override > 0) {
              $position_to_use = $order_override;
            } else {
              $position_to_use = ($existingPos !== null) ? $existingPos : $pos;
            }

            $st=$mysqli->prepare('INSERT INTO panel_playlist(panel_id,item_type,item_id,position,enabled,starts_at,ends_at)
                                  VALUES(?,?,?,?,?,?,?)
                                  ON DUPLICATE KEY UPDATE enabled=VALUES(enabled), starts_at=VALUES(starts_at), ends_at=VALUES(ends_at), updated_at=NOW()');
            $st->bind_param('isiiiss',$pid,$type,$id,$position_to_use,$enabled,$starts_at_db,$ends_at_db);
            $st->execute();
            $st->close();
          }
        }

        $redir = 'mass_send.php?ok=1';
        if (is_admin_master()) {
          $redir .= '&client_id='.(int)$client_id;
          if ($store_id > 0) $redir .= '&store_id='.(int)$store_id;
        }
        if ($selected_panels) {
          $redir .= '&order_panels=' . implode(',', array_map('intval', $selected_panels));
        }
        header('Location: '.$redir); exit;
      }
    }
  }
}


$stores=[];
if ($client_id>0) {
  $st=$mysqli->prepare("SELECT id,name FROM stores WHERE client_id=? ORDER BY name");
  $st->bind_param('i',$client_id); $st->execute();
  $r=$st->get_result(); while($row=$r->fetch_assoc()) $stores[]=$row; $st->close();
}

$offers=[]; $messages=[]; $panels=[]; $items=[];
if ($client_id>0) {
  $st=$mysqli->prepare("SELECT id,name,title,updated_at FROM offers WHERE client_id=? ORDER BY updated_at DESC,id DESC");
  $st->bind_param('i',$client_id); $st->execute();
  $r=$st->get_result(); while($row=$r->fetch_assoc()) { $offers[]=$row; $items[]=['type'=>'offer']+$row; } $st->close();
}

if ($client_id>0) {
  $st=$mysqli->prepare("SELECT id,name,updated_at FROM messages WHERE client_id=? ORDER BY updated_at DESC,id DESC");
  $st->bind_param('i',$client_id); $st->execute();
  $r=$st->get_result(); while($row=$r->fetch_assoc()) { $messages[]=$row; $items[]=['type'=>'message']+$row; } $st->close();
}

if ($store_id>0 && $client_id>0) {
  $st=$mysqli->prepare("SELECT p.id,p.name FROM panels p WHERE p.store_id=? ORDER BY p.name");
  $st->bind_param('i',$store_id); $st->execute();
} elseif ($client_id>0) {
  $st=$mysqli->prepare("SELECT p.id,p.name FROM panels p JOIN stores s ON s.id=p.store_id WHERE s.client_id=? ORDER BY p.name");
  $st->bind_param('i',$client_id); $st->execute();
} else {
  $st = null;
}
if ($st) {
  $r=$st->get_result(); while($row=$r->fetch_assoc()) $panels[]=$row; $st->close();
}

if ($items) {
  usort($items, function($a, $b){
    $at = isset($a['updated_at']) ? strtotime($a['updated_at']) : 0;
    $bt = isset($b['updated_at']) ? strtotime($b['updated_at']) : 0;
    if ($at === $bt) return 0;
    return ($at > $bt) ? -1 : 1;
  });
}
?>
<div class="d-flex justify-content-between align-items-center"><h3 class="mb-0">Envio em Massa / Agendamento</h3><a class="btn btn-outline-secondary" href="agenda.php">Agenda de Postagens</a></div>
<p class="text-muted">Vincule ofertas/mensagens aos painéis e defina o agendamento (entrada/saída). O agendamento é por conteúdo <strong>e</strong> por painel.</p>
<?php if (is_admin_master() && $client_id<=0): ?>
  <div class="alert alert-warning">Selecione um cliente para liberar ofertas, mensagens e painéis.</div>
<?php endif; ?>
<?php if (!empty($_GET['ok'])): ?><div class="alert alert-success">Salvo com sucesso!</div><?php endif; ?>
<?php
  $order_panels = [];
  if (!empty($_GET['order_panels'])) {
    foreach (explode(',', (string)$_GET['order_panels']) as $pid) {
      $pid = (int)$pid;
      if ($pid>0) $order_panels[] = $pid;
    }
  }
  $panel_name_map = [];
  foreach ($panels as $p) {
    $panel_name_map[(int)$p['id']] = $p['name'] ?? ('#'.$p['id']);
  }
?>
<?php if ($order_panels): ?>
  <div class="alert alert-info d-flex flex-wrap align-items-center gap-2">
    <strong>Ordenar itens?</strong>
    <?php
      $first_panel = $order_panels[0];
    $order_url = 'panel_contents.php?id='.(int)$first_panel;
    if (is_admin_master() && $client_id>0) {
      $order_url .= '&client_id='.(int)$client_id;
    }
    ?>
    <a class="btn btn-sm btn-primary" href="<?php echo h($order_url); ?>">Sim</a>
    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="this.closest('.alert').remove()">Não</button>
    <?php if (count($order_panels) > 1): ?>
      <div class="w-100 mt-2 small text-muted">Outros painéis:</div>
      <div class="d-flex flex-wrap gap-2">
        <?php foreach ($order_panels as $pid): ?>
          <?php
            $purl = 'panel_contents.php?id='.(int)$pid;
            if (is_admin_master() && $client_id>0) $purl .= '&client_id='.(int)$client_id;
          ?>
          <a class="btn btn-sm btn-outline-secondary" href="<?php echo h($purl); ?>">
            <?php echo h($panel_name_map[$pid] ?? ('#'.$pid)); ?>
          </a>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
<?php endif; ?>
<?php if ($errMsg): ?><div class="alert alert-danger"><?= h($errMsg) ?></div><?php endif; ?>

<form class="row g-3 mb-3" method="get" id="filterForm">
  <?php if (is_admin_master()): ?>
    <div class="col-md-4">
      <label class="form-label">Filtrar por Cliente</label>
      <select class="form-select" name="client_id" id="clientSelect" onchange="this.form.submit()" oninput="this.form.submit()">
        <option value="0">Selecione um cliente</option>
        <?php foreach($clients as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= ((int)$c['id']===$client_id?'selected':'') ?>><?= h($c['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  <?php endif; ?>

  <div class="col-md-4">
    <label class="form-label">Filtrar por Loja</label>
    <select class="form-select" name="store_id" id="storeSelect" onchange="this.form.submit()" <?php echo (is_admin_master() && $client_id<=0) ? 'disabled' : ''; ?>>
      <option value="0">Todas</option>
      <?php foreach($stores as $s): ?>
        <option value="<?= (int)$s['id'] ?>" <?= ($store_id===(int)$s['id']?'selected':'') ?>><?= h($s['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
</form>

<form method="post">
  <?php if (is_admin_master()): ?>
    <input type="hidden" name="client_id" value="<?= (int)$client_id ?>">
    <input type="hidden" name="store_id" value="<?= (int)$store_id ?>">
  <?php endif; ?>
<div class="row g-3">
  <div class="col-md-5">
    <div class="card">
      <div class="card-header d-flex justify-content-between align-items-center">
        <strong>Conteúdos</strong>
        <div class="d-flex gap-1 flex-wrap">
          <button type="button" class="btn btn-outline-secondary btn-sm" onclick="toggleAllItems(true)">Selecionar todos</button>
          <button type="button" class="btn btn-outline-secondary btn-sm" onclick="toggleAllItems(false)">Limpar todos</button>
        </div>
      </div>
      <div class="card-body" style="max-height:520px; overflow:auto;">
        <div class="mb-2 text-muted small">Itens (ofertas e mensagens)</div>
        <?php foreach($items as $it): ?>
          <?php
            $token = $it['type'].':'.(int)$it['id'];
            $is_offer = $it['type']==='offer';
          ?>
          <label class="d-flex gap-2 align-items-start border rounded p-2 mb-2 order-item" draggable="true" data-token="<?= $token ?>">
            <input type="checkbox" name="items[]" value="<?= $token ?>" class="mt-1 <?= $is_offer ? 'item-offer' : 'item-message' ?>" <?= ($pre_item===$token?'checked':'') ?>>
            <div class="flex-grow-1">
              <strong><?= h($it['name']) ?></strong>
              <?php if ($is_offer && !empty($it['title'])): ?>
                <div class="text-muted small"><?= h($it['title']) ?></div>
              <?php endif; ?>
              <div>
                <span class="badge <?= $is_offer ? 'bg-primary' : 'bg-secondary' ?>"><?= $is_offer ? 'Oferta' : 'Mensagem' ?></span>
              </div>
            </div>
            <div class="d-flex align-items-center gap-1 ms-auto">
              <button type="button" class="btn btn-outline-secondary btn-sm" onclick="moveItem(this, -1)" title="Subir">↑</button>
              <button type="button" class="btn btn-outline-secondary btn-sm" onclick="moveItem(this, 1)" title="Descer">↓</button>
              <input type="number" class="form-control form-control-sm" style="width:70px" name="item_order[<?= $token ?>]" placeholder="Ordem">
            </div>
          </label>
        <?php endforeach; ?>
      </div>
    </div>
  </div>

  <div class="col-md-4">
    <div class="card">
      <div class="card-header d-flex justify-content-between align-items-center">
        <strong>Painéis</strong>
        <button type="button" class="btn btn-sm btn-outline-secondary" onclick="toggleAllPanels(true)">Selecionar todos</button>
      </div>
      <div class="card-body" style="max-height:520px; overflow:auto;">
        <?php foreach($panels as $p): ?>
          <label class="d-flex gap-2 align-items-center border rounded p-2 mb-2">
            <input type="checkbox" class="panel-checkbox" name="panels[]" value="<?= (int)$p['id'] ?>">
            <div class="d-flex flex-column">
              <strong><?= h($p['name']) ?></strong>
              <?php
                $panel_url = 'panel_contents.php?id='.(int)$p['id'];
                if (is_admin_master() && $client_id>0) $panel_url .= '&client_id='.(int)$client_id;
              ?>
              <a class="small text-decoration-none" href="<?php echo h($panel_url); ?>" target="_blank" rel="noopener">Ordenar Itens</a>
            </div>
          </label>
        <?php endforeach; ?>
        <?php if(!$panels): ?><div class="text-muted">Nenhum painel neste filtro.</div><?php endif; ?>
      </div>
      <div class="card-footer d-flex justify-content-between">
        <button type="button" class="btn btn-sm btn-outline-secondary" onclick="toggleAllPanels(false)">Limpar</button>
        <div class="text-muted small">Painéis selecionados: <span id="panelsCount">0</span></div>
      </div>
    </div>
  </div>

  <div class="col-md-3">
    <div class="card">
      <div class="card-header"><strong>Agendamento</strong></div>
      <div class="card-body">
        <div class="form-check form-switch mb-2">
          <input class="form-check-input" type="checkbox" role="switch" id="enabled" name="enabled" checked>
          <label class="form-check-label" for="enabled">Ativo</label>
        </div>

        <label class="form-label">Entrada (opcional)</label>
        <input type="datetime-local" name="starts_at" class="form-control" />
        <div class="form-text">Se vazio, entra imediatamente.</div>

        <label class="form-label mt-2">Saída (opcional)</label>
        <input type="datetime-local" name="ends_at" class="form-control" />
        <div class="form-text">Se vazio, não expira.</div>

        <label class="form-label mt-3">Modo</label>
        <select class="form-select" name="mode">
          <option value="append">Adicionar ao final</option>
          <option value="replace">Substituir playlist</option>
        </select>
        <div class="form-text">Substituir apaga a playlist atual dos painéis selecionados.</div>
      </div>
      <div class="card-footer">
        <button class="btn btn-primary w-100">Salvar</button>
      </div>
    </div>
  </div>
</div>
</form>

<script>
function toggleAllItems(state){
  document.querySelectorAll('.item-offer, .item-message').forEach(cb => cb.checked = !!state);
}
function toggleAllPanels(on){
  document.querySelectorAll('.panel-checkbox').forEach(cb => cb.checked = !!on);
  updateCount();
}
function updateCount(){
  const n = document.querySelectorAll('.panel-checkbox:checked').length;
  const el = document.getElementById('panelsCount');
  if (el) el.textContent = n;
}

function moveItem(btn, dir){
  const row = btn.closest('.order-item');
  if (!row) return;
  const sibling = dir < 0 ? row.previousElementSibling : row.nextElementSibling;
  if (!sibling) return;
  row.parentNode.insertBefore(row, dir < 0 ? sibling : sibling.nextElementSibling);
  syncOrderInputs();
  saveOrderToStorage();
}
document.querySelectorAll('.panel-checkbox').forEach(cb => cb.addEventListener('change', updateCount));
updateCount();

const clientSelect = document.getElementById('clientSelect');
const storeSelect = document.getElementById('storeSelect');
const filterForm = document.getElementById('filterForm');
if (clientSelect && filterForm) {
  clientSelect.addEventListener('change', () => filterForm.submit());
  clientSelect.addEventListener('input', () => filterForm.submit());
}
if (storeSelect && filterForm) {
  storeSelect.addEventListener('change', () => filterForm.submit());
}

function syncOrderInputs(){
  const items = document.querySelectorAll('.order-item');
  let idx = 1;
  items.forEach(item => {
    const input = item.querySelector('input[name^="item_order"]');
    if (input) input.value = idx++;
  });
}

let dragSrc = null;
function saveOrderToStorage(){
  const items = document.querySelectorAll('.order-item');
  const order = Array.from(items).map(it => it.dataset.token);
  if (order.length) localStorage.setItem('icartaz_masssend_order_' + String(<?php echo (int)$client_id; ?>), JSON.stringify(order));
}

function restoreOrderFromStorage(){
  const key = 'icartaz_masssend_order_' + String(<?php echo (int)$client_id; ?>);
  const raw = localStorage.getItem(key);
  if (!raw) return;
  let order;
  try { order = JSON.parse(raw); } catch(e){ return; }
  if (!Array.isArray(order)) return;
  const map = {};
  document.querySelectorAll('.order-item').forEach(item => {
    map[item.dataset.token] = item;
  });
  const container = document.querySelector('.card-body');
  if (!container) return;
  order.forEach(token => {
    if (map[token]) container.appendChild(map[token]);
  });
  syncOrderInputs();
}

document.querySelectorAll('.order-item').forEach(item => {
  item.addEventListener('dragstart', e => {
    dragSrc = item;
    item.classList.add('opacity-50');
    e.dataTransfer.effectAllowed = 'move';
  });
  item.addEventListener('dragend', () => {
    item.classList.remove('opacity-50');
  });
  item.addEventListener('dragover', e => {
    e.preventDefault();
    e.dataTransfer.dropEffect = 'move';
  });
  item.addEventListener('drop', e => {
    e.preventDefault();
    if (!dragSrc || dragSrc === item) return;
    item.parentNode.insertBefore(dragSrc, item);
    syncOrderInputs();
    saveOrderToStorage();
  });
});
restoreOrderFromStorage();
syncOrderInputs();

// botão removido
</script>

<?php require 'footer.php'; ?>


