<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master','admin_cliente']);

$client_id = is_admin_master() ? intval($_GET['client_id'] ?? 0) : intval($user['client_id']);
$store_id = intval($_GET['store_id'] ?? 0);
$pick = $_GET['pick'] ?? '';
$item_id_prefill = intval($_GET['item_id'] ?? 0);

$clients = [];
if (is_admin_master()) $clients = $mysqli->query("SELECT id,name FROM clients ORDER BY name")->fetch_all(MYSQLI_ASSOC);

$stores=[]; $offers=[]; $messages=[]; $panels=[];
if ($client_id>0) {
  $st = $mysqli->prepare("SELECT id,name FROM stores WHERE client_id=? ORDER BY name");
  $st->bind_param('i',$client_id); $st->execute(); $stores=$st->get_result()->fetch_all(MYSQLI_ASSOC); $st->close();

  $st=$mysqli->prepare("SELECT id,name,title FROM offers WHERE client_id=? ORDER BY updated_at DESC,id DESC");
  $st->bind_param('i',$client_id); $st->execute(); $offers=$st->get_result()->fetch_all(MYSQLI_ASSOC); $st->close();

  $st=$mysqli->prepare("SELECT id,name FROM messages WHERE client_id=? ORDER BY updated_at DESC,id DESC");
  $st->bind_param('i',$client_id); $st->execute(); $messages=$st->get_result()->fetch_all(MYSQLI_ASSOC); $st->close();

  if ($store_id>0) {
    $st=$mysqli->prepare("SELECT p.id,p.name,s.name AS store_name FROM panels p JOIN stores s ON s.id=p.store_id WHERE s.client_id=? AND s.id=? ORDER BY s.name,p.name");
    $st->bind_param('ii',$client_id,$store_id);
  } else {
    $st=$mysqli->prepare("SELECT p.id,p.name,s.name AS store_name FROM panels p JOIN stores s ON s.id=p.store_id WHERE s.client_id=? ORDER BY s.name,p.name");
    $st->bind_param('i',$client_id);
  }
  $st->execute(); $panels=$st->get_result()->fetch_all(MYSQLI_ASSOC); $st->close();
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $client_id = intval($_POST['client_id'] ?? 0);
  $store_id = intval($_POST['store_id'] ?? 0);
  $mode = $_POST['mode'] ?? 'append';
  $items = $_POST['items'] ?? [];
  $panel_ids = $_POST['panel_ids'] ?? [];

  if ($client_id<=0 || !is_array($items) || !is_array($panel_ids) || count($items)==0 || count($panel_ids)==0) {
    header("Location: mass_assign.php?client_id=".$client_id."&store_id=".$store_id."&err=1"); exit;
  }

  foreach($panel_ids as $pid) {
    $pid = intval($pid);
    if ($pid<=0) continue;
    if ($mode==='replace') $mysqli->query("DELETE FROM panel_playlist WHERE panel_id=".$pid);
    $res = $mysqli->query("SELECT COALESCE(MAX(position),0) AS maxpos FROM panel_playlist WHERE panel_id=".$pid);
    $pos = (int)($res->fetch_assoc()['maxpos'] ?? 0);

    foreach($items as $token) {
      if (strpos($token, ':')===false) continue;
      [$t,$id] = explode(':',$token,2);
      $t = ($t==='message') ? 'message' : 'offer';
      $iid = intval($id);
      if ($iid<=0) continue;
      $pos++;
      $st = $mysqli->prepare("INSERT INTO panel_playlist(panel_id,item_type,item_id,position,enabled) VALUES(?,?,?,?,1)");
      $st->bind_param('isii',$pid,$t,$iid,$pos);
      $st->execute(); $st->close();
    }
  }
  header("Location: mass_assign.php?client_id=".$client_id."&store_id=".$store_id."&ok=1"); exit;
}
?>
<h3>Envio em Massa</h3>
<p class="text-muted">Escolha conteúdos e painéis, depois envie.</p>

<?php if (!empty($_GET['ok'])): ?><div class="alert alert-success">Enviado com sucesso!</div><?php endif; ?>
<?php if (!empty($_GET['err'])): ?><div class="alert alert-danger">Selecione ao menos 1 conteúdo e 1 painel.</div><?php endif; ?>

<form method="get" class="row g-2 mb-3">
  <div class="col-md-4">
    <?php if (is_admin_master()): ?>
      <select name="client_id" class="form-select">
        <option value="0">Selecione um cliente</option>
        <?php foreach($clients as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= ((int)$c['id']===$client_id?'selected':'') ?>><?= htmlspecialchars($c['name']) ?></option>
        <?php endforeach; ?>
      </select>
    <?php else: ?>
      <input type="hidden" name="client_id" value="<?= (int)$client_id ?>">
      <div class="form-control bg-light">Cliente: #<?= (int)$client_id ?></div>
    <?php endif; ?>
  </div>
  <div class="col-md-4">
    <select name="store_id" class="form-select">
      <option value="0">Todas as lojas</option>
      <?php foreach($stores as $s): ?>
        <option value="<?= (int)$s['id'] ?>" <?= ((int)$s['id']===$store_id?'selected':'') ?>><?= htmlspecialchars($s['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-2"><button class="btn btn-outline-secondary w-100">Filtrar</button></div>
  <div class="col-md-2"><a class="btn btn-outline-primary w-100" href="panels_list.php">Voltar</a></div>
</form>

<?php if ($client_id<=0): ?>
  <div class="alert alert-info">Selecione um cliente.</div>
<?php else: ?>
<form method="post">
  <input type="hidden" name="client_id" value="<?= (int)$client_id ?>">
  <input type="hidden" name="store_id" value="<?= (int)$store_id ?>">

  <div class="row g-3">
    <div class="col-md-6">
      <div class="card">
        <div class="card-header"><strong>Conteúdos</strong></div>
        <div class="card-body" style="max-height:520px; overflow:auto;">
          <div class="mb-2 text-muted small">Ofertas</div>
          <?php foreach($offers as $o): $checked = ($pick==='offer' && $item_id_prefill===(int)$o['id']); ?>
            <div class="form-check border rounded p-2 mb-2">
              <input class="form-check-input" type="checkbox" name="items[]" value="offer:<?= (int)$o['id'] ?>" id="off<?= (int)$o['id'] ?>" <?= $checked?'checked':'' ?>>
              <label class="form-check-label w-100" for="off<?= (int)$o['id'] ?>">
                <strong><?= htmlspecialchars($o['name']) ?></strong>
                <div class="text-muted small"><?= htmlspecialchars($o['title']) ?></div>
                <div class="ratio mt-2" style="--bs-aspect-ratio:100%;">
                  <iframe src="panel_preview.php?mode=thumb&offer_id=<?= (int)$o['id'] ?>" style="border:0;width:100%;height:100%;"></iframe>
                </div>
              </label>
            </div>
          <?php endforeach; ?>

          <div class="mt-3 mb-2 text-muted small">Mensagens</div>
          <?php foreach($messages as $m): $checked = ($pick==='message' && $item_id_prefill===(int)$m['id']); ?>
            <div class="form-check border rounded p-2 mb-2">
              <input class="form-check-input" type="checkbox" name="items[]" value="message:<?= (int)$m['id'] ?>" id="msg<?= (int)$m['id'] ?>" <?= $checked?'checked':'' ?>>
              <label class="form-check-label w-100" for="msg<?= (int)$m['id'] ?>">
                <strong><?= htmlspecialchars($m['name']) ?></strong>
                <div class="ratio mt-2" style="--bs-aspect-ratio:100%;">
                  <iframe src="panel_preview.php?mode=thumb&message_id=<?= (int)$m['id'] ?>" style="border:0;width:100%;height:100%;"></iframe>
                </div>
              </label>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>

    <div class="col-md-6">
      <div class="card">
        <div class="card-header"><strong>Painéis</strong></div>
        <div class="card-body" style="max-height:520px; overflow:auto;">
          <?php foreach($panels as $p): ?>
            <div class="form-check border rounded p-2 mb-2">
              <input class="form-check-input" type="checkbox" name="panel_ids[]" value="<?= (int)$p['id'] ?>" id="p<?= (int)$p['id'] ?>">
              <label class="form-check-label" for="p<?= (int)$p['id'] ?>">
                <strong><?= htmlspecialchars($p['name']) ?></strong>
                <div class="text-muted small"><?= htmlspecialchars($p['store_name']) ?></div>
              </label>
            </div>
          <?php endforeach; ?>
        </div>
        <div class="card-footer d-flex gap-2">
          <select name="mode" class="form-select" style="max-width:220px;">
            <option value="append">Adicionar ao final</option>
            <option value="replace">Substituir playlist</option>
          </select>
          <button class="btn btn-primary">Enviar</button>
        </div>
      </div>
    </div>
  </div>
</form>
<?php endif; ?>

<?php require 'footer.php'; ?>
