<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../api/db.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $pass  = $_POST['password'] ?? '';

    $stmt = $mysqli->prepare("SELECT id, client_id, name, email, password_hash, role, is_active FROM users WHERE email=? LIMIT 1");
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($row = $res->fetch_assoc()) {
        if (!$row['is_active']) {
            $error = 'Usuário inativo.';
        } elseif (password_verify($pass, $row['password_hash'])) {
            $_SESSION['user'] = [
                'id'        => $row['id'],
                'client_id' => $row['client_id'],
                'name'      => $row['name'],
                'email'     => $row['email'],
                'role'      => $row['role']
            ];
            header('Location: dashboard.php');
            exit;
        } else {
            $error = 'E-mail ou senha inválidos.';
        }
    } else {
        $error = 'E-mail ou senha inválidos.';
    }
}
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Login - Painéis LED</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container d-flex align-items-center justify-content-center" style="min-height:100vh;">
  <div class="card shadow-sm" style="max-width:400px; width:100%;">
    <div class="card-body">
      <h4 class="card-title mb-3 text-center">Painéis de Ofertas</h4>
      <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
      <?php endif; ?>
      <form method="post">
        <div class="mb-3">
          <label class="form-label">E-mail</label>
          <input type="email" name="email" class="form-control" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Senha</label>
          <input type="password" name="password" class="form-control" required>
        </div>
        <button class="btn btn-primary w-100" type="submit">Entrar</button>
      </form>
    </div>
  </div>
</div>

</body>
</html>
