<?php
require_once __DIR__ . '/auth.php';
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Painéis LED - Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#f7f7f8; }
    .table-responsive { overflow-x:auto; -webkit-overflow-scrolling:touch; }
    .table td, .table th { white-space: nowrap; }
    .card { box-shadow: 0 6px 18px rgba(0,0,0,0.06); border: 0; }
    .card-header { background:#fff; }
    .text-clip { max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    .navbar { position: sticky; top: 0; z-index: 2000; }
    .dropdown-menu { z-index: 2100; }
    @media (max-width: 768px){
      body { font-size: 16px; }
      .container { padding-left: 12px; padding-right: 12px; }
      .table td, .table th { white-space: normal; }
      .card-header { flex-direction: column; align-items: flex-start; gap: 8px; }
      .card-header .d-flex, .card-header .btn-group { flex-wrap: wrap; gap: 6px; }
      .navbar-nav .nav-link { padding: 0.5rem 0.75rem; }
      .form-control, .form-select, .btn { font-size: 16px; }
      .btn { padding: 8px 12px; white-space: normal; }
      .card { border-radius: 12px; }
      .card-body, .card-footer { padding: 12px; }
      .list-group-item { align-items: flex-start; }
      .table { font-size: 14px; }
    }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="dashboard.php">iCartaz</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarNav">
      <!-- Menu principal (dia a dia) -->
      <ul class="navbar-nav me-auto">
        <?php if (!is_cliente_user()): ?>
          <li class="nav-item"><a class="nav-link" href="stores_list.php">Lojas</a></li>
        <?php endif; ?>
        <li class="nav-item"><a class="nav-link" href="panels_list.php">Painéis</a></li>
        <li class="nav-item"><a class="nav-link" href="agenda.php">Agenda</a></li>
        <li class="nav-item"><a class="nav-link" href="offers_list.php">Ofertas</a></li>
        <li class="nav-item"><a class="nav-link" href="messages_list.php">Mensagens</a></li>
        <li class="nav-item"><a class="nav-link" href="mass_send.php">Envio em Massa</a></li>
      </ul>

      <!-- Menu da direita (perfil + funções avançadas) -->
      <ul class="navbar-nav">
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <?= htmlspecialchars($user['name']) ?>
          </a>
          <ul class="dropdown-menu dropdown-menu-end">
            <li><h6 class="dropdown-header">Perfil: <?= htmlspecialchars($user['role']) ?></h6></li>

            <?php if (is_admin_master()): ?>
              <li><a class="dropdown-item" href="clients_list.php">Clientes</a></li>
              <li><a class="dropdown-item" href="users_list.php">Usuários</a></li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item" href="config_global.php">Configurações Globais</a></li>
              <li><a class="dropdown-item" href="painels_dashboard.php">Dashboard de Painéis (Check-in)</a></li>
              <li><a class="dropdown-item" href="commands.php">Comandos</a></li>
              <li><a class="dropdown-item" href="ota_admin.php">OTA (Admin)</a></li>
            <?php endif; ?>

            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item" href="logout.php">Sair</a></li>
          </ul>
        </li>
      </ul>
    </div>
  </div>
</nav>
<div class="container">
