<?php
require_once __DIR__ . '/auth.php';
require_role(['admin_master']);
require_once __DIR__ . '/header.php';
require_once __DIR__ . '/../api/_db.php';
header("Content-Type: text/html; charset=utf-8");

date_default_timezone_set('America/Sao_Paulo');
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$ONLINE_SECONDS = 360;
$now = time();

$clients = $pdo->query("SELECT id,name FROM clients ORDER BY name")->fetchAll();

$stPanels = $pdo->prepare("
  SELECT p.id,p.panel_key,p.name,p.location,
         c.id AS client_id,c.name AS client_name
  FROM ic_panels p
  INNER JOIN panels pp ON pp.panel_key = p.panel_key
  LEFT JOIN stores s ON s.id = pp.store_id
  LEFT JOIN clients c ON c.id = s.client_id
  ORDER BY p.panel_key ASC
");
$stPanels->execute();
$panels = $stPanels->fetchAll();

// Latest checkin per panel
$lastMap = [];
$stLast = $pdo->query("
  SELECT c.panel_id,c.fw_version,c.ip_local,c.rssi,c.wifi_ssid,c.status,c.created_at
  FROM ic_panel_checkins c
  INNER JOIN (
    SELECT panel_id, MAX(id) AS max_id
    FROM ic_panel_checkins
    GROUP BY panel_id
  ) t ON t.max_id = c.id
");
foreach ($stLast->fetchAll() as $row) {
  $lastMap[(int)$row['panel_id']] = $row;
}

// Latest LED command per panel
$ledMap = [];
$stLed = $pdo->query("
  SELECT c.panel_id,c.cmd
  FROM ic_panel_commands c
  INNER JOIN (
    SELECT panel_id, MAX(id) AS max_id
    FROM ic_panel_commands
    WHERE cmd IN ('leds_on','leds_off')
    GROUP BY panel_id
  ) t ON t.max_id = c.id
");
foreach ($stLed->fetchAll() as $row) {
  $ledMap[(int)$row['panel_id']] = $row['cmd'];
}

// Latest Rescue command per panel
$rescueMap = [];
$stRes = $pdo->query("
  SELECT c.panel_id,c.cmd
  FROM ic_panel_commands c
  INNER JOIN (
    SELECT panel_id, MAX(id) AS max_id
    FROM ic_panel_commands
    WHERE cmd IN ('rescue','rescue_off')
    GROUP BY panel_id
  ) t ON t.max_id = c.id
");
foreach ($stRes->fetchAll() as $row) {
  $rescueMap[(int)$row['panel_id']] = $row['cmd'];
}

$stSet = $pdo->prepare("SELECT use_schedule,on_time,off_time FROM panel_settings WHERE panel_id=? LIMIT 1");

$panelMeta = [];
foreach ($panels as $p) {
  $pid = (int)$p['id'];
  $last = $lastMap[$pid] ?? null;
  $seenTs = $last && !empty($last['created_at']) ? strtotime($last['created_at']) : 0;
  $online = $seenTs && (($now - $seenTs) <= $ONLINE_SECONDS);
  $ledCmd = $ledMap[$pid] ?? '';
  $resCmd = $rescueMap[$pid] ?? '';
  $panelMeta[$p['panel_key']] = [
    'panel_key' => $p['panel_key'],
    'name' => $p['name'] ?? '',
    'location' => $p['location'] ?? '',
    'client_id' => $p['client_id'] ?? '',
    'client_name' => $p['client_name'] ?? '',
    'fw' => $last['fw_version'] ?? '',
    'seen' => $last['created_at'] ?? '',
    'status' => $last['status'] ?? '',
    'ip' => $last['ip_local'] ?? '',
    'rssi' => $last['rssi'] ?? '',
    'ssid' => $last['wifi_ssid'] ?? '',
    'leds' => $ledCmd === 'leds_on' ? 'ON' : ($ledCmd === 'leds_off' ? 'OFF' : ''),
    'rescue' => $resCmd === 'rescue' ? 'ON' : ($resCmd === 'rescue_off' ? 'OFF' : ''),
    'online' => $online ? 1 : 0,
  ];
}
?>

<style>
  .cmd-card{
    border:1px solid rgba(0,0,0,.08);
    border-radius:14px;
    background:#fff;
    box-shadow:0 10px 24px rgba(0,0,0,.08);
  }
  .cmd-btn{
    width:100%;
    min-height:90px;
    border-radius:16px;
    font-size:20px;
    font-weight:700;
    display:flex;
    align-items:center;
    justify-content:center;
    gap:10px;
  }
  .cmd-sub{
    font-size:12px;
    color:#6c757d;
  }
  .cmd-grid{
    display:grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap:16px;
  }
  .cmd-icon{
    font-size:22px;
    line-height:1;
  }
  .panel-list{
    max-height: none;
    overflow: visible;
    border:1px solid rgba(0,0,0,.08);
    border-radius:10px;
    background:#fff;
    width:100%;
  }
  .panel-item{
    display:flex;
    align-items:center;
    gap:10px;
    padding:12px 14px;
    border-bottom:1px solid rgba(0,0,0,.06);
    width:100%;
  }
  .panel-item:last-child{ border-bottom:0; }
  .panel-item:nth-child(even){ background:#f1f3f5; }
  .panel-title-row{
    display:flex;
    align-items:center;
    gap:12px;
    flex-wrap:wrap;
  }
  .panel-title{ font-weight:600; }
  .panel-tags{ display:flex; align-items:center; gap:8px; flex-wrap:wrap; }
  .panel-meta{
    display:flex;
    flex-wrap:wrap;
    gap:10px 16px;
    font-size:13px;
    color:#6c757d;
  }
  .panel-meta strong{ color:#111; font-weight:600; }
  .cmd-result{
    font-size:16px;
    font-weight:600;
    padding:12px 14px;
    border-radius:12px;
    border:1px solid rgba(0,0,0,.08);
    background:#f8f9fa;
  }
  .cmd-result.success{ background:#eaf7ef; border-color:#bfe3c9; color:#0f5132; }
  .cmd-result.warning{ background:#fff4e5; border-color:#ffd8a8; color:#664d03; }
  .cmd-result.danger{ background:#fdecea; border-color:#f5c2c7; color:#842029; }
  .page-bottom-space{ height:24px; }
  .badge-dot{
    display:inline-flex;
    align-items:center;
    gap:6px;
    font-size:12px;
    padding:2px 8px;
    border-radius:999px;
    background:#f1f3f5;
    color:#111;
  }
  .badge-dot .dot{
    width:8px; height:8px; border-radius:50%;
    background:#adb5bd;
  }
  .badge-dot.online .dot{ background:#198754; }
  .badge-dot.offline .dot{ background:#dc3545; }
  .actions-wrap{ margin-bottom:16px; }
  .schedule-card .form-check-label{ font-weight:600; }
  .schedule-card .btn-apply{ min-width:160px; }
</style>

<div class="d-flex align-items-center justify-content-between mb-3 flex-wrap gap-2">
  <div>
    <h3 class="mb-0">Comandos do Painel</h3>
    <div class="text-secondary small">Escolha o painel e envie comandos com um clique.</div>
  </div>
  <a class="btn btn-outline-secondary" href="painels_dashboard.php">Dashboard</a>
</div>

<div class="actions-wrap">
  <div class="cmd-grid">
    <button type="button" class="btn btn-outline-danger cmd-btn cmd-action" data-cmd="restart" data-confirm="Reiniciar o painel agora?">
      <span class="cmd-icon">&#x23FB;</span> Reiniciar
    </button>
    <button type="button" class="btn btn-success cmd-btn cmd-action" data-cmd="leds_on">
      <span class="cmd-icon">&#x1F4A1;</span> LEDs ON
    </button>
    <button type="button" class="btn btn-danger cmd-btn cmd-action" data-cmd="leds_off">
      <span class="cmd-icon">&#x1F4A1;</span> LEDs OFF
    </button>
    <button type="button" class="btn btn-outline-primary cmd-btn cmd-action" data-cmd="rescue" data-confirm="Ativar RESCUE?" data-payload='{"confirm":"YES"}'>
      <span class="cmd-icon">&#x1F6DF;</span> Rescue ON
    </button>
    <button type="button" class="btn btn-outline-secondary cmd-btn cmd-action" data-cmd="rescue_off" data-confirm="Desativar RESCUE?">
      <span class="cmd-icon">&#x1F6DF;</span> Rescue OFF
    </button>
  </div>
</div>

<div class="card cmd-card mb-3 schedule-card">
  <div class="card-body">
    <div class="row g-3 align-items-end">
      <div class="col-12 col-lg-4">
        <div class="form-check">
          <input class="form-check-input" type="checkbox" id="schedule-use">
          <label class="form-check-label" for="schedule-use">Usar horário automático</label>
        </div>
        <div class="cmd-sub mt-1">Aplicar para os painéis selecionados.</div>
      </div>
      <div class="col-6 col-lg-3">
        <label class="form-label mb-1">Hora de ligar</label>
        <input type="time" class="form-control" id="schedule-on" value="08:00">
      </div>
      <div class="col-6 col-lg-3">
        <label class="form-label mb-1">Hora de desligar</label>
        <input type="time" class="form-control" id="schedule-off" value="22:00">
      </div>
      <div class="col-12 col-lg-2 d-grid">
        <button type="button" class="btn btn-primary btn-apply" id="schedule-apply">Aplicar horário</button>
      </div>
    </div>
  </div>
</div>

<div class="cmd-result mb-3" id="cmd-result">Nenhum comando enviado ainda.</div>

<div class="card cmd-card mb-3">
  <div class="card-body">
    <div class="row g-3 align-items-end">
      <div class="col-12">
        <label class="form-label">Painel</label>
        <div class="row g-2 mb-2">
          <div class="col-12 col-lg-7">
            <input type="text" id="panel-filter" class="form-control" placeholder="Buscar painel...">
          </div>
          <div class="col-12 col-lg-5">
            <select id="client-filter" class="form-select">
              <option value="">Todos os clientes</option>
              <?php foreach ($clients as $c): ?>
                <option value="<?php echo (int)$c['id']; ?>"><?php echo h($c['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
        </div>
        <div class="panel-list" id="panel-list">
          <?php foreach($panels as $p): ?>
            <?php
              $meta = $panelMeta[$p['panel_key']] ?? null;
              $isOnline = $meta && !empty($meta['online']);
              $leds = $meta['leds'] ?? '';
              $rescue = $meta['rescue'] ?? '';
              $stSet->execute([(int)$p['id']]);
              $cfg = $stSet->fetch();
              if(!$cfg){ $cfg = ['use_schedule'=>0,'on_time'=>'08:00','off_time'=>'22:00']; }
              $schedule_label = $cfg['use_schedule'] ? ($cfg['on_time'].' - '.$cfg['off_time']) : 'desativada';
            ?>
            <label class="panel-item"
                   data-online="<?php echo $isOnline ? '1' : '0'; ?>"
                   data-leds="<?php echo h($leds); ?>"
                   data-rescue="<?php echo h($rescue); ?>"
                   data-client="<?php echo (int)($p['client_id'] ?? 0); ?>">
              <input class="form-check-input panel-check" type="checkbox" value="<?php echo h($p['panel_key']); ?>">
              <div>
                <div class="panel-title-row">
                  <div class="panel-title"><?php echo h($p['panel_key']); ?> — <?php echo h($p['name'] ?: 'Sem nome'); ?><?php echo $p['location'] ? ' • '.h($p['location']) : ''; ?></div>
                  <div class="panel-tags">
                    <span class="badge-dot <?php echo $isOnline ? 'online' : 'offline'; ?>">
                      <span class="dot"></span> <?php echo $isOnline ? 'ONLINE' : 'OFFLINE'; ?>
                    </span>
                    <?php if ($leds === 'ON'): ?>
                      <span class="badge bg-success">LEDs ON</span>
                    <?php elseif ($leds === 'OFF'): ?>
                      <span class="badge bg-danger">LEDs OFF</span>
                    <?php endif; ?>
                    <?php if ($rescue === 'ON'): ?>
                      <span class="badge bg-warning text-dark">Rescue ON</span>
                    <?php endif; ?>
                    <span class="badge bg-light text-dark border">Horario: <?php echo h($schedule_label); ?></span>
                  </div>
                </div>
              </div>
            </label>
          <?php endforeach; ?>
        </div>
        <div class="d-flex gap-2 mt-2">
          <button type="button" class="btn btn-sm btn-outline-secondary" id="select-all">Selecionar todos</button>
          <button type="button" class="btn btn-sm btn-outline-secondary" id="clear-all">Limpar seleção</button>
        </div>
        <div class="cmd-sub mt-2" id="panel-selected">Nenhum painel selecionado.</div>
      </div>
      <div class="col-12">
        <div class="panel-meta" id="panel-meta">
          <div>Firmware: <strong id="meta-fw">-</strong></div>
          <div>Visto: <strong id="meta-seen">-</strong></div>
          <div>Status: <strong id="meta-status">-</strong></div>
          <div>LEDs: <strong id="meta-leds">-</strong></div>
          <div>Rescue: <strong id="meta-rescue">-</strong></div>
          <div>IP: <strong id="meta-ip">-</strong></div>
          <div>RSSI: <strong id="meta-rssi">-</strong></div>
          <div>SSID: <strong id="meta-ssid">-</strong></div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="page-bottom-space"></div>

<script>
  (function(){
    var panels = <?php echo json_encode($panelMeta, JSON_UNESCAPED_UNICODE); ?> || {};
    var list = document.getElementById('panel-list');
    var filter = document.getElementById('panel-filter');
    var clientFilter = document.getElementById('client-filter');
    var label = document.getElementById('panel-selected');
    var selectAll = document.getElementById('select-all');
    var clearAll = document.getElementById('clear-all');
    var actions = document.querySelectorAll('.cmd-action');
    var result = document.getElementById('cmd-result');
    var scheduleUse = document.getElementById('schedule-use');
    var scheduleOn = document.getElementById('schedule-on');
    var scheduleOff = document.getElementById('schedule-off');
    var scheduleApply = document.getElementById('schedule-apply');

    var metaFw = document.getElementById('meta-fw');
    var metaSeen = document.getElementById('meta-seen');
    var metaStatus = document.getElementById('meta-status');
    var metaLeds = document.getElementById('meta-leds');
    var metaRescue = document.getElementById('meta-rescue');
    var metaIp = document.getElementById('meta-ip');
    var metaRssi = document.getElementById('meta-rssi');
    var metaSsid = document.getElementById('meta-ssid');

    function getSelected(){
      var out = [];
      document.querySelectorAll('.panel-check:checked').forEach(function(el){
        out.push(el.value);
      });
      return out;
    }

    function updateSelectedLabel(){
      var sel = getSelected();
      if(sel.length === 0){
        label.textContent = 'Nenhum painel selecionado.';
      } else if(sel.length === 1){
        label.textContent = 'Painel selecionado: ' + sel[0];
      } else {
        label.textContent = 'Painéis selecionados: ' + sel.length;
      }

      if(sel.length === 1 && panels[sel[0]]){
        var p = panels[sel[0]];
        metaFw.textContent = p.fw || '-';
        metaSeen.textContent = p.seen || '-';
        metaStatus.textContent = p.status || '-';
        metaLeds.textContent = p.leds || '-';
        metaRescue.textContent = p.rescue || '-';
        metaIp.textContent = p.ip || '-';
        metaRssi.textContent = p.rssi || '-';
        metaSsid.textContent = p.ssid || '-';
      } else {
        metaFw.textContent = '-';
        metaSeen.textContent = '-';
        metaStatus.textContent = '-';
        metaLeds.textContent = '-';
        metaRescue.textContent = '-';
        metaIp.textContent = '-';
        metaRssi.textContent = '-';
        metaSsid.textContent = '-';
      }
    }

    list.addEventListener('change', function(e){
      if(e.target && e.target.classList.contains('panel-check')){
        updateSelectedLabel();
      }
    });

    function applyTextFilter(){
      var v = filter.value.toLowerCase();
      var clientVal = clientFilter ? clientFilter.value : '';
      document.querySelectorAll('.panel-item').forEach(function(row){
        var text = row.textContent.toLowerCase();
        var textOk = text.indexOf(v) >= 0;
        var clientOk = !clientVal || row.getAttribute('data-client') === clientVal;
        if(textOk && clientOk) {
          if(row.dataset.hiddenByFilter === '1') return;
          row.style.display = '';
        } else {
          row.style.display = 'none';
        }
      });
    }
    filter.addEventListener('input', applyTextFilter);
    if(clientFilter){
      clientFilter.addEventListener('change', applyTextFilter);
    }

    selectAll.addEventListener('click', function(){
      document.querySelectorAll('.panel-check').forEach(function(el){ el.checked = true; });
      updateSelectedLabel();
    });
    clearAll.addEventListener('click', function(){
      document.querySelectorAll('.panel-check').forEach(function(el){ el.checked = false; });
      updateSelectedLabel();
    });

    function setResult(message, level){
      if(!result) return;
      result.classList.remove('success','warning','danger');
      if(level) result.classList.add(level);
      result.textContent = message;
    }

    function levelForCmd(cmd){
      if(cmd === 'restart' || cmd === 'rescue' || cmd === 'rescue_off') return 'warning';
      if(cmd === 'leds_off') return 'danger';
      return 'success';
    }

    actions.forEach(function(btn){
      btn.addEventListener('click', function(){
        var sel = getSelected();
        if(sel.length === 0){
          alert('Selecione ao menos um painel.');
          return;
        }
        var confirmMsg = btn.getAttribute('data-confirm');
        if(confirmMsg && !confirm(confirmMsg)) return;

        var cmd = btn.getAttribute('data-cmd');
        var payload = btn.getAttribute('data-payload');
        var payloadObj = null;
        if(payload){
          try { payloadObj = JSON.parse(payload); } catch(e){ payloadObj = null; }
        }
        var userName = <?php echo json_encode($user['name'] ?? '', JSON_UNESCAPED_UNICODE); ?>;

        setResult('Enviando comando "' + cmd + '" para ' + sel.length + ' painel(is)...', levelForCmd(cmd));

        var done = 0;
        var ok = 0;
        sel.forEach(function(pk){
          fetch('../api/panel_cmd.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ panel_key: pk, cmd: cmd, payload: Object.assign({ by: userName }, payloadObj || {}) })
          }).then(function(r){
            return r.json().catch(function(){ return { ok: false }; });
          }).then(function(resp){
            done++;
            if(resp && resp.ok) ok++;
            if(done === sel.length){
              setResult('Comando "' + cmd + '" enviado. Sucesso: ' + ok + ' / ' + sel.length + '.', levelForCmd(cmd));
            }
          }).catch(function(){
            done++;
            if(done === sel.length){
              setResult('Comando "' + cmd + '" enviado. Sucesso: ' + ok + ' / ' + sel.length + '.', levelForCmd(cmd));
            }
          });
        });
      });
    });

    if (scheduleApply) {
      scheduleApply.addEventListener('click', function(){
        var sel = getSelected();
        if(sel.length === 0){
          alert('Selecione ao menos um painel.');
          return;
        }
        var onTime = scheduleOn ? scheduleOn.value : '';
        var offTime = scheduleOff ? scheduleOff.value : '';
        if(!onTime || !offTime){
          alert('Informe os horários de ligar e desligar.');
          return;
        }
        if(!confirm('Aplicar horário para ' + sel.length + ' painel(is)?')) return;

        var useSchedule = scheduleUse && scheduleUse.checked ? 1 : 0;
        setResult('Aplicando horário para ' + sel.length + ' painel(is)...', 'warning');

        fetch('../api/panel_schedule.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({
            panel_keys: sel,
            use_schedule: useSchedule,
            on_time: onTime,
            off_time: offTime
          })
        }).then(function(r){
          return r.json().catch(function(){ return { ok: false }; });
        }).then(function(resp){
          if(resp && resp.ok){
            var missing = (resp.missing && resp.missing.length) ? (' | Nao encontrados: ' + resp.missing.join(', ')) : '';
            setResult('Horario aplicado. Sucesso: ' + resp.updated + ' / ' + sel.length + '.' + missing, 'success');
          } else {
            setResult('Falha ao aplicar horario.', 'danger');
          }
        }).catch(function(){
          setResult('Falha ao aplicar horario.', 'danger');
        });
      });
    }

    updateSelectedLabel();
  })();
</script>

<?php require_once __DIR__ . '/footer.php'; ?>
