<?php
require_once 'header.php';
require_once __DIR__ . '/../api/db.php';
require_role(['admin_master']);

$id = intval($_GET['id'] ?? 0);
$client = ['id'=>0,'name'=>'','document'=>''];

if ($id > 0) {
    $stmt = $mysqli->prepare("SELECT * FROM clients WHERE id=?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $client = $stmt->get_result()->fetch_assoc();
    if (!$client) { echo "Cliente não encontrado."; require 'footer.php'; exit; }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $doc  = $_POST['document'] ?? '';
    if ($id > 0) {
        $stmt = $mysqli->prepare("UPDATE clients SET name=?, document=? WHERE id=?");
        $stmt->bind_param('ssi', $name, $doc, $id);
    } else {
        $stmt = $mysqli->prepare("INSERT INTO clients (name, document) VALUES (?,?)");
        $stmt->bind_param('ss', $name, $doc);
    }
    if ($stmt->execute()) {
        header('Location: clients_list.php');
        exit;
    } else {
        echo '<div class="alert alert-danger">Erro ao salvar.</div>';
    }
}
?>
<h3><?= $id>0 ? 'Editar' : 'Novo' ?> Cliente</h3>
<form method="post" style="max-width:400px;">
  <div class="mb-3">
    <label class="form-label">Nome</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($client['name']) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Documento</label>
    <input type="text" name="document" class="form-control" value="<?= htmlspecialchars($client['document']) ?>">
  </div>
  <button class="btn btn-primary" type="submit">Salvar</button>
  <a href="clients_list.php" class="btn btn-secondary">Voltar</a>
</form>
<?php require 'footer.php'; ?>
