// led_sim_atlas_preload.js
// Preload reduzido e escalonado. Ajuste 'commons' para os tamanhos que você realmente gerou.
(function(){
  // ajuste esta lista para os tamanhos disponíveis no seu /admin/fonts
  const commons = [12, 16, 20]; // ex.: 12,16,20 - ajuste conforme ls -1 admin/fonts
  const STAGGER_MS = 250;

  function tryLoad(lines){
    if(typeof LED_SIM === 'undefined' || !LED_SIM.loadAtlas) return;
    try {
      LED_SIM.loadAtlas(lines, function(err){
        if(err) console.debug('[atlas-preload] failed', lines, err && err.message);
        else console.debug('[atlas-preload] ok', lines);
      });
    } catch(e){ console.debug('[atlas-preload] exception', e); }
  }

  window.addEventListener && window.addEventListener('load', function(){
    commons.forEach(function(l, i){
      setTimeout(function(){ tryLoad(l); }, i * STAGGER_MS);
    });
  });
})();