<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
require_once __DIR__ . '/auth.php';
require_role(['admin_master','admin_cliente']);
require_once __DIR__ . '/header.php';
require_once __DIR__ . '/../api/_db.php'; // $pdo

date_default_timezone_set('America/Sao_Paulo');
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function parse_dt_local($s) {
  $s = trim((string)$s);
  if ($s==='') return null;
  $s = str_replace('T',' ',$s);
  $dt = DateTime::createFromFormat('Y-m-d H:i', $s);
  if (!$dt) {
    $dt = DateTime::createFromFormat('Y-m-d H:i:s', $s);
  }
  if (!$dt) return false;
  return $dt->format('Y-m-d H:i:s');
}

$is_master = (function_exists('is_admin_master') && is_admin_master());

// Client scope
$client_id = null;
if ($is_master) {
  $client_id = isset($_GET['client_id']) && $_GET['client_id'] !== '' ? (int)$_GET['client_id'] : null;
} else {
  $client_id = (int)($user['client_id'] ?? 0);
}

$item_type = isset($_GET['type']) && in_array($_GET['type'], ['offer','message'], true) ? $_GET['type'] : 'all';
$status = isset($_GET['status']) && in_array($_GET['status'], ['all','ativo','programado'], true) ? $_GET['status'] : 'all';

$month = isset($_GET['month']) && preg_match('/^\d{4}-\d{2}$/', $_GET['month']) ? $_GET['month'] : date('Y-m');
$month_start = $month . '-01';
$month_ts = strtotime($month_start);
$month_end = date('Y-m-t', $month_ts);
$month_end_ts = strtotime($month_end . ' 23:59:59');

// Build dropdowns
$clients = [];
if ($is_master) {
  $clients = $pdo->query("SELECT id, name FROM clients ORDER BY name")->fetchAll();
}

$panels = [];
if ($client_id) {
  $stPanels = $pdo->prepare("
    SELECT p.id, p.name, p.panel_key, s.name AS store_name
    FROM panels p
    JOIN stores s ON s.id=p.store_id
    WHERE s.client_id = :client_id
    ORDER BY s.name, p.name
  ");
  $stPanels->execute([':client_id' => (int)$client_id]);
  $panels = $stPanels->fetchAll();
}

$offers = [];
$messages = [];
if ($client_id) {
  $stOffers = $pdo->prepare("SELECT id,name,title FROM offers WHERE client_id=? ORDER BY updated_at DESC, id DESC");
  $stOffers->execute([(int)$client_id]);
  $offers = $stOffers->fetchAll();
  $stMessages = $pdo->prepare("SELECT id,name FROM messages WHERE client_id=? ORDER BY updated_at DESC, id DESC");
  $stMessages->execute([(int)$client_id]);
  $messages = $stMessages->fetchAll();
}

$selected_panels = [];
if (!empty($_GET['panels']) && is_array($_GET['panels'])) {
  foreach ($_GET['panels'] as $pid) {
    $pid = (int)$pid;
    if ($pid > 0) $selected_panels[] = $pid;
  }
}
if (!$selected_panels && $panels) {
  foreach ($panels as $p) $selected_panels[] = (int)$p['id'];
}

// Palette for panels
$palette = ['#2563eb','#16a34a','#dc2626','#9333ea','#0f766e','#d97706','#db2777','#7c3aed','#0891b2','#4d7c0f'];
$panel_colors = [];
$panel_labels = [];
$pi = 0;
foreach ($panels as $p) {
  $pid = (int)$p['id'];
  $panel_colors[$pid] = $palette[$pi % count($palette)];
  $panel_labels[$pid] = ($p['panel_key'] ?? '') ?: ($p['name'] ?? '');
  $pi++;
}

$flash_error = '';
$flash_success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'add_schedule') {
  $post_client_id = (int)($_POST['client_id'] ?? 0);
  $item_type = ($_POST['item_type'] ?? '') === 'message' ? 'message' : 'offer';
  $item_id = (int)($_POST['item_id'] ?? 0);
  $starts_on = trim((string)($_POST['starts_on'] ?? ''));
  $ends_on = trim((string)($_POST['ends_on'] ?? ''));
  $enabled = isset($_POST['enabled']) ? 1 : 0;
  $panel_ids = $_POST['panel_ids'] ?? [];
  if (!is_array($panel_ids)) $panel_ids = [];

  if ($post_client_id <= 0 || !$item_id || !$starts_on) {
    $flash_error = 'Informe cliente, item e dia inicial.';
  } else {
    $starts_at = $starts_on . ' 00:00:00';
    $ends_at = $ends_on !== '' ? ($ends_on . ' 23:59:59') : null;
    if ($ends_at && strtotime($ends_at) < strtotime($starts_at)) {
      $flash_error = 'Data final não pode ser menor que a inicial.';
    } else {
      if ($item_type === 'offer') {
        $stChk = $pdo->prepare("SELECT id FROM offers WHERE id=? AND client_id=?");
      } else {
        $stChk = $pdo->prepare("SELECT id FROM messages WHERE id=? AND client_id=?");
      }
      $stChk->execute([$item_id, $post_client_id]);
      $okItem = $stChk->fetchColumn();
      if (!$okItem) {
        $flash_error = 'Item inválido para este cliente.';
      } else {
        $clean_panels = [];
        foreach ($panel_ids as $pid) {
          $pid = (int)$pid;
          if ($pid > 0) $clean_panels[] = $pid;
        }
        if (!$clean_panels) {
          $flash_error = 'Selecione ao menos um painel.';
        } else {
          $placeholders = implode(',', array_fill(0, count($clean_panels), '?'));
          $stAllowed = $pdo->prepare("
            SELECT p.id
            FROM panels p
            JOIN stores s ON s.id=p.store_id
            WHERE s.client_id=? AND p.id IN ($placeholders)
          ");
          $params = [$post_client_id];
          foreach ($clean_panels as $pid) $params[] = $pid;
          $stAllowed->execute($params);
          $allowed = array_map('intval', $stAllowed->fetchAll(PDO::FETCH_COLUMN));
          if (!$allowed) {
            $flash_error = 'Nenhum painel válido para este cliente.';
          } else {
            $stMax = $pdo->prepare("SELECT COALESCE(MAX(position),0) FROM panel_playlist WHERE panel_id=?");
            $stPos = $pdo->prepare("SELECT position FROM panel_playlist WHERE panel_id=? AND item_type=? AND item_id=?");
            $stIns = $pdo->prepare("
              INSERT INTO panel_playlist(panel_id,item_type,item_id,position,enabled,starts_at,ends_at)
              VALUES(?,?,?,?,?,?,?)
              ON DUPLICATE KEY UPDATE enabled=VALUES(enabled), starts_at=VALUES(starts_at), ends_at=VALUES(ends_at), updated_at=NOW()
            ");
            $saved = 0;
            foreach ($allowed as $pid) {
              $stPos->execute([$pid, $item_type, $item_id]);
              $pos = $stPos->fetchColumn();
              if ($pos === false) {
                $stMax->execute([$pid]);
                $maxPos = (int)$stMax->fetchColumn();
                $pos = $maxPos + 1;
              } else {
                $pos = (int)$pos;
              }
              $stIns->execute([
                $pid,
                $item_type,
                $item_id,
                $pos,
                $enabled,
                $starts_at,
                $ends_at
              ]);
              $saved++;
            }
            $flash_success = 'Programação salva para ' . $saved . ' painel(is).';
          }
        }
      }
    }
  }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'update_schedule') {
  $post_client_id = (int)($_POST['client_id'] ?? 0);
  $item_type = ($_POST['item_type'] ?? '') === 'message' ? 'message' : 'offer';
  $item_id = (int)($_POST['item_id'] ?? 0);
  $starts_at = parse_dt_local($_POST['starts_at'] ?? '');
  $ends_at = parse_dt_local($_POST['ends_at'] ?? '');
  $panel_id = (int)($_POST['panel_id'] ?? 0);

  if ($post_client_id <= 0 || !$item_id || $panel_id <= 0) {
    $flash_error = 'Informe item, cliente e painel.';
  } elseif ($starts_at === false || $ends_at === false) {
    $flash_error = 'Data/hora inv?lida.';
  } else {
    if ($ends_at && $starts_at && strtotime($ends_at) < strtotime($starts_at)) {
      $flash_error = 'Data final n?o pode ser menor que a inicial.';
    } else {
      if ($item_type === 'offer') {
        $stChk = $pdo->prepare("SELECT id FROM offers WHERE id=? AND client_id=?");
      } else {
        $stChk = $pdo->prepare("SELECT id FROM messages WHERE id=? AND client_id=?");
      }
      $stChk->execute([$item_id, $post_client_id]);
      $okItem = $stChk->fetchColumn();
      if (!$okItem) {
        $flash_error = 'Item inv?lido para este cliente.';
      } else {
        $stAllowed = $pdo->prepare("
          SELECT p.id
          FROM panels p
          JOIN stores s ON s.id=p.store_id
          WHERE s.client_id=? AND p.id=?
        ");
        $stAllowed->execute([$post_client_id, $panel_id]);
        $allowed = (int)$stAllowed->fetchColumn();
        if (!$allowed) {
          $flash_error = 'Nenhum painel v?lido para este cliente.';
        } else {
          $sql = "UPDATE panel_playlist SET starts_at=?, ends_at=?, updated_at=NOW() WHERE item_type=? AND item_id=? AND panel_id=?";
          $stUp = $pdo->prepare($sql);
          $stUp->execute([$starts_at, $ends_at, $item_type, $item_id, $panel_id]);
          $flash_success = 'Programa??o atualizada.';
        }
      }
    }
  }
}


// status filter computed in SQL using NOW()
$statusSql = "pl.enabled=1 AND (pl.ends_at IS NULL OR pl.ends_at>=NOW())";
if ($status !== 'all') {
  if ($status === 'inativo') {
    $statusSql = "pl.enabled=0";
  } elseif ($status === 'ativo') {
    $statusSql = "pl.enabled=1 AND (pl.starts_at IS NULL OR pl.starts_at<=NOW()) AND (pl.ends_at IS NULL OR pl.ends_at>=NOW())";
  } elseif ($status === 'programado') {
    $statusSql = "pl.enabled=1 AND pl.starts_at IS NOT NULL AND pl.starts_at>NOW()";
  } elseif ($status === 'expirado') {
    $statusSql = "pl.enabled=1 AND pl.ends_at IS NOT NULL AND pl.ends_at<NOW()";
  }
}

$rows = [];
if ($client_id && $selected_panels) {
  $panel_placeholders = implode(',', array_fill(0, count($selected_panels), '?'));
  $where = [
    "c.id = ?",
    "pl.panel_id IN ($panel_placeholders)",
    $statusSql,
    "(
      (pl.starts_at IS NULL AND pl.ends_at IS NULL)
      OR (pl.starts_at IS NOT NULL AND pl.starts_at <= ? AND (pl.ends_at IS NULL OR pl.ends_at >= ?))
      OR (pl.ends_at IS NOT NULL AND pl.ends_at >= ? AND (pl.starts_at IS NULL OR pl.starts_at <= ?))
    )"
  ];
  if ($item_type !== 'all') $where[] = "pl.item_type = ?";

  $sql = "
    SELECT
      pl.id,
      pl.panel_id,
      pl.item_type,
      pl.item_id,
      pl.enabled,
      pl.starts_at,
      pl.ends_at,
      pl.position,
      pl.updated_at,
      p.name AS panel_name,
      p.panel_key,
      s.name AS store_name,
      c.name AS client_name,
      o.name AS offer_name,
      o.title AS offer_title,
      m.name AS message_title
    FROM panel_playlist pl
    JOIN panels p ON p.id=pl.panel_id
    JOIN stores s ON s.id=p.store_id
    JOIN clients c ON c.id=s.client_id
    LEFT JOIN offers o ON (pl.item_type='offer' AND o.id=pl.item_id)
    LEFT JOIN messages m ON (pl.item_type='message' AND m.id=pl.item_id)
    WHERE " . implode(' AND ', $where) . "
    ORDER BY pl.starts_at IS NULL, pl.starts_at ASC, pl.ends_at IS NULL, pl.ends_at ASC, p.name, pl.position
  ";

  $params = [];
  $params[] = (int)$client_id;
  foreach ($selected_panels as $pid) $params[] = (int)$pid;
  $params[] = $month_end . ' 23:59:59';
  $params[] = $month_start . ' 00:00:00';
  $params[] = $month_start . ' 00:00:00';
  $params[] = $month_end . ' 23:59:59';
  if ($item_type !== 'all') $params[] = $item_type;

  $stRows = $pdo->prepare($sql);
  $stRows->execute($params);
  $rows = $stRows->fetchAll();
}

// Index rows by day (expand ranges)
$days = [];
$no_schedule = [];
$no_schedule_by_panel = [];
$is_current_month = ($month === date('Y-m'));
$month_start_ts = strtotime($month_start . ' 00:00:00');
$month_end_ts = strtotime($month_end . ' 23:59:59');
foreach ($rows as $r) {
  $start = $r['starts_at'] ? strtotime($r['starts_at']) : null;
  $end = $r['ends_at'] ? strtotime($r['ends_at']) : null;
  if (!$start && !$end) {
    if ($is_current_month) {
      $no_schedule[] = $r;
      $pid = (int)$r['panel_id'];
      if (!isset($no_schedule_by_panel[$pid])) $no_schedule_by_panel[$pid] = [];
      $no_schedule_by_panel[$pid][] = $r;
    }
    continue;
  }

  $range_start = $start ?: $month_start_ts;
  $range_end = $end ?: $month_end_ts;
  if ($range_end < $month_start_ts || $range_start > $month_end_ts) {
    continue;
  }
  if ($range_start < $month_start_ts) $range_start = $month_start_ts;
  if ($range_end > $month_end_ts) $range_end = $month_end_ts;

  for ($d = strtotime(date('Y-m-d', $range_start)); $d <= $range_end; $d = strtotime('+1 day', $d)) {
    $day_key = date('Y-m-d', $d);
    $item_key = $day_key.'|'.$r['item_type'].'|'.$r['item_id'].'|'.(string)$r['starts_at'].'|'.(string)$r['ends_at'];
    if (!isset($days[$day_key])) $days[$day_key] = [];
    if (!isset($days[$day_key][$item_key])) {
      $days[$day_key][$item_key] = [
        'item' => $r,
        'panels' => []
      ];
    }
    $days[$day_key][$item_key]['panels'][(int)$r['panel_id']] = true;
  }
}

function status_badge($r){
  $enabled = (int)$r['enabled'] === 1;
  if (!$enabled) return ['Inativo', '#6b7280'];
  $now = time();
  $st = $r['starts_at'] ? strtotime($r['starts_at']) : null;
  $en = $r['ends_at'] ? strtotime($r['ends_at']) : null;
  if ($st && $st > $now) return ['Programado', '#2563eb'];
  if ($en && $en < $now) return ['Expirado', '#dc2626'];
  return ['Ativo', '#16a34a'];
}
?>

<style>
  .calendar-wrap{ background:#fff; border:1px solid rgba(0,0,0,.08); border-radius:12px; }
  .calendar-wrap{ margin-bottom:24px; }
  .calendar-header{ display:flex; align-items:center; justify-content:space-between; padding:12px 16px; border-bottom:1px solid rgba(0,0,0,.06); }
  .calendar-grid{ display:grid; grid-template-columns: repeat(7, 1fr); }
  .cal-cell{ min-height:120px; border-right:1px solid rgba(0,0,0,.06); border-bottom:1px solid rgba(0,0,0,.06); padding:8px; }
  .cal-cell:nth-child(7n){ border-right:0; }
  .cal-cell.clickable{ cursor:pointer; }
  .cal-day{ font-size:12px; color:#6c757d; margin-bottom:6px; }
  .cal-weekday{ font-weight:600; font-size:12px; color:#6c757d; padding:8px; border-bottom:1px solid rgba(0,0,0,.06); text-align:center; }
  .cal-item{ display:flex; gap:6px; align-items:flex-start; margin-bottom:6px; padding:6px 8px; border-radius:8px; background:#eef1f4; font-size:12px; }
  .cal-item.cal-edit{ cursor:pointer; }
  .cal-panels{ display:flex; flex-wrap:wrap; gap:6px; margin-top:4px; }
  .cal-panel{ display:inline-flex; align-items:center; gap:4px; font-size:11px; color:#374151; background:#eef2f7; border-radius:999px; padding:2px 6px; }
  .cal-panel .dot{ width:8px; height:8px; border-radius:50%; }
  .cal-time{ display:flex; flex-wrap:wrap; gap:6px; margin-top:4px; }
  .time-tag{ display:inline-flex; align-items:center; gap:4px; font-size:10px; border-radius:999px; padding:2px 6px; }
  .time-tag.time-in{ background:#d1fae5; color:#065f46; }
  .time-tag.time-out{ background:#fee2e2; color:#7f1d1d; }
  .cal-range{ font-size:10px; color:#6b7280; margin-top:4px; }
  .cal-title{ font-weight:600; color:#111; }
  .cal-title-row{ display:flex; flex-wrap:wrap; gap:6px; align-items:center; }
  .cal-sub{ color:#6c757d; }
  .panel-legend{ display:flex; flex-wrap:wrap; gap:8px 12px; margin-top:8px; }
  .legend-item{ display:flex; align-items:center; gap:6px; font-size:12px; }
  .legend-color{ width:10px; height:10px; border-radius:50%; }
  .panel-checks{ max-height:220px; overflow:auto; border:1px solid rgba(0,0,0,.08); border-radius:10px; padding:8px; background:#fff; }
  .panel-checks label{ display:flex; align-items:center; gap:8px; padding:6px 4px; border-bottom:1px solid rgba(0,0,0,.04); font-size:13px; }
  .panel-checks label:last-child{ border-bottom:0; }
  .filter-card{ border:1px solid rgba(0,0,0,.08); border-radius:12px; background:#fff; padding:12px; }
  .panel-row{ display:flex; align-items:center; justify-content:space-between; gap:12px; padding:10px 8px; border-bottom:1px solid rgba(0,0,0,.06); }
  .panel-row:last-child{ border-bottom:0; }
  .panel-row .left{ display:flex; align-items:center; gap:10px; }
  .panel-row .right{ display:flex; flex-wrap:wrap; gap:6px; justify-content:flex-end; }
  .pill{ display:inline-flex; align-items:center; gap:6px; background:#eef2f7; border-radius:999px; padding:2px 8px; font-size:11px; color:#374151; }
  .pill .dot{ width:8px; height:8px; border-radius:50%; }
  .modal-dialog{ margin:90px auto 32px; }
  @media (max-width: 576px){
    .modal-dialog{ margin:70px auto 24px; }
  }
</style>

<div class="container mt-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="m-0">Agenda (Calendario)</h2>
  </div>

  <form method="get" class="row g-2 align-items-end mb-3">
    <?php if($is_master): ?>
      <div class="col-md-3">
        <label class="form-label">Cliente</label>
        <select name="client_id" class="form-select" onchange="this.form.submit()">
          <option value="">(Selecione)</option>
          <?php foreach($clients as $c): ?>
            <option value="<?php echo (int)$c['id']; ?>" <?php echo ($client_id==(int)$c['id'])?'selected':''; ?>><?php echo h($c['name']); ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    <?php endif; ?>

    <div class="col-md-2">
      <label class="form-label">Mes</label>
      <input type="month" name="month" class="form-control" value="<?php echo h($month); ?>">
    </div>

    <div class="col-md-2">
      <label class="form-label">Tipo</label>
      <select name="type" class="form-select">
        <option value="all" <?php echo $item_type==='all'?'selected':''; ?>>Todos</option>
        <option value="offer" <?php echo $item_type==='offer'?'selected':''; ?>>Ofertas</option>
        <option value="message" <?php echo $item_type==='message'?'selected':''; ?>>Mensagens</option>
      </select>
    </div>

    <div class="col-md-2">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="all" <?php echo $status==='all'?'selected':''; ?>>Todos</option>
        <option value="ativo" <?php echo $status==='ativo'?'selected':''; ?>>Ativo</option>
        <option value="programado" <?php echo $status==='programado'?'selected':''; ?>>Programado</option>
      </select>
    </div>

    <div class="col-md-3">
      <button class="btn btn-primary w-100">Filtrar</button>
    </div>
  </form>

  <?php if($is_master && !$client_id): ?>
    <div class="alert alert-info">Selecione um cliente para ver a agenda.</div>
  <?php else: ?>

  <?php if($flash_success): ?>
    <div class="alert alert-success"><?php echo h($flash_success); ?></div>
  <?php elseif($flash_error): ?>
    <div class="alert alert-danger"><?php echo h($flash_error); ?></div>
  <?php endif; ?>

  <div class="filter-card mb-3">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <div class="form-label m-0">Paineis (marque para mostrar)</div>
      <a class="btn btn-sm btn-primary" href="mass_send.php<?php echo $is_master && $client_id ? '?client_id='.(int)$client_id : ''; ?>">Adicionar programacao</a>
    </div>
    <div class="panel-checks">
      <?php foreach($panels as $p): ?>
        <?php
          $pid = (int)$p['id'];
          $checked = in_array($pid, $selected_panels, true);
          $items = $no_schedule_by_panel[$pid] ?? [];
        ?>
        <div class="panel-row">
          <label class="left">
            <input type="checkbox" name="panels[]" value="<?php echo $pid; ?>" <?php echo $checked ? 'checked' : ''; ?> form="panel-filter-form">
            <span class="legend-color" style="background:<?php echo h($panel_colors[$pid] ?? '#6b7280'); ?>"></span>
            <span><?php echo h($p['store_name'].' - '.$p['name'].' ('.$p['panel_key'].')'); ?></span>
          </label>
          <div class="right">
            <?php if ($is_current_month && $items): ?>
              <?php foreach($items as $r): ?>
                <?php
                  $title = $r['item_type'] === 'offer' ? ($r['offer_name'] ?: ('#'.$r['item_id'])) : ($r['message_title'] ?: ('#'.$r['item_id']));
                ?>
                <span class="pill">
                  <span class="dot" style="background:<?php echo h($panel_colors[$pid] ?? '#6b7280'); ?>"></span>
                  <?php echo h($title); ?>
                </span>
              <?php endforeach; ?>
            <?php else: ?>
              <span class="text-muted small">Sem programacao direta</span>
            <?php endif; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
    <form id="panel-filter-form" method="get" class="d-none">
      <?php if($is_master && $client_id): ?><input type="hidden" name="client_id" value="<?php echo (int)$client_id; ?>"><?php endif; ?>
      <input type="hidden" name="month" value="<?php echo h($month); ?>">
      <input type="hidden" name="type" value="<?php echo h($item_type); ?>">
      <input type="hidden" name="status" value="<?php echo h($status); ?>">
      <button type="submit"></button>
    </form>
    <div class="panel-legend">
      <?php foreach($panels as $p): $pid = (int)$p['id']; ?>
        <div class="legend-item">
          <span class="legend-color" style="background:<?php echo h($panel_colors[$pid] ?? '#6b7280'); ?>"></span>
          <span><?php echo h($p['panel_key']); ?></span>
        </div>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="calendar-wrap">
    <div class="calendar-header">
      <div><strong><?php echo h(date('F Y', $month_ts)); ?></strong></div>
      <div class="text-muted" style="font-size:12px;">Legenda por painel</div>
    </div>
    <div class="calendar-grid">
      <?php $weekdays = ['Dom','Seg','Ter','Qua','Qui','Sex','Sab']; ?>
      <?php foreach($weekdays as $wd): ?>
        <div class="cal-weekday"><?php echo $wd; ?></div>
      <?php endforeach; ?>

      <?php
        $first_wday = (int)date('w', $month_ts);
        $days_in_month = (int)date('t', $month_ts);
        $cell_count = $first_wday + $days_in_month;
        $rows_needed = (int)ceil($cell_count / 7);
        $total_cells = $rows_needed * 7;
      ?>

      <?php for($i=0; $i<$total_cells; $i++): ?>
        <?php
          $day_num = $i - $first_wday + 1;
          $in_month = ($day_num >= 1 && $day_num <= $days_in_month);
          $day_key = $in_month ? date('Y-m-', $month_ts).str_pad($day_num, 2, '0', STR_PAD_LEFT) : '';
        ?>
        <div class="cal-cell" style="background:<?php echo $in_month ? '#fff' : '#f8f9fa'; ?>;">
          <?php if($in_month): ?>
            <div class="cal-day"><?php echo $day_num; ?></div>
            <?php if(!empty($days[$day_key])): ?>
              <?php foreach($days[$day_key] as $group): ?>
                <?php
                  $r = $group['item'];
                  $title = $r['item_type'] === 'offer' ? ($r['offer_name'] ?: ('#'.$r['item_id'])) : ($r['message_title'] ?: ('#'.$r['item_id']));
                  $sub = $r['item_type'] === 'offer' ? ($r['offer_title'] ?? '') : '';
                  $start_date = $r['starts_at'] ? date('Y-m-d', strtotime($r['starts_at'])) : '';
                  $end_date = $r['ends_at'] ? date('Y-m-d', strtotime($r['ends_at'])) : '';
                  $start_time = $r['starts_at'] ? date('H:i', strtotime($r['starts_at'])) : '';
                  $end_time = $r['ends_at'] ? date('H:i', strtotime($r['ends_at'])) : '';
                  $range_text = '';
                  if ($r['starts_at'] || $r['ends_at']) {
                    $range_start = $r['starts_at'] ? date('d/m H:i', strtotime($r['starts_at'])) : 'agora';
                    $range_end = $r['ends_at'] ? date('d/m H:i', strtotime($r['ends_at'])) : 'sem fim';
                    $range_text = $range_start . ' -> ' . $range_end;
                  }
                ?>
                <div class="cal-item cal-edit"
                     data-item-type="<?php echo h($r['item_type']); ?>"
                     data-item-id="<?php echo (int)$r['item_id']; ?>"
                     data-starts-at="<?php echo h($r['starts_at'] ?? ''); ?>"
                     data-ends-at="<?php echo h($r['ends_at'] ?? ''); ?>"
                     data-panel-ids="<?php echo h(implode(',', array_keys($group['panels']))); ?>">
                  <div>
                    <div class="cal-title-row">
                      <div class="cal-title"><?php echo h($title); ?></div>
                      <?php if($start_date && $day_key === $start_date): ?>
                        <span class="time-tag time-in">Entra <?php echo h($start_time ?: ''); ?></span>
                      <?php endif; ?>
                      <?php if($end_date && $day_key === $end_date): ?>
                        <span class="time-tag time-out">Sai <?php echo h($end_time ?: ''); ?></span>
                      <?php endif; ?>
                    </div>
                    <?php if($range_text): ?>
                      <div class="cal-range">Período: <?php echo h($range_text); ?></div>
                    <?php endif; ?>
                    <div class="cal-panels">
                      <?php foreach(array_keys($group['panels']) as $pid): ?>
                        <?php $color = $panel_colors[(int)$pid] ?? '#6b7280'; $label = $panel_labels[(int)$pid] ?? ('#'.$pid); ?>
                        <span class="cal-panel">
                          <span class="dot" style="background:<?php echo h($color); ?>"></span>
                          <?php echo h($label); ?>
                        </span>
                      <?php endforeach; ?>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            <?php endif; ?>
          <?php endif; ?>
        </div>
      <?php endfor; ?>
    </div>
  </div>

  <?php endif; ?>
</div>

<div class="modal fade" id="editScheduleModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post">
        <input type="hidden" name="action" value="update_schedule">
        <input type="hidden" name="client_id" value="<?php echo (int)$client_id; ?>">
        <input type="hidden" name="item_type" id="edit-item-type" value="">
        <input type="hidden" name="item_id" id="edit-item-id" value="">
        <div class="modal-header">
          <h5 class="modal-title">Editar programação</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Entrada</label>
            <input type="datetime-local" class="form-control" name="starts_at" id="edit-starts-at">
          </div>
          <div class="mb-3">
            <label class="form-label">Saída</label>
            <input type="datetime-local" class="form-control" name="ends_at" id="edit-ends-at">
          </div>
          <div class="mb-2 form-label">Painéis</div>
          <div class="panel-checks" id="edit-panels-list">
            <?php foreach($panels as $p): $pid = (int)$p['id']; ?>
              <label>
                <input type="radio" name="panel_id" class="edit-panel-check" value="<?php echo $pid; ?>">
                <span style="display:inline-flex; align-items:center; gap:6px;">
                  <span class="legend-color" style="background:<?php echo h($panel_colors[$pid] ?? '#6b7280'); ?>"></span>
                  <?php echo h($p['store_name'].' - '.$p['name'].' ('.$p['panel_key'].')'); ?>
                </span>
              </label>
            <?php endforeach; ?>
          </div>
          <div class="form-text mt-2">Selecione um painel para atualizar.</div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button class="btn btn-primary" id="edit-save-btn">Atualizar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  (function(){
    var checks = document.querySelectorAll('input[name="panels[]"]');
    var form = document.getElementById('panel-filter-form');
    if (!form || !checks.length) return;
    checks.forEach(function(chk){
      chk.addEventListener('change', function(){
        form.submit();
      });
    });
  })();

</script>

<script>
  (function(){
    var modalEl = document.getElementById('editScheduleModal');
    if (!modalEl) return;
    var bsModal = (window.bootstrap && bootstrap.Modal) ? new bootstrap.Modal(modalEl) : null;
    var inputType = document.getElementById('edit-item-type');
    var inputId = document.getElementById('edit-item-id');
    var inputStart = document.getElementById('edit-starts-at');
    var inputEnd = document.getElementById('edit-ends-at');
    var panelChecks = document.querySelectorAll('.edit-panel-check');
    var saveBtn = document.getElementById('edit-save-btn');

    function toLocal(dt) {
      if (!dt) return '';
      return String(dt).replace(' ', 'T').slice(0,16);
    }

    function showFallbackModal() {
      modalEl.style.display = 'block';
      modalEl.classList.add('show');
      modalEl.removeAttribute('aria-hidden');
      document.body.classList.add('modal-open');
      var backdrop = document.createElement('div');
      backdrop.className = 'modal-backdrop fade show';
      backdrop.setAttribute('data-agenda-backdrop', '1');
      document.body.appendChild(backdrop);
      backdrop.addEventListener('click', hideFallbackModal);
    }

    function hideFallbackModal() {
      modalEl.style.display = 'none';
      modalEl.classList.remove('show');
      modalEl.setAttribute('aria-hidden', 'true');
      document.body.classList.remove('modal-open');
      document.querySelectorAll('[data-agenda-backdrop="1"]').forEach(function(el){
        el.remove();
      });
    }

    function openModal(el){
      inputType.value = el.dataset.itemType || '';
      inputId.value = el.dataset.itemId || '';
      inputStart.value = toLocal(el.dataset.startsAt || '');
      inputEnd.value = toLocal(el.dataset.endsAt || '');
      var ids = (el.dataset.panelIds || '').split(',').filter(Boolean);
      var picked = ids.length ? ids[0] : '';
      panelChecks.forEach(function(chk){
        chk.checked = (chk.value === picked);
      });
      if (bsModal) bsModal.show();
      else showFallbackModal();
    }

    document.addEventListener('click', function(e){
      var el = e.target.closest('.cal-edit');
      if (!el) return;
      openModal(el);
    });

    modalEl.querySelectorAll('[data-bs-dismiss="modal"]').forEach(function(btn){
      btn.addEventListener('click', function(){
        if (!bsModal) hideFallbackModal();
      });
    });

    if (saveBtn) {
      saveBtn.addEventListener('click', function(e){
        if (!confirm('Atualizar programação deste painel?')) {
          e.preventDefault();
          return false;
        }
        var any = false;
        panelChecks.forEach(function(chk){
          if (chk.checked) any = true;
        });
        if (!any) {
          alert('Selecione um painel.');
          e.preventDefault();
          return false;
        }
      });
    }
  })();
</script>

<?php include __DIR__ . '/footer.php'; ?>
